/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.InterpolatedPlot;

public class Carpet
extends InterpolatedPlot {
    public Carpet(GridData griddata) {
        super(griddata);
        this.setShowGridLines(false);
    }

    public void setTopRow(double[][] line) {
        if (this.image == null) {
            return;
        }
        if (this.rgbData[0].length != this.image.getWidth() * this.image.getHeight()) {
            return;
        }
        if (this.griddata instanceof ArrayData) {
            for (int c = 0; c < line.length; ++c) {
                double[][] data = this.griddata.getData()[c];
                int len = data[0].length - 1;
                int nx = data.length;
                for (int ix = 0; ix < nx; ++ix) {
                    System.arraycopy(data[ix], 0, data[ix], 1, len);
                    data[ix][0] = line[c][ix];
                }
            }
        } else {
            double[][][] data = this.griddata.getData();
            int nx = data.length;
            for (int ix = 0; ix < nx; ++ix) {
                int ny;
                int len = line.length;
                for (int iy = ny = data[0].length - 1; iy > 0; --iy) {
                    System.arraycopy(data[ix][iy - 1], 2, data[ix][iy], 2, len);
                }
                for (int c = 0; c < len; ++c) {
                    data[ix][0][2 + c] = line[c][ix];
                }
            }
        }
        double dy = (this.griddata.getBottom() - this.griddata.getTop()) / (double)(this.image.getHeight() - 1);
        int nr = 1 + (int)Math.abs(this.griddata.getDy() / dy);
        int offset = nr * this.image.getWidth();
        int length = this.rgbData[0].length - offset;
        System.arraycopy(this.rgbData[0], 0, this.rgbData[0], offset, length);
        System.arraycopy(this.rgbData[1], 0, this.rgbData[1], offset, length);
        System.arraycopy(this.rgbData[2], 0, this.rgbData[2], offset, length);
        byte[] rgb = new byte[3];
        double y = this.griddata.getTop();
        double dx = (this.griddata.getRight() - this.griddata.getLeft()) / (double)(this.image.getWidth() - 1);
        for (int i = 0; i < nr; ++i) {
            double x = this.griddata.getLeft();
            int col = this.image.getWidth();
            for (int j = 0; j < col; ++j) {
                this.colorMap.doubleToComponents(this.griddata.interpolate(x, y, this.ampIndex), rgb);
                int index = i * col + j;
                this.rgbData[0][index] = rgb[0];
                this.rgbData[1][index] = rgb[1];
                this.rgbData[2][index] = rgb[2];
                x += dx;
            }
            y += dy;
        }
    }
}

