/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Random;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.ByteLattice;
import org.opensourcephysics.display2d.CellLattice;
import org.opensourcephysics.display2d.SiteLattice;

public class CellLatticePC
extends MeasuredImage
implements ByteLattice {
    WritableRaster raster;
    Grid grid;
    int ny;
    int nx;
    int[][] rgb = new int[256][3];
    byte[][] data;
    private JFrame legendFrame;

    public CellLatticePC() {
        this(1, 1);
    }

    public CellLatticePC(int _nx, int _ny) {
        this.ny = Math.max(1, _ny);
        this.nx = Math.max(1, _nx);
        this.createDefaultColors();
        this.data = new byte[this.nx][this.ny];
        this.image = new BufferedImage(this.nx, this.ny, 1);
        this.raster = this.image.getRaster();
        this.xmin = 0.0;
        this.xmax = this.nx;
        this.ymin = 0.0;
        this.ymax = this.ny;
        this.grid = new Grid(this.nx, this.ny, this.xmin, this.xmax, this.ymin, this.ymax);
        this.grid.setColor(Color.lightGray);
        for (int ix = 0; ix < this.nx; ++ix) {
            for (int iy = 0; iy < this.ny; ++iy) {
                this.raster.setPixel(ix, iy, this.rgb[0]);
            }
        }
    }

    public SiteLattice createSiteLattice() {
        SiteLattice lattice = new SiteLattice(this.nx, this.ny);
        lattice.setBlock(this.data);
        lattice.setMinMax(this.getXMin(), this.getXMax(), this.getYMin(), this.getYMax());
        Color[] colors = new Color[this.rgb.length];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = new Color(this.rgb[i][0], this.rgb[i][1], this.rgb[i][2]);
        }
        lattice.setColorPalette(colors);
        return lattice;
    }

    public void resizeLattice(int _nx, int _ny) {
        this.ny = _ny;
        this.nx = _nx;
        this.data = new byte[this.nx][this.ny];
        this.image = new BufferedImage(this.nx, this.ny, 1);
        this.raster = this.image.getRaster();
        Grid oldGrid = this.grid;
        this.grid = new Grid(this.nx, this.ny, this.xmin, this.xmax, this.ymin, this.ymax);
        if (oldGrid != null) {
            this.grid.setColor(oldGrid.getColor());
            this.grid.setVisible(oldGrid.isVisible());
        }
        for (int ix = 0; ix < this.nx; ++ix) {
            for (int iy = 0; iy < this.ny; ++iy) {
                this.raster.setPixel(ix, iy, this.rgb[0]);
            }
        }
        this.setMinMax(0.0, this.nx, 0.0, this.ny);
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public void setMinMax(double xmin, double xmax, double ymin, double ymax) {
        super.setMinMax(xmin, xmax, ymin, ymax);
        this.grid.setMinMax(xmin, xmax, ymin, ymax);
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        super.draw(panel, g);
        this.grid.draw(panel, g);
    }

    public void setAll(byte[][] val) {
        if (this.getNx() != val.length || this.getNy() != val[0].length) {
            this.resizeLattice(val.length, val[0].length);
        }
        this.setBlock(0, 0, val);
    }

    public void setAll(byte[][] val, double xmin, double xmax, double ymin, double ymax) {
        this.setAll(val);
        this.setMinMax(xmin, xmax, ymin, ymax);
    }

    public void setBlock(byte[][] val) {
        this.setBlock(0, 0, val);
    }

    public void setBlock(int ix_offset, int iy_offset, byte[][] val) {
        if (iy_offset < 0 || iy_offset + val[0].length > this.ny) {
            throw new IllegalArgumentException("Y index out of range in byte lattice setSiteBlock.");
        }
        if (ix_offset < 0 || ix_offset + val.length > this.nx) {
            throw new IllegalArgumentException("X index out of range in byte lattice setSiteBlock.");
        }
        int my = val[0].length + iy_offset;
        for (int iy = iy_offset; iy < my; ++iy) {
            int mx = val.length + ix_offset;
            for (int ix = ix_offset; ix < mx; ++ix) {
                this.data[ix][iy] = val[ix - ix_offset][iy - iy_offset];
                this.raster.setPixel(ix, this.ny - iy - 1, this.rgb[this.data[ix][iy] & 0xFF]);
            }
        }
    }

    public void setBlock(int ix_offset, int iy_offset, int[][] val) {
        if (iy_offset < 0 || iy_offset + val[0].length > this.ny) {
            throw new IllegalArgumentException("Y index out of range in byte lattice setSiteBlock.");
        }
        if (ix_offset < 0 || ix_offset + val.length > this.nx) {
            throw new IllegalArgumentException("X index out of range in byte lattice setSiteBlock.");
        }
        int my = val[0].length + iy_offset;
        for (int iy = iy_offset; iy < my; ++iy) {
            int mx = val.length + ix_offset;
            for (int ix = ix_offset; ix < mx; ++ix) {
                this.data[ix][iy] = (byte)val[ix - ix_offset][iy - iy_offset];
                this.raster.setPixel(ix, this.ny - iy - 1, this.rgb[this.data[ix][iy] & 0xFF]);
            }
        }
    }

    public void setCol(int ix, int iy_offset, byte[] val) {
        if (iy_offset < 0 || iy_offset + val.length > this.ny) {
            throw new IllegalArgumentException("Y offset out of range in binary lattice setCol.");
        }
        if (ix < 0 || ix >= this.nx) {
            throw new IllegalArgumentException("X index out of range in binary lattice setCol.");
        }
        int my = val.length + iy_offset;
        for (int iy = iy_offset; iy < my; ++iy) {
            this.data[ix][iy] = val[iy - iy_offset];
            this.raster.setPixel(ix, this.ny - iy - 1, this.rgb[this.data[ix][iy] & 0xFF]);
        }
    }

    public void setRow(int iy, int ix_offset, byte[] val) {
        if (iy < 0 || iy >= this.ny) {
            throw new IllegalArgumentException("Y index out of range in binary lattice setRow.");
        }
        if (ix_offset < 0 || ix_offset + val.length > this.nx) {
            throw new IllegalArgumentException("X offset out of range in binary lattice setRow.");
        }
        int mx = val.length + ix_offset;
        for (int xindex = ix_offset; xindex < mx; ++xindex) {
            this.data[xindex][iy] = val[xindex - ix_offset];
            this.raster.setPixel(xindex, this.ny - iy - 1, this.rgb[this.data[xindex][iy] & 0xFF]);
        }
    }

    public void setValue(int ix, int iy, byte val) {
        this.data[ix][iy] = val;
        this.raster.setPixel(ix, this.ny - iy - 1, this.rgb[val & 0xFF]);
    }

    public byte getValue(int ix, int iy) {
        return this.data[ix][iy];
    }

    public int indexFromPoint(double x, double y) {
        int nx = this.getNx();
        int ny = this.getNy();
        double xMin = this.getXMin();
        double xMax = this.getXMax();
        double yMin = this.getYMin();
        double yMax = this.getYMax();
        double deltaX = (x - xMin) / (xMax - xMin);
        double deltaY = (y - yMin) / (yMax - yMin);
        int ix = (int)(deltaX * (double)nx);
        int iy = (int)(deltaY * (double)ny);
        if (ix < 0 || iy < 0 || ix >= nx || iy >= ny) {
            return -1;
        }
        return iy * nx + ix;
    }

    public int xToIndex(double x) {
        double xMax;
        int nx = this.getNx();
        double xMin = this.getXMin();
        double deltaX = (x - xMin) / ((xMax = this.getXMax()) - xMin);
        int ix = (int)(deltaX * (double)nx);
        if (ix < 0) {
            return 0;
        }
        if (ix >= nx) {
            return nx - 1;
        }
        return ix;
    }

    public int yToIndex(double y) {
        double yMax;
        int ny = this.getNy();
        double yMin = this.getYMin();
        double deltaY = (y - yMin) / ((yMax = this.getYMax()) - yMin);
        int iy = (int)(deltaY * (double)ny);
        if (iy < 0) {
            return 0;
        }
        if (iy >= ny) {
            return ny - 1;
        }
        return iy;
    }

    public void setShowGridLines(boolean showGridLines) {
        this.grid.setVisible(showGridLines);
    }

    public void randomize() {
        Random random = new Random();
        int my = this.data[0].length;
        for (int iy = 0; iy < my; ++iy) {
            int mx = this.data.length;
            for (int ix = 0; ix < mx; ++ix) {
                this.data[ix][iy] = (byte)random.nextInt(256);
                this.raster.setPixel(ix, this.ny - iy - 1, this.rgb[this.data[ix][iy] & 0xFF]);
            }
        }
    }

    public JFrame showLegend() {
        InteractivePanel dp = new InteractivePanel();
        dp.setPreferredSize(new Dimension(300, 66));
        dp.setGutters(0, 0, 0, 35);
        dp.setClipAtGutter(false);
        if (this.legendFrame == null) {
            this.legendFrame = new JFrame("Legend");
        }
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(dp);
        CellLattice lattice = new CellLattice(256, 1);
        lattice.setMinMax(-128.0, 127.0, 0.0, 1.0);
        byte[][] data = new byte[256][1];
        for (int i = 0; i < 256; ++i) {
            data[i][0] = (byte)(-128 + i);
        }
        lattice.setBlock(0, 0, data);
        dp.addDrawable(lattice);
        XAxis xaxis = new XAxis("");
        xaxis.setLocationType(2);
        xaxis.setLocation(-0.5);
        xaxis.setEnabled(true);
        dp.addDrawable(xaxis);
        this.legendFrame.pack();
        ((Component)this.legendFrame).setVisible(true);
        return this.legendFrame;
    }

    public void setColorPalette(Color[] colors) {
        int i;
        int n = Math.min(256, colors.length);
        for (i = 0; i < n; ++i) {
            this.rgb[i][0] = colors[i].getRed();
            this.rgb[i][1] = colors[i].getGreen();
            this.rgb[i][2] = colors[i].getBlue();
        }
        for (i = colors.length; i < 256; ++i) {
            this.rgb[i][0] = 0;
            this.rgb[i][1] = 0;
            this.rgb[i][2] = 0;
        }
        for (int ix = 0; ix < this.nx; ++ix) {
            for (int iy = 0; iy < this.ny; ++iy) {
                this.raster.setPixel(ix, this.ny - iy - 1, this.rgb[this.data[ix][iy] & 0xFF]);
            }
        }
    }

    public void setGridLineColor(Color color) {
        this.grid.setColor(color);
    }

    public void setIndexedColor(int i, Color color) {
        i = (i + 256) % this.rgb.length;
        this.rgb[i][0] = color.getRed();
        this.rgb[i][1] = color.getGreen();
        this.rgb[i][2] = color.getBlue();
        for (int ix = 0; ix < this.nx; ++ix) {
            for (int iy = 0; iy < this.ny; ++iy) {
                this.raster.setPixel(ix, this.ny - iy - 1, this.rgb[this.data[ix][iy] & 0xFF]);
            }
        }
    }

    public void createDefaultColors() {
        for (int i = 0; i < 256; ++i) {
            double x = i < 128 ? (double)(i - 100) / 255.0 : -1.0;
            double val = Math.exp(-x * x * 8.0);
            this.rgb[i][0] = (int)(255.0 * val);
            x = i < 128 ? (double)i / 255.0 : (double)(255 - i) / 255.0;
            val = Math.exp(-x * x * 8.0);
            this.rgb[i][1] = (int)(255.0 * val);
            x = i < 128 ? -1.0 : (double)(i - 156) / 255.0;
            val = Math.exp(-x * x * 8.0);
            this.rgb[i][2] = (int)(255.0 * val);
        }
    }
}

