/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ComplexInterpolatedPlot;
import org.opensourcephysics.display2d.GridData;

public class ComplexCarpet
extends ComplexInterpolatedPlot {
    public ComplexCarpet(GridData griddata) {
        super(griddata);
        this.setShowGridLines(false);
    }

    public void clearData() {
        if (this.griddata instanceof ArrayData) {
            double[][][] data = this.griddata.getData();
            int nx = this.griddata.getNx();
            for (int ix = 0; ix < nx; ++ix) {
                int ny = this.griddata.getNy();
                for (int iy = 0; iy < ny; ++iy) {
                    data[0][ix][iy] = 0.0;
                    data[1][ix][iy] = 0.0;
                    data[2][ix][iy] = 0.0;
                }
            }
        } else {
            double[][][] data = this.griddata.getData();
            int nx = this.griddata.getNx();
            for (int ix = 0; ix < nx; ++ix) {
                int ny = this.griddata.getNy();
                for (int iy = 0; iy < ny; ++iy) {
                    data[nx][ny][2] = 0.0;
                    data[nx][ny][3] = 0.0;
                    data[nx][ny][4] = 0.0;
                }
            }
        }
        this.update();
    }

    public void setTopRow(double[][] line) {
        if (this.image == null) {
            return;
        }
        if (this.rgbData[0].length != this.image.getWidth() * this.image.getHeight()) {
            return;
        }
        if (this.griddata instanceof ArrayData) {
            for (int c = 0; c < line.length; ++c) {
                double[][] data = this.griddata.getData()[c];
                int len = data[0].length - 1;
                int nx = data.length;
                for (int ix = 0; ix < nx; ++ix) {
                    System.arraycopy(data[ix], 0, data[ix], 1, len);
                    data[ix][0] = line[c][ix];
                }
            }
        } else {
            double[][][] data = this.griddata.getData();
            int nx = data.length;
            for (int ix = 0; ix < nx; ++ix) {
                int ny;
                int len = line.length;
                for (int iy = ny = data[0].length - 1; iy > 0; --iy) {
                    System.arraycopy(data[ix][iy - 1], 2, data[ix][iy], 2, len);
                }
                for (int c = 0; c < len; ++c) {
                    data[ix][0][2 + c] = line[c][ix];
                }
            }
        }
        double dy = (this.griddata.getBottom() - this.griddata.getTop()) / (double)(this.image.getHeight() - 1);
        int nr = 1 + (int)Math.abs(this.griddata.getDy() / dy);
        int offset = nr * this.image.getWidth();
        int length = this.rgbData[0].length - offset;
        System.arraycopy(this.rgbData[0], 0, this.rgbData[0], offset, length);
        System.arraycopy(this.rgbData[1], 0, this.rgbData[1], offset, length);
        System.arraycopy(this.rgbData[2], 0, this.rgbData[2], offset, length);
        double[] samples = new double[3];
        int[] indexes = new int[]{this.ampIndex, this.reIndex, this.imIndex};
        byte[] rgb = new byte[3];
        double y = this.griddata.getTop();
        double dx = (this.griddata.getRight() - this.griddata.getLeft()) / (double)(this.image.getWidth() - 1);
        int my = this.image.getHeight();
        for (int j = 0; j < nr; ++j) {
            double x = this.griddata.getLeft();
            int mx = this.image.getWidth();
            for (int i = 0; i < mx; ++i) {
                this.colorMap.samplesToComponents(this.griddata.interpolate(x, y, indexes, samples), rgb);
                int index = dy < 0.0 ? j * mx + i : (my - j - 1) * mx + i;
                this.rgbData[0][index] = rgb[0];
                this.rgbData[1][index] = rgb[1];
                this.rgbData[2][index] = rgb[2];
                x += dx;
            }
            y += dy;
        }
    }

    public void setAutoscaleZ(boolean isAutoscale, double floor, double ceil) {
        this.setAutoscaleZ(isAutoscale, ceil);
    }
}

