/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.JFrame;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ComplexColorMapper;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;

public class ComplexInterpolatedPlot
extends MeasuredImage
implements Plot2D {
    GridData griddata;
    byte[][] rgbData;
    Grid grid;
    ComplexColorMapper colorMap;
    boolean autoscaleZ = true;
    int ampIndex = 0;
    int reIndex = 1;
    int imIndex = 2;
    int leftPix;
    int rightPix;
    int topPix;
    int bottomPix;
    int ixsize;
    int iysize;
    double top;
    double left;
    double bottom;
    double right;

    public ComplexInterpolatedPlot(GridData _griddata) {
        this.griddata = _griddata;
        this.colorMap = new ComplexColorMapper(1.0);
        this.grid = this.griddata == null ? new Grid(1, 1, this.xmin, this.xmax, this.ymin, this.ymax) : new Grid(this.griddata.getData().length, this.griddata.getData()[0].length, this.xmin, this.xmax, this.ymin, this.ymax);
        this.grid.setColor(Color.lightGray);
        this.grid.setVisible(false);
        this.update();
    }

    public int xToIndex(double x) {
        return this.griddata.xToIndex(x);
    }

    public int yToIndex(double y) {
        return this.griddata.yToIndex(y);
    }

    public double indexToX(int i) {
        return this.griddata.indexToX(i);
    }

    public double indexToY(int i) {
        return this.griddata.indexToY(i);
    }

    public void setAll(Object obj) {
        double[][][] val = (double[][][])obj;
        this.copyComplexData(val);
        this.update();
    }

    public void setAll(Object obj, double xmin, double xmax, double ymin, double ymax) {
        double[][][] val = (double[][][])obj;
        this.copyComplexData(val);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.griddata.setScale(xmin, xmax, ymin, ymax);
        }
        this.update();
    }

    private void copyComplexData(double[][][] vals) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != vals[0].length || this.griddata.getNy() != vals[0][0].length) {
            this.griddata = new ArrayData(vals[0].length, vals[0][0].length, 3);
            this.setGridData(this.griddata);
        }
        double[][] mag = this.griddata.getData()[0];
        double[][] reData = this.griddata.getData()[1];
        double[][] imData = this.griddata.getData()[2];
        int ny = vals[0][0].length;
        int nx = vals[0].length;
        for (int i = 0; i < nx; ++i) {
            System.arraycopy(vals[0][i], 0, reData[i], 0, ny);
            System.arraycopy(vals[1][i], 0, imData[i], 0, ny);
            for (int j = 0; j < ny; ++j) {
                mag[i][j] = Math.sqrt(vals[0][i][j] * vals[0][i][j] + vals[1][i][j] * vals[1][i][j]);
            }
        }
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public void setGridData(GridData _griddata) {
        this.griddata = _griddata;
        if (this.griddata == null) {
            return;
        }
        Grid newgrid = new Grid(this.griddata.getNx(), this.griddata.getNy());
        newgrid.setColor(Color.lightGray);
        if (this.grid != null) {
            newgrid.setColor(this.grid.getColor());
            newgrid.setVisible(this.grid.isVisible());
        } else {
            newgrid.setColor(Color.lightGray);
        }
        this.grid = newgrid;
    }

    public void setIndexes(int[] indexes) {
        this.ampIndex = indexes[0];
        this.reIndex = indexes[1];
        this.imIndex = indexes[2];
    }

    public void setAutoscaleZ(boolean isAutoscale, double ceil) {
        this.autoscaleZ = isAutoscale;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.colorMap.setScale(ceil);
        }
    }

    public void setAutoscaleZ(boolean isAutoscale, double floor, double ceil) {
        this.setAutoscaleZ(isAutoscale, ceil);
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return 0.0;
    }

    public double getCeiling() {
        return this.colorMap.getCeil();
    }

    public void setFloorCeilColor(Color floorColor, Color ceilColor) {
        this.colorMap.setCeilColor(ceilColor);
    }

    public void setShowGridLines(boolean showGrid) {
        this.grid.setVisible(showGrid);
    }

    public void setGridLineColor(Color c) {
        this.grid.setColor(c);
    }

    public void update() {
        if (this.autoscaleZ && this.griddata != null) {
            double[] minmax = this.griddata.getZRange(this.ampIndex);
            this.colorMap.setScale(minmax[1]);
        }
        this.recolorImage();
    }

    protected void checkImage(DrawingPanel panel) {
        int tPix;
        int bPix;
        int rPix;
        int lPix;
        if (this.griddata.isCellData()) {
            double dx = this.griddata.getDx();
            double dy = this.griddata.getDy();
            lPix = panel.xToPix(this.griddata.getLeft() - dx / 2.0);
            rPix = panel.xToPix(this.griddata.getRight() + dx / 2.0);
            bPix = panel.yToPix(this.griddata.getBottom() + dy / 2.0);
            tPix = panel.yToPix(this.griddata.getTop() - dy / 2.0);
        } else {
            lPix = panel.xToPix(this.griddata.getLeft());
            rPix = panel.xToPix(this.griddata.getRight());
            bPix = panel.yToPix(this.griddata.getBottom());
            tPix = panel.yToPix(this.griddata.getTop());
        }
        this.leftPix = Math.min(lPix, rPix);
        this.rightPix = Math.max(lPix, rPix);
        this.bottomPix = Math.max(bPix, tPix);
        this.topPix = Math.min(bPix, tPix);
        this.ixsize = this.rightPix - this.leftPix + 1;
        this.iysize = this.bottomPix - this.topPix + 1;
        this.leftPix = Math.max(0, this.leftPix);
        this.rightPix = Math.min(this.rightPix, panel.getWidth());
        this.topPix = Math.max(0, this.topPix);
        this.bottomPix = Math.min(this.bottomPix, panel.getHeight());
        int row = this.bottomPix - this.topPix + 1;
        int col = this.rightPix - this.leftPix + 1;
        if (this.image != null && this.image.getWidth() == col && this.image.getHeight() == row && this.left == panel.pixToX(this.leftPix) && this.top == panel.pixToY(this.topPix) && this.bottom == panel.pixToX(this.bottomPix) && this.right == panel.pixToY(this.rightPix)) {
            return;
        }
        this.left = panel.pixToX(this.leftPix);
        this.top = panel.pixToY(this.topPix);
        this.bottom = panel.pixToX(this.bottomPix);
        this.right = panel.pixToY(this.rightPix);
        if (this.image != null && this.image.getWidth() == col && this.image.getHeight() == row) {
            this.recolorImage();
            return;
        }
        int size = row * col;
        if (size < 4) {
            this.image = null;
            return;
        }
        OSPLog.finer("ComplexInterpolatedPlot image created with row=" + row + " and col=" + col);
        ComponentColorModel ccm = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
        BandedSampleModel csm = new BandedSampleModel(0, col, row, col, new int[]{0, 1, 2}, new int[]{0, 0, 0});
        this.rgbData = new byte[3][size];
        DataBufferByte databuffer = new DataBufferByte(this.rgbData, size);
        WritableRaster raster = Raster.createWritableRaster(csm, databuffer, new Point(0, 0));
        this.image = new BufferedImage(ccm, raster, false, null);
        this.update();
    }

    protected void recolorImage() {
        GridData griddata = this.griddata;
        byte[][] rgbData = this.rgbData;
        BufferedImage image = this.image;
        if (griddata == null) {
            return;
        }
        if (griddata.isCellData()) {
            double dx = griddata.getDx();
            double dy = griddata.getDy();
            this.xmin = griddata.getLeft() - dx / 2.0;
            this.xmax = griddata.getRight() + dx / 2.0;
            this.ymin = griddata.getBottom() + dy / 2.0;
            this.ymax = griddata.getTop() - dy / 2.0;
        } else {
            this.xmin = griddata.getLeft();
            this.xmax = griddata.getRight();
            this.ymin = griddata.getBottom();
            this.ymax = griddata.getTop();
        }
        this.grid.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        if (image == null) {
            return;
        }
        if (rgbData[0].length != image.getWidth() * image.getHeight()) {
            return;
        }
        byte[] rgb = new byte[3];
        double y = this.top;
        int iw = image.getWidth();
        double dx = (this.xmax - this.xmin) / (double)(this.ixsize - 1);
        double dy = (this.ymin - this.ymax) / (double)(this.iysize - 1);
        if (griddata.getDx() < 0.0) {
            dx = -dx;
        }
        if (griddata.getDy() > 0.0) {
            dy = -dy;
        }
        double[] samples = new double[3];
        int[] indexes = new int[]{this.ampIndex, this.reIndex, this.imIndex};
        int jh = image.getHeight();
        for (int j = 0; j < jh; ++j) {
            double x = this.left;
            for (int i = 0; i < iw; ++i) {
                this.colorMap.samplesToComponents(griddata.interpolate(x, y, indexes, samples), rgb);
                int index = dy < 0.0 ? j * iw + i : (jh - j - 1) * iw + i;
                rgbData[0][index] = rgb[0];
                rgbData[1][index] = rgb[1];
                rgbData[2][index] = rgb[2];
                x += dx;
            }
            y += dy;
        }
    }

    public void setPaletteType(int type) {
    }

    public void setColorPalette(Color[] colors) {
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public boolean isMeasured() {
        return true;
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible || this.griddata == null) {
            return;
        }
        this.checkImage(panel);
        if (this.image != null) {
            g.drawImage(this.image, this.leftPix, this.topPix, panel);
        }
        this.grid.draw(panel, g);
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public Object createObject(XMLControl control) {
                return new ComplexInterpolatedPlot(null);
            }
        };
    }
}

