/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.False3D;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ComplexColorMapper;
import org.opensourcephysics.display2d.ComplexSurfaceVertex;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;
import org.opensourcephysics.display2d.SurfacePlotProjector;

public class ComplexSurfacePlot
implements Plot2D,
False3D {
    boolean visible = true;
    ComplexColorMapper colorMap = new ComplexColorMapper(1.0);
    protected DecimalFormat labelFormat = new DecimalFormat("0.00");
    private static final int TOP = 0;
    private static final int CENTER = 1;
    private static final int UPPER = 1;
    private static final int COINCIDE = 0;
    private static final int LOWER = -1;
    public static final int INIT_CALC_DIV = 33;
    public static final int INIT_DISP_DIV = 33;
    private int calc_divisions = 33;
    private int disp_divisions = 33;
    private int plot_mode = 0;
    private boolean isBoxed;
    private boolean isMesh;
    private boolean isScaleBox;
    private boolean isDisplayXY;
    private boolean isDisplayZ;
    private boolean isDisplayGrids;
    private double zmin = -2.0;
    private double zmax = 2.0;
    private boolean autoscaleZ = true;
    private GridData griddata;
    private double color_factor;
    private Point projection;
    private ComplexSurfaceVertex cop;
    private ComplexSurfaceVertex[] vertexArray;
    private final ComplexSurfaceVertex[] values1 = new ComplexSurfaceVertex[4];
    private final ComplexSurfaceVertex[] values2 = new ComplexSurfaceVertex[4];
    private Color line_color = Color.black;
    private int factor_x;
    private int factor_y;
    private int t_x;
    private int t_y;
    private int t_z;
    private boolean mouseDown = false;
    private int click_x;
    private int click_y;
    private boolean invalidProjection = true;
    private int iwidth = 0;
    private int iheight = 0;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private int ampIndex = 0;
    private int reIndex = 1;
    private int imIndex = 2;
    SurfacePlotProjector projector;
    double zminV;
    double zmaxV;
    double zfactorV;
    int master_project_indexV = 0;
    private final int[] poly_x = new int[9];
    private final int[] poly_y = new int[9];

    public ComplexSurfacePlot() {
        this(null);
    }

    public ComplexSurfacePlot(GridData _griddata) {
        this.griddata = _griddata;
        this.defaultVariables();
        this.autoscaleZ = true;
        this.projector = new SurfacePlotProjector();
        this.projector.setDistance(200.0);
        this.projector.set2DScaling(8.0);
        this.projector.setRotationAngle(125.0);
        this.projector.setElevationAngle(10.0);
        this.setGridData(_griddata);
        this.update();
    }

    public int xToIndex(double x) {
        return this.griddata.xToIndex(x);
    }

    public int yToIndex(double y) {
        return this.griddata.yToIndex(y);
    }

    public double indexToX(int i) {
        return this.griddata.indexToX(i);
    }

    public double indexToY(int i) {
        return this.griddata.indexToY(i);
    }

    public void setAll(Object obj) {
        double[][][] val = (double[][][])obj;
        this.copyComplexData(val);
        this.update();
    }

    public void setAll(Object obj, double xmin, double xmax, double ymin, double ymax) {
        double[][][] val = (double[][][])obj;
        this.copyComplexData(val);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.griddata.setScale(xmin, xmax, ymin, ymax);
        }
        this.update();
    }

    private void copyComplexData(double[][][] vals) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != vals[0].length || this.griddata.getNy() != vals[0][0].length) {
            this.griddata = new ArrayData(vals[0].length, vals[0][0].length, 3);
            this.setGridData(this.griddata);
        }
        double[][] mag = this.griddata.getData()[0];
        double[][] reData = this.griddata.getData()[1];
        double[][] imData = this.griddata.getData()[2];
        int ny = vals[0][0].length;
        int nx = vals[0].length;
        for (int i = 0; i < nx; ++i) {
            System.arraycopy(vals[0][i], 0, reData[i], 0, ny);
            System.arraycopy(vals[1][i], 0, imData[i], 0, ny);
            for (int j = 0; j < ny; ++j) {
                mag[i][j] = Math.sqrt(vals[0][i][j] * vals[0][i][j] + vals[1][i][j] * vals[1][i][j]);
            }
        }
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public void setGridData(GridData _griddata) throws IllegalArgumentException {
        this.griddata = _griddata;
        if (this.griddata == null) {
            return;
        }
        if (this.griddata.getNx() != this.griddata.getNy()) {
            throw new IllegalArgumentException("SurfacePlot requires square grids.");
        }
    }

    private void generateVerticesFromArray(ArrayData griddata) {
        double[][] ampdata = griddata.getData()[this.ampIndex];
        double[][] redata = griddata.getData()[this.reIndex];
        double[][] imdata = griddata.getData()[this.imIndex];
        int numRows = ampdata.length;
        int numCols = ampdata[0].length;
        this.calc_divisions = numRows - 1;
        double xfactor = 20.0 / (this.xmax - this.xmin);
        double yfactor = 20.0 / (this.ymax - this.ymin);
        if (this.vertexArray == null) {
            this.vertexArray = new ComplexSurfaceVertex[numRows * numCols];
        }
        double dx = Math.abs(griddata.getDx());
        double dy = Math.abs(griddata.getDy());
        double x = this.xmin;
        for (int ix = 0; ix < numCols; ++ix) {
            double y = this.ymin;
            for (int iy = 0; iy < numRows; ++iy) {
                int iyd = griddata.getDy() > 0.0 ? iy : numCols - iy - 1;
                int ixd = griddata.getDx() > 0.0 ? ix : numCols - ix - 1;
                this.vertexArray[ix * numRows + iy] = new ComplexSurfaceVertex(-10.0 + (x - this.xmin) * xfactor, -10.0 + (y - this.ymin) * yfactor, ampdata[ixd][iyd], redata[ixd][iyd], imdata[ixd][iyd], this);
                y += dy;
            }
            x += dx;
        }
        ampdata = null;
    }

    private void generateVerticesFromPoints(GridPointData griddata) throws IllegalArgumentException {
        double[][][] data = griddata.getData();
        int numRows = data.length;
        int numCols = data[0].length;
        this.calc_divisions = numRows - 1;
        double xfactor = 20.0 / (this.xmax - this.xmin);
        double yfactor = 20.0 / (this.ymax - this.ymin);
        this.vertexArray = new ComplexSurfaceVertex[numRows * numCols];
        double dx = Math.abs(griddata.getDx());
        double dy = Math.abs(griddata.getDy());
        int ampIndex = this.ampIndex + 2;
        int reIndex = this.reIndex + 2;
        int imIndex = this.imIndex + 2;
        double x = this.xmin;
        for (int ix = 0; ix < numCols; ++ix) {
            double y = this.ymin;
            for (int iy = 0; iy < numRows; ++iy) {
                this.vertexArray[ix * numRows + iy] = new ComplexSurfaceVertex(-10.0 + (x - this.xmin) * xfactor, -10.0 + (y - this.ymin) * yfactor, data[ix][iy][ampIndex], data[ix][iy][reIndex], data[ix][iy][imIndex], this);
                y += dy;
            }
            x += dx;
        }
        data = null;
    }

    private void generateVerticesFromPoints_old(GridPointData griddata) {
        double[][][] data = griddata.getData();
        int numRows = data.length;
        int numCols = data[0].length;
        this.calc_divisions = numRows - 1;
        double xfactor = 20.0 / (this.xmax - this.xmin);
        double yfactor = 20.0 / (this.ymax - this.ymin);
        this.vertexArray = new ComplexSurfaceVertex[numRows * numCols];
        int ampIndex = this.ampIndex + 2;
        int reIndex = this.reIndex + 2;
        int imIndex = this.imIndex + 2;
        if (griddata.getDy() > 0.0) {
            for (int ix = 0; ix < numCols; ++ix) {
                for (int iy = 0; iy < numRows; ++iy) {
                    this.vertexArray[ix * numRows + iy] = new ComplexSurfaceVertex(-10.0 + (data[ix][iy][0] - this.xmin) * xfactor, -10.0 + (data[ix][iy][1] - this.ymin) * yfactor, data[ix][iy][ampIndex], data[ix][iy][reIndex], data[ix][iy][imIndex], this);
                }
            }
        } else {
            for (int ix = 0; ix < numCols; ++ix) {
                for (int iy = 0; iy < numRows; ++iy) {
                    this.vertexArray[ix * numRows + iy] = new ComplexSurfaceVertex(-10.0 + (data[ix][numRows - iy - 1][0] - this.xmin) * xfactor, -10.0 + (data[ix][numRows - iy - 1][1] - this.ymin) * yfactor, data[ix][numCols - iy - 1][ampIndex], data[ix][numCols - iy - 1][reIndex], data[ix][numCols - iy - 1][imIndex], this);
                }
            }
        }
        data = null;
    }

    public void setIndexes(int[] indexes) {
        this.ampIndex = indexes[0];
        this.reIndex = indexes[1];
        this.imIndex = indexes[2];
    }

    void projectVertexArray() {
        ComplexSurfaceVertex[] tempArray = this.vertexArray;
        if (tempArray == null) {
            return;
        }
        int num = tempArray.length;
        for (int i = 0; i < num; ++i) {
            tempArray[i].project();
        }
    }

    public void setColorPalette(Color[] colors) {
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public void setShowGridLines(boolean show) {
        this.isMesh = show;
    }

    public void setGridLineColor(Color c) {
        this.line_color = c;
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible || this.griddata == null) {
            return;
        }
        this.projector.setProjectionArea(new Rectangle(0, 0, panel.getBounds().width, panel.getBounds().height));
        if (this.invalidProjection || this.iwidth != panel.getWidth() || this.iheight != panel.getHeight()) {
            ++this.master_project_indexV;
            this.invalidProjection = false;
            this.projectVertexArray();
            this.iwidth = panel.getWidth();
            this.iheight = panel.getHeight();
        }
        this.plotSurface(g);
    }

    private void defaultVariables() {
        this.plot_mode = 0;
        this.isBoxed = true;
        this.isMesh = true;
        this.isScaleBox = false;
        this.isDisplayXY = true;
        this.isDisplayZ = true;
        this.isDisplayGrids = false;
    }

    private final boolean plottable(ComplexSurfaceVertex[] values) {
        try {
            return !values[0].isInvalid() && !values[1].isInvalid() && !values[2].isInvalid() && !values[3].isInvalid();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private final void setAxesScale() {
        double divisor;
        int longest;
        if (!this.isScaleBox) {
            this.projector.setScaling(1.0);
            this.t_z = 4;
            this.t_y = 4;
            this.t_x = 4;
            return;
        }
        double scale_x = this.xmax - this.xmin;
        double scale_y = this.ymax - this.ymin;
        double scale_z = this.zmax - this.zmin;
        if (scale_x < scale_y) {
            if (scale_y < scale_z) {
                longest = 3;
                divisor = scale_z;
            } else {
                longest = 2;
                divisor = scale_y;
            }
        } else if (scale_x < scale_z) {
            longest = 3;
            divisor = scale_z;
        } else {
            longest = 1;
            divisor = scale_x;
        }
        scale_y /= divisor;
        scale_z /= divisor;
        if ((scale_x /= divisor) < (double)0.2f || scale_y < (double)0.2f && scale_z < (double)0.2f) {
            switch (longest) {
                case 1: {
                    if (scale_y < scale_z) {
                        scale_y /= scale_z;
                        scale_z = 1.0;
                        break;
                    }
                    scale_z /= scale_y;
                    scale_y = 1.0;
                    break;
                }
                case 2: {
                    if (scale_x < scale_z) {
                        scale_x /= scale_z;
                        scale_z = 1.0;
                        break;
                    }
                    scale_z /= scale_x;
                    scale_x = 1.0;
                    break;
                }
                case 3: {
                    if (scale_y < scale_x) {
                        scale_y /= scale_x;
                        scale_x = 1.0;
                        break;
                    }
                    scale_x /= scale_y;
                    scale_y = 1.0;
                }
            }
        }
        if (scale_x < (double)0.2f) {
            scale_x = 1.0;
        }
        this.projector.setXScaling(scale_x);
        if (scale_y < (double)0.2f) {
            scale_y = 1.0;
        }
        this.projector.setYScaling(scale_y);
        if (scale_z < (double)0.2f) {
            scale_z = 1.0;
        }
        this.projector.setZScaling(scale_z);
        this.t_x = scale_x < 0.5 ? 8 : 4;
        this.t_y = scale_y < 0.5 ? 8 : 4;
        this.t_z = scale_z < 0.5 ? 8 : 4;
    }

    private int getDispDivisions() {
        int plot_density = this.disp_divisions;
        if (plot_density > this.calc_divisions) {
            plot_density = this.calc_divisions;
        }
        while (this.calc_divisions % plot_density != 0) {
            ++plot_density;
        }
        return plot_density;
    }

    private final void plotSurface(Graphics g) {
        int sy;
        int end_ly;
        int start_ly;
        int sx;
        int end_lx;
        int start_lx;
        boolean inc_y;
        double zi = this.zmin;
        double zx = this.zmax;
        int plot_density = this.getDispDivisions();
        int multiple_factor = this.calc_divisions / plot_density;
        this.disp_divisions = plot_density;
        this.zmin = zi;
        this.zmax = zx;
        this.color_factor = 0.8 / (this.zmax - this.zmin);
        if (this.plot_mode == 2 || this.plot_mode == 3 || this.plot_mode == 4 || this.plot_mode == 5) {
            this.color_factor *= 0.7499999999999999;
        }
        if (this.vertexArray == null) {
            this.drawBoxGridsTicksLabels(g, false);
            this.drawBoundingBox(g);
            return;
        }
        if (this.plot_mode == 8) {
            this.drawBoxGridsTicksLabels(g, true);
            this.drawBoundingBox(g);
            return;
        }
        this.drawBoxGridsTicksLabels(g, false);
        this.zmaxV = this.zmax;
        this.zminV = this.zmin;
        this.zfactorV = 20.0 / (this.zmaxV - this.zminV);
        double distance = this.projector.getDistance() * this.projector.getCosElevationAngle();
        this.cop = new ComplexSurfaceVertex(distance * this.projector.getSinRotationAngle(), distance * this.projector.getCosRotationAngle(), this.projector.getDistance() * this.projector.getSinElevationAngle(), 1.0, 0.0, this);
        this.cop.transform();
        boolean inc_x = this.cop.x > 0.0;
        boolean bl = inc_y = this.cop.y > 0.0;
        if (inc_x) {
            start_lx = 0;
            end_lx = this.calc_divisions;
            sx = multiple_factor;
        } else {
            start_lx = this.calc_divisions;
            end_lx = 0;
            sx = -multiple_factor;
        }
        if (inc_y) {
            start_ly = 0;
            end_ly = this.calc_divisions;
            sy = multiple_factor;
        } else {
            start_ly = this.calc_divisions;
            end_ly = 0;
            sy = -multiple_factor;
        }
        if (this.cop.x > 10.0 || this.cop.x < -10.0) {
            if (this.cop.y > 10.0 || this.cop.y < -10.0) {
                this.plotArea(g, start_lx, start_ly, end_lx, end_ly, sx, sy);
            } else {
                int split_y = (int)((this.cop.y + 10.0) * (double)plot_density / 20.0) * multiple_factor;
                this.plotArea(g, start_lx, 0, end_lx, split_y, sx, multiple_factor);
                this.plotArea(g, start_lx, this.calc_divisions, end_lx, split_y, sx, -multiple_factor);
            }
        } else if (this.cop.y > 10.0 || this.cop.y < -10.0) {
            int split_x = (int)((this.cop.x + 10.0) * (double)plot_density / 20.0) * multiple_factor;
            this.plotArea(g, 0, start_ly, split_x, end_ly, multiple_factor, sy);
            this.plotArea(g, this.calc_divisions, start_ly, split_x, end_ly, -multiple_factor, sy);
        } else {
            int split_x = (int)((this.cop.x + 10.0) * (double)plot_density / 20.0) * multiple_factor;
            int split_y = (int)((this.cop.y + 10.0) * (double)plot_density / 20.0) * multiple_factor;
            this.plotArea(g, 0, 0, split_x, split_y, multiple_factor, multiple_factor);
            this.plotArea(g, 0, this.calc_divisions, split_x, split_y, multiple_factor, -multiple_factor);
            this.plotArea(g, this.calc_divisions, 0, split_x, split_y, -multiple_factor, multiple_factor);
            this.plotArea(g, this.calc_divisions, this.calc_divisions, split_x, split_y, -multiple_factor, -multiple_factor);
        }
        if (this.isBoxed) {
            this.drawBoundingBox(g);
        }
    }

    private final void plotPlane(Graphics g, ComplexSurfaceVertex[] vertex, int verticescount) {
        double[] samples = new double[3];
        if (verticescount < 3) {
            return;
        }
        int count = 0;
        double z = 0.0;
        double re = 0.0;
        double im = 0.0;
        this.line_color = Color.black;
        boolean low1 = vertex[0].z < this.zmin;
        boolean valid1 = !low1 && vertex[0].z <= this.zmax;
        int index = 1;
        for (int loop = 0; loop < verticescount; ++loop) {
            boolean valid2;
            boolean low2 = vertex[index].z < this.zmin;
            boolean bl = valid2 = !low2 && vertex[index].z <= this.zmax;
            if (valid1 || valid2 || low1 ^ low2) {
                double new_y;
                double new_x;
                double ratio;
                double result;
                if (!valid1) {
                    result = low1 ? this.zmin : this.zmax;
                    ratio = (result - vertex[index].z) / (vertex[loop].z - vertex[index].z);
                    new_x = ratio * (vertex[loop].x - vertex[index].x) + vertex[index].x;
                    new_y = ratio * (vertex[loop].y - vertex[index].y) + vertex[index].y;
                    this.projection = low1 ? this.projector.project(new_x, new_y, -10.0) : this.projector.project(new_x, new_y, 10.0);
                    this.poly_x[count] = this.projection.x;
                    this.poly_y[count] = this.projection.y;
                    ++count;
                    z += result;
                }
                if (valid2) {
                    this.projection = vertex[index].projection();
                    this.poly_x[count] = this.projection.x;
                    this.poly_y[count] = this.projection.y;
                    ++count;
                    z += vertex[index].z;
                    re += vertex[index].re;
                    im += vertex[index].im;
                } else {
                    result = low2 ? this.zmin : this.zmax;
                    ratio = (result - vertex[loop].z) / (vertex[index].z - vertex[loop].z);
                    new_x = ratio * (vertex[index].x - vertex[loop].x) + vertex[loop].x;
                    new_y = ratio * (vertex[index].y - vertex[loop].y) + vertex[loop].y;
                    this.projection = low2 ? this.projector.project(new_x, new_y, -10.0) : this.projector.project(new_x, new_y, 10.0);
                    this.poly_x[count] = this.projection.x;
                    this.poly_y[count] = this.projection.y;
                    ++count;
                    z += result;
                }
            }
            if (++index == verticescount) {
                index = 0;
            }
            valid1 = valid2;
            low1 = low2;
        }
        if (count > 0) {
            switch (this.plot_mode) {
                case 8: {
                    g.setColor(Color.lightGray);
                    break;
                }
                default: {
                    samples[0] = 0.99;
                    samples[1] = re;
                    samples[2] = im;
                    g.setColor(this.colorMap.samplesToColor(samples));
                }
            }
            g.fillPolygon(this.poly_x, this.poly_y, count);
            g.setColor(this.line_color);
            if (this.isMesh) {
                this.poly_x[count] = this.poly_x[0];
                this.poly_y[count] = this.poly_y[0];
                g.drawPolygon(this.poly_x, this.poly_y, ++count);
            }
        }
    }

    private final void plotArea(Graphics g, int start_lx, int start_ly, int end_lx, int end_ly, int sx, int sy) {
        sx *= this.calc_divisions + 1;
        end_lx *= this.calc_divisions + 1;
        int lx = start_lx *= this.calc_divisions + 1;
        for (int ly = start_ly; ly != end_ly; ly += sy) {
            this.values1[1] = this.vertexArray[lx + ly];
            this.values1[2] = this.vertexArray[lx + ly + sy];
            while (lx != end_lx) {
                this.values1[0] = this.values1[1];
                this.values1[1] = this.vertexArray[lx + sx + ly];
                this.values1[3] = this.values1[2];
                this.values1[2] = this.vertexArray[lx + sx + ly + sy];
                if (this.plottable(this.values1)) {
                    this.plotPlane(g, this.values1, 4);
                }
                lx += sx;
            }
            lx = start_lx;
        }
    }

    private final void drawBoxGridsTicksLabels(Graphics g, boolean draw_axes) {
        boolean x_left = false;
        boolean y_left = false;
        int[] x = new int[5];
        int[] y = new int[5];
        if (this.projector == null) {
            return;
        }
        if (draw_axes) {
            this.drawBase(g, x, y);
            Point projection = this.projector.project(0.0, 0.0, -10.0);
            x[0] = projection.x;
            y[0] = projection.y;
            projection = this.projector.project(10.5, 0.0, -10.0);
            g.drawLine(x[0], y[0], projection.x, projection.y);
            if (projection.x < x[0]) {
                this.outString(g, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "x", 2, 0);
            } else {
                this.outString(g, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "x", 0, 0);
            }
            projection = this.projector.project(0.0, 11.5, -10.0);
            g.drawLine(x[0], y[0], projection.x, projection.y);
            if (projection.x < x[0]) {
                this.outString(g, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "y", 2, 0);
            } else {
                this.outString(g, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "y", 0, 0);
            }
            projection = this.projector.project(0.0, 0.0, 10.5);
            g.drawLine(x[0], y[0], projection.x, projection.y);
            this.outString(g, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "z", 1, 1);
        } else {
            this.factor_y = 1;
            this.factor_x = 1;
            Point projection = this.projector.project(0.0, 0.0, -10.0);
            x[0] = projection.x;
            projection = this.projector.project(10.5, 0.0, -10.0);
            y_left = projection.x > x[0];
            int i = projection.y;
            projection = this.projector.project(-10.5, 0.0, -10.0);
            if (projection.y > i) {
                this.factor_x = -1;
                y_left = projection.x > x[0];
            }
            projection = this.projector.project(0.0, 10.5, -10.0);
            x_left = projection.x > x[0];
            i = projection.y;
            projection = this.projector.project(0.0, -10.5, -10.0);
            if (projection.y > i) {
                this.factor_y = -1;
                x_left = projection.x > x[0];
            }
            this.setAxesScale();
            this.drawBase(g, x, y);
            if (this.isBoxed) {
                projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, -10.0);
                x[0] = projection.x;
                y[0] = projection.y;
                projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, 10.0);
                x[1] = projection.x;
                y[1] = projection.y;
                projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0);
                x[2] = projection.x;
                y[2] = projection.y;
                projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0);
                x[3] = projection.x;
                y[3] = projection.y;
                x[4] = x[0];
                y[4] = y[0];
                if (this.plot_mode != 7) {
                    if (this.plot_mode == 8) {
                        g.setColor(Color.lightGray);
                    } else {
                        g.setColor(new Color(192, 220, 192));
                    }
                    g.fillPolygon(x, y, 4);
                }
                g.setColor(Color.black);
                g.drawPolygon(x, y, 5);
                projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0);
                x[2] = projection.x;
                y[2] = projection.y;
                projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0);
                x[3] = projection.x;
                y[3] = projection.y;
                x[4] = x[0];
                y[4] = y[0];
                if (this.plot_mode != 7) {
                    if (this.plot_mode == 8) {
                        g.setColor(Color.lightGray);
                    } else {
                        g.setColor(new Color(192, 220, 192));
                    }
                    g.fillPolygon(x, y, 4);
                }
                g.setColor(Color.black);
                g.drawPolygon(x, y, 5);
            } else if (this.isDisplayZ) {
                projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0);
                x[0] = projection.x;
                y[0] = projection.y;
                projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0);
                g.drawLine(x[0], y[0], projection.x, projection.y);
                projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0);
                x[0] = projection.x;
                y[0] = projection.y;
                projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0);
                g.drawLine(x[0], y[0], projection.x, projection.y);
            }
            for (i = -9; i <= 9; ++i) {
                Point tickpos;
                if (this.isDisplayXY || this.isDisplayGrids) {
                    if (!this.isDisplayGrids || i % (this.t_y / 2) == 0 || this.isDisplayXY) {
                        projection = this.isDisplayGrids && i % this.t_y == 0 ? this.projector.project(-this.factor_x * 10, i, -10.0) : (i % this.t_y != 0 ? this.projector.project((float)this.factor_x * 9.8f, i, -10.0) : this.projector.project((float)this.factor_x * 9.5f, i, -10.0));
                        tickpos = this.projector.project(this.factor_x * 10, i, -10.0);
                        g.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                        if (i % this.t_y == 0 && this.isDisplayXY) {
                            tickpos = this.projector.project((float)this.factor_x * 10.5f, i, -10.0);
                            if (y_left) {
                                this.outFloat(g, tickpos.x, tickpos.y, (double)(i + 10) / 20.0 * (this.ymax - this.ymin) + this.ymin, 0, 0);
                            } else {
                                this.outFloat(g, tickpos.x, tickpos.y, (double)(i + 10) / 20.0 * (this.ymax - this.ymin) + this.ymin, 2, 0);
                            }
                        }
                    }
                    if (!this.isDisplayGrids || i % (this.t_x / 2) == 0 || this.isDisplayXY) {
                        projection = this.isDisplayGrids && i % this.t_x == 0 ? this.projector.project(i, -this.factor_y * 10, -10.0) : (i % this.t_x != 0 ? this.projector.project(i, (float)this.factor_y * 9.8f, -10.0) : this.projector.project(i, (float)this.factor_y * 9.5f, -10.0));
                        tickpos = this.projector.project(i, this.factor_y * 10, -10.0);
                        g.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                        if (i % this.t_x == 0 && this.isDisplayXY) {
                            tickpos = this.projector.project(i, (float)this.factor_y * 10.5f, -10.0);
                            if (x_left) {
                                this.outFloat(g, tickpos.x, tickpos.y, (double)(i + 10) / 20.0 * (this.xmax - this.xmin) + this.xmin, 0, 0);
                            } else {
                                this.outFloat(g, tickpos.x, tickpos.y, (double)(i + 10) / 20.0 * (this.xmax - this.xmin) + this.xmin, 2, 0);
                            }
                        }
                    }
                }
                if (this.isDisplayXY) {
                    tickpos = this.projector.project(0.0, this.factor_y * 14, -10.0);
                    this.outString(g, tickpos.x, tickpos.y, "X", 1, 0);
                    tickpos = this.projector.project(this.factor_x * 14, 0.0, -10.0);
                    this.outString(g, tickpos.x, tickpos.y, "Y", 1, 0);
                }
                if (!this.isDisplayZ && (!this.isDisplayGrids || !this.isBoxed) || this.isDisplayGrids && i % (this.t_z / 2) != 0 && !this.isDisplayZ) continue;
                if (this.isBoxed && this.isDisplayGrids && i % this.t_z == 0) {
                    projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, i);
                    tickpos = this.projector.project(-this.factor_x * 10, this.factor_y * 10, i);
                } else {
                    projection = i % this.t_z == 0 ? this.projector.project(-this.factor_x * 10, (float)this.factor_y * 9.5f, i) : this.projector.project(-this.factor_x * 10, (float)this.factor_y * 9.8f, i);
                    tickpos = this.projector.project(-this.factor_x * 10, this.factor_y * 10, i);
                }
                g.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                if (this.isDisplayZ) {
                    tickpos = this.projector.project(-this.factor_x * 10, (float)this.factor_y * 10.5f, i);
                    if (i % this.t_z == 0) {
                        if (x_left) {
                            this.outFloat(g, tickpos.x, tickpos.y, (double)(i + 10) / 20.0 * (this.zmax - this.zmin) + this.zmin, 0, 1);
                        } else {
                            this.outFloat(g, tickpos.x, tickpos.y, (double)(i + 10) / 20.0 * (this.zmax - this.zmin) + this.zmin, 2, 1);
                        }
                    }
                }
                if (this.isDisplayGrids && this.isBoxed && i % this.t_z == 0) {
                    projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, i);
                    tickpos = this.projector.project(this.factor_x * 10, -this.factor_y * 10, i);
                } else {
                    projection = i % this.t_z == 0 ? this.projector.project((float)this.factor_x * 9.5f, -this.factor_y * 10, i) : this.projector.project((float)this.factor_x * 9.8f, -this.factor_y * 10, i);
                    tickpos = this.projector.project(this.factor_x * 10, -this.factor_y * 10, i);
                }
                g.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                if (this.isDisplayZ) {
                    tickpos = this.projector.project((float)this.factor_x * 10.5f, -this.factor_y * 10, i);
                    if (i % this.t_z == 0) {
                        if (y_left) {
                            this.outFloat(g, tickpos.x, tickpos.y, (double)(i + 10) / 20.0 * (this.zmax - this.zmin) + this.zmin, 0, 1);
                        } else {
                            this.outFloat(g, tickpos.x, tickpos.y, (double)(i + 10) / 20.0 * (this.zmax - this.zmin) + this.zmin, 2, 1);
                        }
                    }
                }
                if (!this.isDisplayGrids || !this.isBoxed) continue;
                if (i % this.t_y == 0) {
                    projection = this.projector.project(-this.factor_x * 10, i, -10.0);
                    tickpos = this.projector.project(-this.factor_x * 10, i, 10.0);
                    g.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                }
                if (i % this.t_x != 0) continue;
                projection = this.projector.project(i, -this.factor_y * 10, -10.0);
                tickpos = this.projector.project(i, -this.factor_y * 10, 10.0);
                g.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
            }
        }
    }

    private final void drawBase(Graphics g, int[] x, int[] y) {
        Point projection = this.projector.project(-10.0, -10.0, -10.0);
        x[0] = projection.x;
        y[0] = projection.y;
        projection = this.projector.project(-10.0, 10.0, -10.0);
        x[1] = projection.x;
        y[1] = projection.y;
        projection = this.projector.project(10.0, 10.0, -10.0);
        x[2] = projection.x;
        y[2] = projection.y;
        projection = this.projector.project(10.0, -10.0, -10.0);
        x[3] = projection.x;
        y[3] = projection.y;
        x[4] = x[0];
        y[4] = y[0];
        if (this.plot_mode != 7) {
            if (this.plot_mode == 8) {
                g.setColor(Color.lightGray);
            } else {
                g.setColor(new Color(192, 220, 192));
            }
            g.fillPolygon(x, y, 4);
        }
        g.setColor(Color.black);
        g.drawPolygon(x, y, 5);
    }

    private final void drawBoundingBox(Graphics g) {
        Point startingpoint = this.projector.project(this.factor_x * 10, this.factor_y * 10, 10.0);
        g.setColor(Color.black);
        Point projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0);
        g.drawLine(startingpoint.x, startingpoint.y, projection.x, projection.y);
        projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0);
        g.drawLine(startingpoint.x, startingpoint.y, projection.x, projection.y);
        projection = this.projector.project(this.factor_x * 10, this.factor_y * 10, -10.0);
        g.drawLine(startingpoint.x, startingpoint.y, projection.x, projection.y);
    }

    private final void outString(Graphics g, int x, int y, String s, int x_align, int y_align) {
        switch (y_align) {
            case 0: {
                y += g.getFontMetrics(g.getFont()).getAscent();
                break;
            }
            case 1: {
                y += g.getFontMetrics(g.getFont()).getAscent() / 2;
            }
        }
        switch (x_align) {
            case 0: {
                g.drawString(s, x, y);
                break;
            }
            case 2: {
                g.drawString(s, x - g.getFontMetrics(g.getFont()).stringWidth(s), y);
                break;
            }
            case 1: {
                g.drawString(s, x - g.getFontMetrics(g.getFont()).stringWidth(s) / 2, y);
            }
        }
    }

    private final void outFloat(Graphics g, int x, int y, double f, int x_align, int y_align) {
        String s = this.labelFormat.format(f);
        this.outString(g, x, y, s, x_align, y_align);
    }

    public void setPaletteType(int type) {
        this.plot_mode = type;
    }

    public void setLabelFormat(String _format) {
        this.labelFormat = new DecimalFormat(_format);
    }

    public void setAutoscaleZ(boolean isAutoscale, double floor, double ceil) {
        this.autoscaleZ = isAutoscale;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.zmax = ceil;
            this.zmin = floor;
        }
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return this.zmin;
    }

    public double getCeiling() {
        return this.zmax;
    }

    public void setFloorCeilColor(Color floorColor, Color ceilColor) {
        this.colorMap.setCeilColor(ceilColor);
    }

    public synchronized void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.autoscaleZ) {
            double[] minmax = this.griddata.getZRange(this.ampIndex);
            this.zmax = minmax[1];
            this.zmin = minmax[0];
        }
        double left = this.griddata.getLeft();
        double right = this.griddata.getRight();
        double top = this.griddata.getTop();
        double bottom = this.griddata.getBottom();
        this.xmin = Math.min(left, right);
        this.xmax = Math.max(left, right);
        this.ymin = Math.min(bottom, top);
        this.ymax = Math.max(bottom, top);
        if (this.griddata instanceof ArrayData) {
            this.generateVerticesFromArray((ArrayData)this.griddata);
        } else if (this.griddata instanceof GridPointData) {
            this.generateVerticesFromPoints((GridPointData)this.griddata);
        }
    }

    public void setTranslation(int xpix, int ypix) {
        this.projector.set2DTranslation(xpix, ypix);
    }

    public void setRotationAngle(double angle) {
        this.projector.setRotationAngle(angle);
    }

    public void setElevationAngle(double angle) {
        this.projector.setElevationAngle(angle);
    }

    public void setDistance(double distance) {
        this.projector.setDistance(distance);
    }

    public void set2DScaling(double scale) {
        this.projector.set2DScaling(scale);
    }

    public boolean mousePressed(MouseEvent e, DrawingPanel drawingPanel) {
        this.click_x = e.getX();
        this.click_y = e.getY();
        this.mouseDown = true;
        return true;
    }

    public void mouseReleased(MouseEvent e, DrawingPanel drawingPanel) {
        this.mouseDown = false;
    }

    public void mouseDragged(MouseEvent e, DrawingPanel drawingPanel) {
        double new_value = 0.0;
        int x = e.getX();
        int y = e.getY();
        if (e.isControlDown()) {
            this.projector.set2D_xTranslation(this.projector.get2D_xTranslation() + (x - this.click_x));
            this.projector.set2D_yTranslation(this.projector.get2D_yTranslation() + (y - this.click_y));
        } else if (e.isShiftDown()) {
            new_value = this.projector.get2DScaling() + (double)(y - this.click_y) * 0.5;
            if (new_value > 60.0) {
                new_value = 60.0;
            }
            if (new_value < 2.0) {
                new_value = 2.0;
            }
            this.projector.set2DScaling(new_value);
        } else {
            for (new_value = this.projector.getRotationAngle() + (double)(x - this.click_x); new_value > 360.0; new_value -= 360.0) {
            }
            while (new_value < 0.0) {
                new_value += 360.0;
            }
            this.projector.setRotationAngle(new_value);
            new_value = this.projector.getElevationAngle() + (double)(y - this.click_y);
            if (new_value > 90.0) {
                new_value = 90.0;
            } else if (new_value < 0.0) {
                new_value = 0.0;
            }
            this.projector.setElevationAngle(new_value);
        }
        this.click_x = x;
        this.click_y = y;
        this.invalidProjection = true;
        drawingPanel.render();
    }

    public double getXMin() {
        return 0.0;
    }

    public double getXMax() {
        return 0.0;
    }

    public double getYMin() {
        return 0.0;
    }

    public double getYMax() {
        return 0.0;
    }

    public boolean isMeasured() {
        return false;
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public Object createObject(XMLControl control) {
                return new ComplexSurfacePlot(null);
            }
        };
    }
}

