/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Measurable;

public class DataRaster
implements Measurable {
    static Color[] colors = new Color[]{Color.red, Color.green, Color.blue, Color.yellow, Color.cyan, Color.magenta, Color.orange};
    public DrawingPanel primaryDrawingPanel = null;
    Color backgroundColor;
    ArrayList imageDatasets = new ArrayList();
    boolean visible = true;
    protected double xmin = -1.0;
    protected double xmax = 1.0;
    protected double ymin = -1.0;
    protected double ymax = 1.0;
    protected int alpha = 255;
    protected BufferedImage image;
    protected int maxPoints = 196607;

    public DataRaster(DrawingPanel dp, double _xmin, double _xmax, double _ymin, double _ymax) {
        this.primaryDrawingPanel = dp;
        if (this.primaryDrawingPanel != null) {
            this.primaryDrawingPanel.setPixelScale();
        }
        this.xmin = _xmin;
        this.xmax = _xmax;
        this.ymin = _ymin;
        this.ymax = _ymax;
        this.image = new BufferedImage(1, 1, 2);
        this.backgroundColor = new Color(this.image.getRGB(0, 0));
    }

    public void append(int dataIndex, double x, double y) {
        this.checkIndex(dataIndex).append(x, y);
    }

    public void setColor(int dataIndex, Color color) {
        this.checkIndex(dataIndex).setColor(color);
    }

    public void clear() {
        int n = this.imageDatasets.size();
        for (int i = 0; i < n; ++i) {
            ((ImageData)this.imageDatasets.get(i)).clear();
        }
        this.render();
    }

    protected ImageData checkIndex(int dataIndex) {
        while (dataIndex >= this.imageDatasets.size()) {
            ImageData d = null;
            d = dataIndex < colors.length - 1 ? new ImageData(colors[dataIndex]) : new ImageData(GUIUtils.randomColor());
            this.imageDatasets.add(d);
        }
        return (ImageData)this.imageDatasets.get(dataIndex);
    }

    public synchronized BufferedImage render() {
        if (this.primaryDrawingPanel == null) {
            return null;
        }
        int xrange = this.primaryDrawingPanel.xToPix(this.xmax) - this.primaryDrawingPanel.xToPix(this.xmin);
        int yrange = this.primaryDrawingPanel.yToPix(this.ymin) - this.primaryDrawingPanel.yToPix(this.ymax);
        xrange = Math.min(xrange, this.primaryDrawingPanel.getWidth());
        yrange = Math.min(yrange, this.primaryDrawingPanel.getHeight());
        this.image = new BufferedImage(Math.abs(xrange), Math.abs(yrange), 2);
        this.backgroundColor = new Color(this.image.getRGB(0, 0));
        int n = this.imageDatasets.size();
        for (int i = 0; i < n; ++i) {
            ((ImageData)this.imageDatasets.get(i)).render();
        }
        return this.image;
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.primaryDrawingPanel != panel) {
            return;
        }
        int xrange = panel.xToPix(this.xmax) - panel.xToPix(this.xmin);
        int yrange = panel.yToPix(this.ymin) - panel.yToPix(this.ymax);
        xrange = Math.min(xrange, panel.getWidth());
        yrange = Math.min(yrange, panel.getHeight());
        if (xrange == 0 || xrange == 0) {
            return;
        }
        if (Math.abs(xrange) != this.image.getWidth() || Math.abs(yrange) != this.image.getHeight()) {
            this.render();
        }
        if (this.image != null && this.image.getWidth() > 1) {
            g.drawImage(this.image, panel.xToPix(this.xmin), panel.yToPix(this.ymax), panel);
        }
    }

    public boolean isMeasured() {
        return true;
    }

    public void setXMin(double _value) {
        this.xmin = _value;
    }

    public void setXMax(double _value) {
        this.xmax = _value;
    }

    public void setYMin(double _value) {
        this.ymin = _value;
    }

    public void setYMax(double _value) {
        this.ymax = _value;
    }

    public void setMinMax(double _minx, double _maxx, double _miny, double _maxy) {
        this.xmin = _minx;
        this.xmax = _maxx;
        this.ymin = _miny;
        this.ymax = _maxy;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    public double getWidth() {
        return this.image.getRaster().getWidth();
    }

    public double getHeight() {
        return this.image.getRaster().getHeight();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    int xToPix(int x) {
        return (int)((double)this.image.getRaster().getWidth() * ((double)x - this.xmin) / (this.xmax - this.xmin));
    }

    int yToPix(int y) {
        return (int)((double)this.image.getRaster().getHeight() * (this.ymax - (double)y) / (this.ymax - this.ymin));
    }

    public Color getPixColor(int xpix, int ypix) {
        return new Color(this.image.getRGB(xpix, ypix));
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    class ImageData {
        private int[] color;
        float[][] data;
        int nextPoint = 0;

        ImageData(Color c) {
            this.setColor(c);
            this.data = new float[2][64];
        }

        void setColor(Color c) {
            this.color = new int[4];
            this.color[0] = c.getRed();
            this.color[1] = c.getGreen();
            this.color[2] = c.getBlue();
            this.color[3] = DataRaster.this.alpha;
        }

        private synchronized void increaseCapacity(int size) {
            size = Math.min(size, DataRaster.this.maxPoints);
            float[][] newData = new float[2][size];
            int newNext = Math.min(this.nextPoint, 3 * size / 4);
            System.arraycopy(this.data[0], this.nextPoint - newNext, newData[0], 0, newNext);
            System.arraycopy(this.data[1], this.nextPoint - newNext, newData[1], 0, newNext);
            this.nextPoint = newNext;
            this.data = newData;
        }

        synchronized void clear() {
            this.data = new float[2][64];
            this.nextPoint = 0;
        }

        void append(double x, double y) {
            if (Double.isNaN(x) || Double.isInfinite(x) || Double.isNaN(y) || Double.isInfinite(y)) {
                return;
            }
            if (this.nextPoint >= this.data[0].length) {
                this.increaseCapacity(this.data[0].length * 2);
            }
            this.data[0][this.nextPoint] = (float)x;
            this.data[1][this.nextPoint] = (float)y;
            ++this.nextPoint;
            WritableRaster raster = DataRaster.this.image.getRaster();
            if (raster.getWidth() < 2) {
                return;
            }
            int i = (int)((double)raster.getWidth() * (x - DataRaster.this.xmin) / (DataRaster.this.xmax - DataRaster.this.xmin));
            int j = (int)((double)raster.getHeight() * (DataRaster.this.ymax - y) / (DataRaster.this.ymax - DataRaster.this.ymin));
            if (i < 0 || j < 0 || i >= raster.getWidth() || j >= raster.getHeight()) {
                return;
            }
            try {
                raster.setPixel(i, j, this.color);
            }
            catch (Exception ex) {
                System.out.println("Error setting raster in ImageData append.");
            }
        }

        void render() {
            WritableRaster raster = DataRaster.this.image.getRaster();
            for (int c = 0; c < this.nextPoint; ++c) {
                int i = (int)((double)raster.getWidth() * ((double)this.data[0][c] - DataRaster.this.xmin) / (DataRaster.this.xmax - DataRaster.this.xmin));
                int j = (int)((double)raster.getHeight() * (DataRaster.this.ymax - (double)this.data[1][c]) / (DataRaster.this.ymax - DataRaster.this.ymin));
                if (i < 0 || j < 0 || i >= raster.getWidth() || j >= raster.getHeight()) {
                    return;
                }
                try {
                    raster.setPixel(i, j, this.color);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Error setting raster in ImageData render.");
                }
            }
        }
    }
}

