/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;

public class GrayscalePlot
extends MeasuredImage
implements Plot2D {
    GridData griddata;
    double floor;
    double ceil;
    boolean autoscaleZ = true;
    short[] bwData;
    Grid grid;
    private int ampIndex = 0;
    private JFrame legendFrame;

    public GrayscalePlot(GridData griddata) {
        this.setGridData(griddata);
        this.update();
    }

    public double indexToX(int i) {
        return this.griddata.indexToX(i);
    }

    public double indexToY(int i) {
        return this.griddata.indexToY(i);
    }

    public int xToIndex(double x) {
        return this.griddata.xToIndex(x);
    }

    public int yToIndex(double y) {
        return this.griddata.yToIndex(y);
    }

    public void setAll(Object obj) {
        double[][] val = (double[][])obj;
        this.copyData(val);
        this.update();
    }

    public void setAll(Object obj, double xmin, double xmax, double ymin, double ymax) {
        double[][] val = (double[][])obj;
        this.copyData(val);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.griddata.setScale(xmin, xmax, ymin, ymax);
        }
        this.setMinMax(xmin, xmax, ymin, ymax);
        this.update();
    }

    private void copyData(double[][] val) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != val.length || this.griddata.getNy() != val[0].length) {
            this.griddata = new ArrayData(val.length, val[0].length, 1);
            this.setGridData(this.griddata);
        }
        double[][] data = this.griddata.getData()[0];
        int ny = data[0].length;
        int nx = data.length;
        for (int i = 0; i < nx; ++i) {
            System.arraycopy(val[i], 0, data[i], 0, ny);
        }
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public void setGridData(GridData _griddata) {
        this.griddata = _griddata;
        if (this.griddata == null) {
            return;
        }
        int nx = this.griddata.getNx();
        int ny = this.griddata.getNy();
        int size = nx * ny;
        Grid newgrid = new Grid(nx, ny, this.xmin, this.xmax, this.ymin, this.ymax);
        if (this.grid != null) {
            newgrid.setColor(this.grid.getColor());
            newgrid.setVisible(this.grid.isVisible());
        } else {
            newgrid.setColor(Color.pink);
        }
        this.grid = newgrid;
        ComponentColorModel ccm = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
        ComponentSampleModel csm = new ComponentSampleModel(1, nx, ny, 1, nx, new int[]{0});
        this.bwData = new short[size];
        DataBufferUShort databuffer = new DataBufferUShort(this.bwData, size);
        WritableRaster raster = Raster.createWritableRaster(csm, databuffer, new Point(0, 0));
        this.image = new BufferedImage(ccm, raster, true, null);
        this.xmin = this.griddata.getLeft();
        this.xmax = this.griddata.getRight();
        this.ymin = this.griddata.getBottom();
        this.ymax = this.griddata.getTop();
    }

    public JFrame showLegend() {
        InteractivePanel dp = new InteractivePanel();
        dp.setPreferredSize(new Dimension(300, 66));
        dp.setGutters(0, 0, 0, 35);
        dp.setClipAtGutter(false);
        if (this.legendFrame == null) {
            this.legendFrame = new JFrame("Legend");
        }
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(dp);
        int numColors = 256;
        GridPointData pointdata = new GridPointData(numColors, 1, 1);
        double[][][] data = pointdata.getData();
        double delta = (this.ceil - this.floor) / (double)numColors;
        double cval = this.floor - delta / 2.0;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i][0][2] = cval;
            cval += delta;
        }
        pointdata.setScale(this.floor - delta, this.ceil + delta, 0.0, 1.0);
        GrayscalePlot cb = new GrayscalePlot(pointdata);
        cb.setShowGridLines(false);
        cb.setAutoscaleZ(false, this.floor, this.ceil);
        cb.update();
        dp.addDrawable(cb);
        XAxis xaxis = new XAxis("");
        xaxis.setLocationType(2);
        xaxis.setLocation(-0.5);
        xaxis.setEnabled(true);
        dp.addDrawable(xaxis);
        this.legendFrame.pack();
        ((Component)this.legendFrame).setVisible(true);
        return this.legendFrame;
    }

    public void setAutoscaleZ(boolean isAutoscale, double _floor, double _ceil) {
        this.autoscaleZ = isAutoscale;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.floor = _floor;
            this.ceil = _ceil;
        }
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return this.floor;
    }

    public double getCeiling() {
        return this.ceil;
    }

    public void setShowGridLines(boolean showGrid) {
        this.grid.setVisible(showGrid);
    }

    public void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.autoscaleZ) {
            double[] minmax = this.griddata.getZRange(this.ampIndex);
            this.floor = minmax[0];
            this.ceil = minmax[1];
        }
        this.recolorImage();
    }

    public void setIndexes(int[] indexes) {
        this.ampIndex = indexes[0];
    }

    protected void recolorImage() {
        block8: {
            double zscale;
            int ny;
            int nx;
            double[][][] data;
            block7: {
                if (this.griddata == null) {
                    return;
                }
                if (this.griddata.isCellData()) {
                    double dx = this.griddata.getDx();
                    double dy = this.griddata.getDy();
                    this.xmin = this.griddata.getLeft() - dx / 2.0;
                    this.xmax = this.griddata.getRight() + dx / 2.0;
                    this.ymin = this.griddata.getBottom() + dy / 2.0;
                    this.ymax = this.griddata.getTop() - dy / 2.0;
                } else {
                    this.xmin = this.griddata.getLeft();
                    this.xmax = this.griddata.getRight();
                    this.ymin = this.griddata.getBottom();
                    this.ymax = this.griddata.getTop();
                }
                this.grid.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
                data = this.griddata.getData();
                nx = this.griddata.getNx();
                ny = this.griddata.getNy();
                zscale = 65534.0 / (this.ceil - this.floor);
                if (!(this.griddata instanceof GridPointData)) break block7;
                int index = this.ampIndex + 2;
                for (int ix = 0; ix < nx; ++ix) {
                    for (int iy = 0; iy < ny; ++iy) {
                        double val = zscale * (data[ix][iy][index] - this.floor);
                        this.bwData[iy * nx + ix] = val < 0.0 ? 0 : (val > 65534.0 ? -2 : (short)val);
                    }
                }
                break block8;
            }
            if (!(this.griddata instanceof ArrayData)) break block8;
            for (int ix = 0; ix < nx; ++ix) {
                for (int iy = 0; iy < ny; ++iy) {
                    double val = zscale * (data[this.ampIndex][ix][iy] - this.floor);
                    this.bwData[iy * nx + ix] = val < 0.0 ? 0 : (val > 65534.0 ? -2 : (short)val);
                }
            }
        }
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (this.griddata == null) {
            return;
        }
        super.draw(panel, g);
        this.grid.draw(panel, g);
    }

    public void setFloorCeilColor(Color floorColor, Color ceilColor) {
    }

    public void setColorPalette(Color[] colors) {
    }

    public void setPaletteType(int type) {
    }

    public void setGridLineColor(Color c) {
        this.grid.setColor(c);
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public Object createObject(XMLControl control) {
                return new GrayscalePlot(null);
            }
        };
    }
}

