/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.MeasuredImage;

public class IntegerRaster
extends MeasuredImage
implements Dimensioned {
    public static int WHITE = 0xFFFFFF;
    WritableRaster raster;
    byte[][] rgbData;
    int nrow;
    int ncol;
    boolean visible = true;
    Dimension dimension;

    public IntegerRaster(int _nrow, int _ncol) {
        this.nrow = _nrow;
        this.ncol = _ncol;
        this.dimension = new Dimension(this.ncol, this.nrow);
        int size = this.nrow * this.ncol;
        ComponentColorModel ccm = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
        BandedSampleModel csm = new BandedSampleModel(0, this.ncol, this.nrow, this.ncol, new int[]{0, 1, 2}, new int[]{0, 0, 0});
        this.rgbData = new byte[3][size];
        DataBufferByte databuffer = new DataBufferByte(this.rgbData, size);
        WritableRaster raster = Raster.createWritableRaster(csm, databuffer, new Point(0, 0));
        this.image = new BufferedImage(ccm, raster, false, null);
        this.xmin = 0.0;
        this.xmax = this.ncol;
        this.ymin = this.nrow;
        this.ymax = 0.0;
    }

    public void setBlock(int row_offset, int col_offset, int[][] val) {
        if (row_offset < 0 || row_offset + val.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in integer raster setBlock.");
        }
        if (col_offset < 0 || col_offset + val[0].length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in integer raster setBlock.");
        }
        int nr = val.length + row_offset;
        for (int rindex = row_offset; rindex < nr; ++rindex) {
            int nc = val[0].length + col_offset;
            for (int cindex = col_offset; cindex < nc; ++cindex) {
                int index = rindex * this.ncol + cindex;
                int pixval = val[rindex - row_offset][cindex - col_offset];
                this.rgbData[0][index] = (byte)(pixval >> 16 & 0xFF);
                this.rgbData[1][index] = (byte)(pixval >> 8 & 0xFF);
                this.rgbData[2][index] = (byte)(pixval >> 0 & 0xFF);
            }
        }
    }

    public void setRow(int row, int col_offset, int[] val) {
        if (row < 0 || row >= this.nrow) {
            throw new IllegalArgumentException("Row index out of range in integer raster setBlock.");
        }
        if (col_offset < 0 || col_offset + val.length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in integer raster setBlock.");
        }
        int nc = val.length + col_offset;
        for (int cindex = col_offset; cindex < nc; ++cindex) {
            int index = row * this.ncol + cindex;
            int pixval = val[cindex - col_offset];
            this.rgbData[0][index] = (byte)(pixval >> 16 & 0xFF);
            this.rgbData[1][index] = (byte)(pixval >> 8 & 0xFF);
            this.rgbData[2][index] = (byte)(pixval >> 0 & 0xFF);
        }
    }

    public void setCol(int row_offset, int col, int[] val) {
        if (row_offset < 0 || row_offset + val.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in integer raster setBlock.");
        }
        if (col < 0 || col >= this.ncol) {
            throw new IllegalArgumentException("Column index out of range in integer raster setBlock.");
        }
        int nr = val.length + row_offset;
        for (int rindex = row_offset; rindex < nr; ++rindex) {
            int index = rindex * this.ncol + col;
            int pixval = val[rindex - row_offset];
            this.rgbData[0][index] = (byte)(pixval >> 16 & 0xFF);
            this.rgbData[1][index] = (byte)(pixval >> 8 & 0xFF);
            this.rgbData[2][index] = (byte)(pixval >> 0 & 0xFF);
        }
    }

    public void setCell(int _row, int _col, int val) {
        int index = _row * this.ncol + _col;
        this.rgbData[0][index] = (byte)(val >> 16 & 0xFF);
        this.rgbData[1][index] = (byte)(val >> 8 & 0xFF);
        this.rgbData[2][index] = (byte)(val >> 0 & 0xFF);
    }

    public int getCell(int _row, int _col) {
        int index = _row * this.ncol + _col;
        return (this.rgbData[0][index] & 0xFF) << 16 | (this.rgbData[1][index] & 0xFF) << 8 | (this.rgbData[2][index] & 0xFF) << 0;
    }

    public Dimension getInterior(DrawingPanel panel) {
        panel.setPreferredMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        return this.dimension;
    }

    public void draw(DrawingPanel panel, Graphics g) {
        g.drawImage(this.image, 1 + panel.xToPix(this.xmin), 1 + panel.yToPix(this.ymax), panel);
    }
}

