/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.Random;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class TriangularBinaryLattice
implements Measurable {
    byte[] packedData;
    int nrow;
    int ncol;
    boolean visible = true;
    double xmin;
    double ymin;
    double xmax;
    double ymax;
    Color zeroColor = Color.red;
    Color oneColor = Color.blue;
    static final double SQRT3_OVER2 = Math.sqrt(3.0) / 2.0;
    static final int BITS_PER_BYTE = 8;
    static final int radius = 3;
    static final int diameter = 6;

    public TriangularBinaryLattice(int _nrow, int _ncol) {
        this.nrow = _nrow;
        this.ncol = _ncol;
        int len = (this.ncol + 7) / 8 * this.nrow;
        this.packedData = new byte[len];
        this.xmin = 0.0;
        this.xmax = (double)this.ncol - 0.5;
        this.ymin = (double)this.nrow * SQRT3_OVER2 - SQRT3_OVER2;
        if (this.ymin == 0.0) {
            this.ymin = SQRT3_OVER2;
        }
        this.ymax = 0.0;
    }

    public boolean isMeasured() {
        return true;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMax() {
        return this.ymax;
    }

    public void randomize() {
        Random random = new Random();
        random.nextBytes(this.packedData);
    }

    public void randomize(double probability) {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("Probability must be between 0 and 1");
        }
        Random random = new Random();
        int size = this.packedData.length;
        for (int i = 0; i < size; ++i) {
            byte packedcell = 0;
            for (int j = 8; j > 0; --j) {
                int mask = 128 >>> j - 1;
                double d = random.nextDouble();
                packedcell = d >= probability ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
            }
            this.packedData[i] = packedcell;
        }
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        Shape oldClip = g.getClip();
        g.setClip(null);
        int row = 0;
        int column = 0;
        int size = this.packedData.length;
        block0: for (int i = 0; i < size; ++i) {
            byte packedCell = this.packedData[i];
            for (int j = 8; j > 0 && column < this.ncol; ++column, --j) {
                byte val = (byte)(packedCell >>> j - 1);
                int one_or_zero = val & 1;
                if (one_or_zero == 0) {
                    g.setColor(this.zeroColor);
                } else {
                    g.setColor(this.oneColor);
                }
                if (row % 2 == 1) {
                    g.fillOval(panel.xToPix((double)column + 0.5) - 3, panel.yToPix((double)row * SQRT3_OVER2) - 3, 6, 6);
                } else {
                    g.fillOval(panel.xToPix(column) - 3, panel.yToPix((double)row * SQRT3_OVER2) - 3, 6, 6);
                }
                if (column != this.ncol - 1) continue;
                column = 0;
                ++row;
                continue block0;
            }
        }
        g.setClip(oldClip);
    }

    public void setMinMax(double xmin, double xmax, double ymin, double ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public void setBlock(int row_offset, int col_offset, int[][] val) {
        if (row_offset < 0 || row_offset + val.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (col_offset < 0 || col_offset + val[0].length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int nr = val.length + row_offset;
        for (int rindex = row_offset; rindex < nr; ++rindex) {
            int nc = val[0].length + col_offset;
            for (int cindex = col_offset; cindex < nc; ++cindex) {
                int arrayIndex = rindex * ((this.ncol + 7) / 8) + cindex / 8;
                byte packedcell = this.packedData[arrayIndex];
                int mask = 128 >>> cindex % 8;
                packedcell = val[rindex - row_offset][cindex - col_offset] <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
                this.packedData[arrayIndex] = packedcell;
            }
        }
    }

    public void setBlock(int row_offset, int col_offset, byte[][] val) {
        if (row_offset < 0 || row_offset + val.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (col_offset < 0 || col_offset + val[0].length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int nr = val.length + row_offset;
        for (int rindex = row_offset; rindex < nr; ++rindex) {
            int nc = val[0].length + col_offset;
            for (int cindex = col_offset; cindex < nc; ++cindex) {
                int arrayIndex = rindex * ((this.ncol + 7) / 8) + cindex / 8;
                byte packedcell = this.packedData[arrayIndex];
                int mask = 128 >>> cindex % 8;
                packedcell = val[rindex - row_offset][cindex - col_offset] <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
                this.packedData[arrayIndex] = packedcell;
            }
        }
    }

    public void setCol(int row_offset, int col, int[] val) {
        if (row_offset < 0 || row_offset + val.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setCol.");
        }
        if (col < 0 || col >= this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setCol.");
        }
        int nr = val.length + row_offset;
        for (int rindex = row_offset; rindex < nr; ++rindex) {
            int arrayIndex = rindex * ((this.ncol + 7) / 8) + col / 8;
            byte packedcell = this.packedData[arrayIndex];
            int mask = 128 >>> col % 8;
            packedcell = val[rindex - row_offset] <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
            this.packedData[arrayIndex] = packedcell;
        }
    }

    public void setCol(int row_offset, int col, byte[] val) {
        if (row_offset < 0 || row_offset + val.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setCol.");
        }
        if (col < 0 || col >= this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setCol.");
        }
        int nr = val.length + row_offset;
        for (int rindex = row_offset; rindex < nr; ++rindex) {
            int arrayIndex = rindex * ((this.ncol + 7) / 8) + col / 8;
            byte packedcell = this.packedData[arrayIndex];
            int mask = 128 >>> col % 8;
            packedcell = val[rindex - row_offset] <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
            this.packedData[arrayIndex] = packedcell;
        }
    }

    public void setRow(int row, int col_offset, int[] val) {
        if (row < 0 || row >= this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setRow.");
        }
        if (col_offset < 0 || col_offset + val.length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setRow.");
        }
        int nc = val.length + col_offset;
        for (int cindex = col_offset; cindex < nc; ++cindex) {
            int arrayIndex = row * ((this.ncol + 7) / 8) + cindex / 8;
            byte packedcell = this.packedData[arrayIndex];
            int mask = 128 >>> cindex % 8;
            packedcell = val[cindex - col_offset] <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
            this.packedData[arrayIndex] = packedcell;
        }
    }

    public void setRow(int row, int col_offset, byte[] val) {
        if (row < 0 || row >= this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setRow.");
        }
        if (col_offset < 0 || col_offset + val.length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setRow.");
        }
        int nc = val.length + col_offset;
        for (int cindex = col_offset; cindex < nc; ++cindex) {
            int arrayIndex = row * ((this.ncol + 7) / 8) + cindex / 8;
            byte packedcell = this.packedData[arrayIndex];
            int mask = 128 >>> cindex % 8;
            packedcell = val[cindex - col_offset] <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
            this.packedData[arrayIndex] = packedcell;
        }
    }

    public void setCell(int _row, int _col, int val) {
        if (_row < 0 || _row >= this.nrow || _col < 0 || _col >= this.ncol) {
            throw new IllegalArgumentException("Cell row or column index out of range.  row=" + _row + "  col=" + _col);
        }
        int arrayIndex = _row * ((this.ncol + 7) / 8) + _col / 8;
        byte packedcell = this.packedData[arrayIndex];
        int mask = 128 >>> _col % 8;
        packedcell = val <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
        this.packedData[arrayIndex] = packedcell;
    }

    public byte getCell(int _row, int _col) {
        byte packedcell = this.packedData[_row * ((this.ncol + 7) / 8) + _col / 8];
        int mask = 128 >>> _col % 8;
        if ((packedcell & mask) > 0) {
            return 1;
        }
        return 0;
    }

    public void setColorPalette(Color[] colors) {
        if (colors.length != 2) {
            throw new IllegalArgumentException("Array must have length of 2");
        }
        this.zeroColor = colors[0];
        this.oneColor = colors[1];
    }

    public void setIndexedColor(int i, Color color) {
        if (i == 0) {
            this.zeroColor = color;
        } else {
            this.oneColor = color;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.nrow * this.ncol + this.nrow);
        int row = 0;
        int column = 0;
        int size = this.packedData.length;
        block0: for (int i = 0; i < size; ++i) {
            byte packedCell = this.packedData[i];
            for (int j = 8; j > 0 && column < this.ncol; ++column, --j) {
                byte val = (byte)(packedCell >>> j - 1);
                int one_or_zero = val & 1;
                if (one_or_zero == 0) {
                    sb.append("0");
                } else {
                    sb.append("1");
                }
                if (column != this.ncol - 1) continue;
                if (i != size - 1) {
                    sb.append("\n");
                }
                column = 0;
                ++row;
                continue block0;
            }
        }
        return sb.toString();
    }
}

