/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.Random;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.axes.XAxis;

public class TriangularByteLattice
implements Measurable {
    int nrow;
    int ncol;
    byte[][] data;
    double xmin;
    double ymin;
    double xmax;
    double ymax;
    static final double SQRT3_OVER2 = Math.sqrt(3.0) / 2.0;
    boolean visible = true;
    Color[] colors = new Color[256];
    static final int radius = 3;
    static final int diameter = 6;
    JFrame legendFrame;

    public TriangularByteLattice(int _row, int _col) {
        this.nrow = _row;
        this.ncol = _col;
        this.createDefaultColors();
        this.data = new byte[this.nrow][this.ncol];
        this.xmin = 0.0;
        this.xmax = (double)this.ncol - 0.5;
        this.ymin = (double)(this.nrow - 1) * SQRT3_OVER2;
        if (this.ymin == 0.0) {
            this.ymin = SQRT3_OVER2;
        }
        this.ymax = 0.0;
    }

    public void setMinMax(double xmin, double xmax, double ymin, double ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        Shape oldClip = g.getClip();
        g.setClip(null);
        for (int y = 0; y < this.nrow; ++y) {
            for (int x = 0; x < this.ncol; ++x) {
                byte val = this.data[y][x];
                g.setColor(this.colors[val & 0xFF]);
                if (y % 2 == 1) {
                    g.fillOval(panel.xToPix((double)x + 0.5) - 3, panel.yToPix((double)y * SQRT3_OVER2) - 3, 6, 6);
                    continue;
                }
                g.fillOval(panel.xToPix(x) - 3, panel.yToPix((double)y * SQRT3_OVER2) - 3, 6, 6);
            }
        }
        g.setClip(oldClip);
    }

    public void setBlock(int row_offset, int col_offset, byte[][] val) {
        if (row_offset < 0 || row_offset + val.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (col_offset < 0 || col_offset + val[0].length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int nr = val.length + row_offset;
        for (int rindex = row_offset; rindex < nr; ++rindex) {
            int nc = val[0].length + col_offset;
            for (int cindex = col_offset; cindex < nc; ++cindex) {
                this.data[rindex][cindex] = val[rindex - row_offset][cindex - col_offset];
            }
        }
    }

    public void setCol(int row_offset, int col, byte[] val) {
        if (row_offset < 0 || row_offset + val.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (col < 0 || col >= this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int nr = val.length + row_offset;
        for (int rindex = row_offset; rindex < nr; ++rindex) {
            this.data[rindex][col] = val[rindex - row_offset];
        }
    }

    public void setRow(int row, int col_offset, byte[] val) {
        if (row < 0 || row >= this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (col_offset < 0 || col_offset + val.length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int nc = val.length + col_offset;
        for (int cindex = col_offset; cindex < nc; ++cindex) {
            this.data[row][cindex] = val[cindex - col_offset];
        }
    }

    public void setCell(int row, int col, byte val) {
        this.data[row][col] = val;
    }

    public int getCell(int row, int col) {
        return this.data[row][col];
    }

    public void randomize() {
        Random random = new Random();
        int nr = this.data.length;
        for (int rindex = 0; rindex < nr; ++rindex) {
            int nc = this.data[0].length;
            for (int cindex = 0; cindex < nc; ++cindex) {
                this.data[rindex][cindex] = (byte)random.nextInt(256);
            }
        }
    }

    public void showLegend() {
        InteractivePanel dp = new InteractivePanel();
        dp.setPreferredSize(new Dimension(300, 66));
        dp.setGutters(0, 0, 0, 35);
        dp.setClipAtGutter(false);
        if (this.legendFrame == null) {
            this.legendFrame = new JFrame("Legend");
        }
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(dp);
        TriangularByteLattice lattice = new TriangularByteLattice(1, 256);
        lattice.setMinMax(-128.0, 127.0, 0.0, 1.0);
        byte[][] data = new byte[1][256];
        for (int i = 0; i < 256; ++i) {
            data[0][i] = (byte)i;
        }
        lattice.setBlock(0, 0, data);
        dp.addDrawable(lattice);
        XAxis xaxis = new XAxis("");
        xaxis.setLocationType(2);
        xaxis.setLocation(-0.5);
        xaxis.setEnabled(true);
        dp.addDrawable(xaxis);
        this.legendFrame.pack();
        ((Component)this.legendFrame).setVisible(true);
    }

    public void setColorPalette(Color[] colors) {
        int i;
        int n = colors.length;
        for (i = 0; i < n; ++i) {
            this.colors[i] = colors[i];
        }
        for (i = colors.length; i < 256; ++i) {
            this.colors[i] = Color.black;
        }
    }

    public void setIndexedColor(int i, Color color) {
        i = (i + 256) % this.colors.length;
        this.colors[i] = color;
    }

    public boolean isMeasured() {
        return true;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMax() {
        return this.ymax;
    }

    void createDefaultColors() {
        for (int i = 0; i < 256; ++i) {
            Color c;
            this.colors[i] = c = Color.getHSBColor((-0.07f + 0.8f * (float)i / 255.0f) % 1.0f, 1.0f, 1.0f);
        }
    }
}

