/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.display2d.GridPointData;

public class Util2D {
    private Util2D() {
    }

    public static GridPointData laplacian(GridPointData input, double multiplier) {
        return null;
    }

    public static GridPointData divergence(GridPointData input, double multiplier) {
        double dudy;
        double dudx;
        int j;
        int i;
        double[][][] indata = input.getData();
        int nx = indata.length;
        int ny = indata[0].length;
        GridPointData output = input.createGridPointData(1);
        output.left = input.left;
        output.right = input.right;
        output.top = input.top;
        output.bottom = input.bottom;
        output.dx = input.dx;
        output.dy = input.dy;
        double[][][] outdata = output.getData();
        double dx2 = 2.0 * input.dx / multiplier;
        double dy2 = 2.0 * input.dy / multiplier;
        for (i = 1; i < nx - 1; ++i) {
            for (j = 1; j < ny - 1; ++j) {
                dudx = (indata[i + 1][j][2] - indata[i - 1][j][2]) / dx2;
                dudy = (indata[i][j + 1][2] - indata[i][j - 1][2]) / dy2;
                outdata[i][j][0] = indata[i][j][0];
                outdata[i][j][1] = indata[i][j][1];
                outdata[i][j][2] = dudx + dudy;
            }
        }
        for (i = 1; i < nx - 1; ++i) {
            dudx = (indata[i + 1][0][2] - indata[i - 1][0][2]) / dx2;
            dudy = (-3.0 * indata[i][0][2] + 4.0 * indata[i][1][2] - indata[i][2][2]) / dy2;
            outdata[i][0][2] = dudx + dudy;
        }
        int my = ny - 1;
        for (int i2 = 1; i2 < nx - 1; ++i2) {
            dudx = (indata[i2 + 1][my][2] - indata[i2 - 1][my][2]) / dx2;
            dudy = (3.0 * indata[i2][my][2] - 4.0 * indata[i2][my - 1][2] + indata[i2][my - 2][2]) / dy2;
            outdata[i2][my][2] = dudx + dudy;
        }
        for (j = 1; j < ny - 1; ++j) {
            dudx = (-3.0 * indata[0][j][2] + 4.0 * indata[1][j][2] - indata[2][j][2]) / dx2;
            dudy = (indata[0][j + 1][2] - indata[0][j - 1][2]) / dy2;
            outdata[0][j][2] = dudx + dudy;
        }
        int mx = nx - 1;
        for (int j2 = 1; j2 < ny - 1; ++j2) {
            dudx = (3.0 * indata[mx][j2][2] - 4.0 * indata[mx - 1][j2][2] + indata[mx - 2][j2][2]) / dx2;
            dudy = (indata[mx][j2 + 1][2] - indata[mx][j2 - 1][2]) / dy2;
            outdata[mx][j2][2] = dudx + dudy;
        }
        dudx = (outdata[1][0][2] * outdata[1][0][3] + outdata[0][1][2] * outdata[0][1][3]) / 2.0;
        dudy = (outdata[1][0][2] * outdata[1][0][4] + outdata[0][1][2] * outdata[0][1][4]) / 2.0;
        outdata[0][0][2] = dudx + dudy;
        dudx = (outdata[0][my - 1][2] * outdata[0][my - 1][3] + outdata[1][my][2] * outdata[1][my][3]) / 2.0;
        dudy = (outdata[0][my - 1][2] * outdata[0][my - 1][4] + outdata[1][my][2] * outdata[1][my][4]) / 2.0;
        outdata[0][my][2] = dudx + dudy;
        dudx = (outdata[mx][1][2] * outdata[mx][1][3] + outdata[mx - 1][0][2] * outdata[mx - 1][0][3]) / 2.0;
        dudy = (outdata[mx][1][2] * outdata[mx][1][4] + outdata[mx - 1][0][2] * outdata[mx - 1][0][4]) / 2.0;
        outdata[mx][0][2] = dudx + dudy;
        dudx = (outdata[mx][my - 1][2] * outdata[mx][my - 1][3] + outdata[mx - 1][my][2] * outdata[mx - 1][my][3]) / 2.0;
        dudy = (outdata[mx][my - 1][2] * outdata[mx][my - 1][4] + outdata[mx - 1][my][2] * outdata[mx - 1][my][4]) / 2.0;
        outdata[mx][my][2] = dudx + dudy;
        return output;
    }

    public static GridPointData gradient(GridPointData input, double multiplier) {
        double mag;
        double dudy;
        double dudx;
        int j;
        int i;
        double[][][] indata = input.getData();
        int nx = indata.length;
        int ny = indata[0].length;
        GridPointData output = input.createGridPointData(3);
        output.left = input.left;
        output.right = input.right;
        output.top = input.top;
        output.bottom = input.bottom;
        output.dx = input.dx;
        output.dy = input.dy;
        double[][][] outdata = output.getData();
        double dx2 = 2.0 * input.dx / multiplier;
        double dy2 = 2.0 * input.dy / multiplier;
        for (i = 1; i < nx - 1; ++i) {
            for (j = 1; j < ny - 1; ++j) {
                dudx = (indata[i + 1][j][2] - indata[i - 1][j][2]) / dx2;
                dudy = (indata[i][j + 1][2] - indata[i][j - 1][2]) / dy2;
                mag = Math.sqrt(dudx * dudx + dudy * dudy);
                outdata[i][j][0] = indata[i][j][0];
                outdata[i][j][1] = indata[i][j][1];
                outdata[i][j][2] = mag;
                outdata[i][j][3] = dudx / mag;
                outdata[i][j][4] = dudy / mag;
            }
        }
        for (i = 1; i < nx - 1; ++i) {
            dudx = (indata[i + 1][0][2] - indata[i - 1][0][2]) / dx2;
            dudy = (-3.0 * indata[i][0][2] + 4.0 * indata[i][1][2] - indata[i][2][2]) / dy2;
            outdata[i][0][2] = mag = Math.sqrt(dudx * dudx + dudy * dudy);
            outdata[i][0][3] = dudx / mag;
            outdata[i][0][4] = dudy / mag;
        }
        int my = ny - 1;
        for (int i2 = 1; i2 < nx - 1; ++i2) {
            dudx = (indata[i2 + 1][my][2] - indata[i2 - 1][my][2]) / dx2;
            dudy = (3.0 * indata[i2][my][2] - 4.0 * indata[i2][my - 1][2] + indata[i2][my - 2][2]) / dy2;
            outdata[i2][my][2] = mag = Math.sqrt(dudx * dudx + dudy * dudy);
            outdata[i2][my][3] = dudx / mag;
            outdata[i2][my][4] = dudy / mag;
        }
        for (j = 1; j < ny - 1; ++j) {
            dudx = (-3.0 * indata[0][j][2] + 4.0 * indata[1][j][2] - indata[2][j][2]) / dx2;
            dudy = (indata[0][j + 1][2] - indata[0][j - 1][2]) / dy2;
            outdata[0][j][2] = mag = Math.sqrt(dudx * dudx + dudy * dudy);
            outdata[0][j][3] = dudx / mag;
            outdata[0][j][4] = dudy / mag;
        }
        int mx = nx - 1;
        for (int j2 = 1; j2 < ny - 1; ++j2) {
            dudx = (3.0 * indata[mx][j2][2] - 4.0 * indata[mx - 1][j2][2] + indata[mx - 2][j2][2]) / dx2;
            dudy = (indata[mx][j2 + 1][2] - indata[mx][j2 - 1][2]) / dy2;
            outdata[mx][j2][2] = mag = Math.sqrt(dudx * dudx + dudy * dudy);
            outdata[mx][j2][3] = dudx / mag;
            outdata[mx][j2][4] = dudy / mag;
        }
        dudx = (outdata[1][0][2] * outdata[1][0][3] + outdata[0][1][2] * outdata[0][1][3]) / 2.0;
        dudy = (outdata[1][0][2] * outdata[1][0][4] + outdata[0][1][2] * outdata[0][1][4]) / 2.0;
        outdata[0][0][2] = mag = Math.sqrt(dudx * dudx + dudy * dudy);
        outdata[0][0][3] = dudx / mag;
        outdata[0][0][4] = dudy / mag;
        dudx = (outdata[0][my - 1][2] * outdata[0][my - 1][3] + outdata[1][my][2] * outdata[1][my][3]) / 2.0;
        dudy = (outdata[0][my - 1][2] * outdata[0][my - 1][4] + outdata[1][my][2] * outdata[1][my][4]) / 2.0;
        outdata[0][my][2] = mag = Math.sqrt(dudx * dudx + dudy * dudy);
        outdata[0][my][3] = dudx / mag;
        outdata[0][my][4] = dudy / mag;
        dudx = (outdata[mx][1][2] * outdata[mx][1][3] + outdata[mx - 1][0][2] * outdata[mx - 1][0][3]) / 2.0;
        dudy = (outdata[mx][1][2] * outdata[mx][1][4] + outdata[mx - 1][0][2] * outdata[mx - 1][0][4]) / 2.0;
        outdata[mx][0][2] = mag = Math.sqrt(dudx * dudx + dudy * dudy);
        outdata[mx][0][3] = dudx / mag;
        outdata[mx][0][4] = dudy / mag;
        dudx = (outdata[mx][my - 1][2] * outdata[mx][my - 1][3] + outdata[mx - 1][my][2] * outdata[mx - 1][my][3]) / 2.0;
        dudy = (outdata[mx][my - 1][2] * outdata[mx][my - 1][4] + outdata[mx - 1][my][2] * outdata[mx - 1][my][4]) / 2.0;
        outdata[mx][my][2] = mag = Math.sqrt(dudx * dudx + dudy * dudy);
        outdata[mx][my][3] = dudx / mag;
        outdata[mx][my][4] = dudy / mag;
        return output;
    }
}

