/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import java.awt.Component;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display3d.core.DrawingPanel3D;

public interface DrawingFrame3D {
    public void setDrawingPanel3D(DrawingPanel3D var1);

    public DrawingPanel3D getDrawingPanel3D();

    public JFrame getJFrame();

    public void setVisible(boolean var1);

    public static class Loader
    implements XML.ObjectLoader {
        public Object createObject(XMLControl control) {
            DrawingFrame frame = new DrawingFrame();
            frame.setTitle(control.getString("title"));
            ((Component)frame).setLocation(control.getInt("location x"), control.getInt("location y"));
            frame.setSize(control.getInt("width"), control.getInt("height"));
            if (control.getBoolean("showing")) {
                frame.setVisible(true);
            }
            return frame;
        }

        public void saveObject(XMLControl control, Object obj) {
            DrawingFrame3D frame3D = (DrawingFrame3D)obj;
            JFrame frame = frame3D.getJFrame();
            control.setValue("title", frame.getTitle());
            control.setValue("showing", frame.isShowing());
            control.setValue("location x", frame.getLocation().x);
            control.setValue("location y", frame.getLocation().y);
            control.setValue("width", frame.getSize().width);
            control.setValue("height", frame.getSize().height);
            control.setValue("drawing panel", frame3D.getDrawingPanel3D());
        }

        public Object loadObject(XMLControl control, Object obj) {
            DrawingFrame3D frame3D = (DrawingFrame3D)obj;
            JFrame frame = frame3D.getJFrame();
            DrawingPanel3D panel = frame3D.getDrawingPanel3D();
            panel.removeAllElements();
            XMLControl panelControl = control.getChildControl("drawing panel");
            panelControl.loadObject(panel);
            panel.repaint();
            frame.setTitle(control.getString("title"));
            ((Component)frame).setLocation(control.getInt("location x"), control.getInt("location y"));
            ((Component)frame).setSize(control.getInt("width"), control.getInt("height"));
            if (control.getBoolean("showing")) {
                ((Component)frame).setVisible(true);
            }
            return obj;
        }
    }
}

