/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Camera;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.VisualizationHints;
import org.opensourcephysics.display3d.core.interaction.InteractionSource;

public interface DrawingPanel3D
extends InteractionSource {
    public static final int TARGET_PANEL = 0;
    public static final int BOTTOM_LEFT = 0;
    public static final int BOTTOM_RIGHT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int TOP_LEFT = 3;

    public Component getComponent();

    public void setPreferredMinMax(double var1, double var3, double var5, double var7, double var9, double var11);

    public double getPreferredMinX();

    public double getPreferredMaxX();

    public double getPreferredMinY();

    public double getPreferredMaxY();

    public double getPreferredMinZ();

    public double getPreferredMaxZ();

    public void zoomToFit();

    public void setSquareAspect(boolean var1);

    public boolean isSquareAspect();

    public VisualizationHints getVisualizationHints();

    public Camera getCamera();

    public BufferedImage render();

    public Image render(Image var1);

    public void repaint();

    public void addElement(Element var1);

    public void removeElement(Element var1);

    public void removeAllElements();

    public ArrayList getElements();

    public static abstract class Loader
    implements XML.ObjectLoader {
        public abstract Object createObject(XMLControl var1);

        public void saveObject(XMLControl control, Object obj) {
            DrawingPanel3D panel = (DrawingPanel3D)obj;
            control.setValue("preferred x min", panel.getPreferredMinX());
            control.setValue("preferred x max", panel.getPreferredMaxX());
            control.setValue("preferred y min", panel.getPreferredMinY());
            control.setValue("preferred y max", panel.getPreferredMaxY());
            control.setValue("preferred z min", panel.getPreferredMinZ());
            control.setValue("preferred z max", panel.getPreferredMaxZ());
            control.setValue("visualization hints", panel.getVisualizationHints());
            control.setValue("camera", panel.getCamera());
            control.setValue("elements", panel.getElements());
        }

        public Object loadObject(XMLControl control, Object obj) {
            DrawingPanel3D panel = (DrawingPanel3D)obj;
            double minX = control.getDouble("preferred x min");
            double maxX = control.getDouble("preferred x max");
            double minY = control.getDouble("preferred y min");
            double maxY = control.getDouble("preferred y max");
            double minZ = control.getDouble("preferred z min");
            double maxZ = control.getDouble("preferred z max");
            panel.setPreferredMinMax(minX, maxX, minY, maxY, minZ, maxZ);
            Collection elements = (Collection)control.getObject("elements");
            if (elements != null) {
                panel.removeAllElements();
                Iterator it = elements.iterator();
                while (it.hasNext()) {
                    panel.addElement((Element)it.next());
                }
            }
            return obj;
        }
    }
}

