/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Element;

public interface ElementEllipsoid
extends Element {
    public void setMinimumAngleU(int var1);

    public int getMinimumAngleU();

    public void setMaximumAngleU(int var1);

    public int getMaximumAngleU();

    public void setMinimumAngleV(int var1);

    public int getMinimumAngleV();

    public void setMaximumAngleV(int var1);

    public int getMaximumAngleV();

    public void setClosedBottom(boolean var1);

    public boolean isClosedBottom();

    public void setClosedTop(boolean var1);

    public boolean isClosedTop();

    public void setClosedLeft(boolean var1);

    public boolean isClosedLeft();

    public void setClosedRight(boolean var1);

    public boolean isClosedRight();

    public static abstract class Loader
    extends Element.Loader {
        public void saveObject(XMLControl control, Object obj) {
            super.saveObject(control, obj);
            ElementEllipsoid element = (ElementEllipsoid)obj;
            control.setValue("closed top", element.isClosedTop());
            control.setValue("closed bottom", element.isClosedBottom());
            control.setValue("closed left", element.isClosedLeft());
            control.setValue("closed right", element.isClosedRight());
            control.setValue("minimum u angle", element.getMinimumAngleU());
            control.setValue("maximum u angle", element.getMaximumAngleU());
            control.setValue("minimum v angle", element.getMinimumAngleV());
            control.setValue("maximum v angle", element.getMaximumAngleV());
        }

        public Object loadObject(XMLControl control, Object obj) {
            super.loadObject(control, obj);
            ElementEllipsoid element = (ElementEllipsoid)obj;
            element.setClosedTop(control.getBoolean("closed top"));
            element.setClosedBottom(control.getBoolean("closed bottom"));
            element.setClosedLeft(control.getBoolean("closed left"));
            element.setClosedRight(control.getBoolean("closed right"));
            element.setMinimumAngleU(control.getInt("minimum u angle"));
            element.setMaximumAngleU(control.getInt("maximum u angle"));
            element.setMinimumAngleV(control.getInt("minimum v angle"));
            element.setMaximumAngleV(control.getInt("maximum v angle"));
            return obj;
        }
    }
}

