/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;

public class Resolution {
    public static final int DIVISIONS = 0;
    public static final int MAX_LENGTH = 1;
    private int type = 0;
    private double maxLength = 1.0;
    private int n1 = 1;
    private int n2 = 1;
    private int n3 = 1;

    public Resolution(double max) {
        this.type = 1;
        this.maxLength = max;
    }

    public Resolution(int n1, int n2, int n3) {
        this.type = 0;
        this.n1 = n1;
        this.n2 = n2;
        this.n3 = n3;
    }

    public final int getType() {
        return this.type;
    }

    public final double getMaxLength() {
        return this.maxLength;
    }

    public final int getN1() {
        return this.n1;
    }

    public final int getN2() {
        return this.n2;
    }

    public final int getN3() {
        return this.n3;
    }

    public static XML.ObjectLoader getLoader() {
        return new ResolutionLoader();
    }

    public static class ResolutionLoader
    extends XMLLoader {
        public void saveObject(XMLControl control, Object obj) {
            Resolution res = (Resolution)obj;
            control.setValue("type", res.type);
            control.setValue("max length", res.maxLength);
            control.setValue("n1", res.n1);
            control.setValue("n2", res.n2);
            control.setValue("n3", res.n3);
        }

        public Object createObject(XMLControl control) {
            return new Resolution(1, 1, 1);
        }

        public Object loadObject(XMLControl control, Object obj) {
            Resolution res = (Resolution)obj;
            res.type = control.getInt("type");
            res.maxLength = control.getDouble("max length");
            res.n1 = control.getInt("n1");
            res.n2 = control.getInt("n2");
            res.n3 = control.getInt("n3");
            return obj;
        }
    }
}

