/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;

public abstract class AbstractTile
extends Element {
    protected int numberOfTiles = 0;
    protected double[][][] corners = null;
    private boolean drawQuickInterior = false;
    private int interiorTransparency = 128;
    private double displacementFactor = 1.0;
    private boolean levelBelowWhenEqual = true;
    private double levelx = 0.0;
    private double levely = 0.0;
    private double levelz = 0.0;
    private double leveldx = 0.0;
    private double leveldy = 0.0;
    private double leveldz = 1.0;
    private double[] levelZ = null;
    private Color[] levelColors = null;
    private int[][] a = null;
    private int[][] b = null;
    private double[] pixel = new double[3];
    private double[] center = new double[3];
    private double[] pixelOrigin = new double[3];
    private Object3D[] objects = null;

    public void setDisplacementFactor(double factor) {
        this.displacementFactor = factor;
    }

    public double GetDisplacementFactor() {
        return this.displacementFactor;
    }

    public void setDrawQuickInterior(boolean draw, int transparency) {
        this.drawQuickInterior = draw;
        this.interiorTransparency = Math.max(0, Math.min(transparency, 255));
    }

    public void setColorBelowWhenEqual(boolean belowWhenEqual) {
        this.levelBelowWhenEqual = belowWhenEqual;
    }

    public void setColorOriginAndDirection(double[] origin, double[] direction) {
        this.levelx = origin[0];
        this.levely = origin[1];
        this.levelz = origin[2];
        this.leveldx = direction[0];
        this.leveldy = direction[1];
        this.leveldz = direction[2];
    }

    public void setColorRegions(double[] thresholds, Color[] colors) {
        int i;
        if (thresholds == null || colors == null) {
            this.levelZ = null;
            this.levelColors = null;
            return;
        }
        this.levelZ = new double[thresholds.length];
        this.levelColors = new Color[thresholds.length + 1];
        for (i = 0; i < thresholds.length; ++i) {
            this.levelZ[i] = thresholds[i];
        }
        for (i = 0; i < thresholds.length + 1; ++i) {
            this.levelColors[i] = i < colors.length ? colors[i] : colors[colors.length - 1];
        }
        this.setElementChanged(true);
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computeCorners();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        if (this.numberOfTiles < 1) {
            return null;
        }
        return this.objects;
    }

    void draw(Graphics2D _g2, int _index) {
        if (this.levelZ != null) {
            this.drawColorCoded(_g2, _index);
            return;
        }
        int sides = this.corners[_index].length;
        if (this.getRealStyle().isDrawingFill()) {
            _g2.setPaint(this.getPanel().projectColor(this.getRealStyle().getFillColor(), this.objects[_index].getDistance()));
            _g2.fillPolygon(this.a[_index], this.b[_index], sides);
        }
        if (this.getRealStyle().isDrawingLines()) {
            _g2.setStroke(this.getRealStyle().getLineStroke());
            _g2.setColor(this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.objects[_index].getDistance()));
            _g2.drawPolygon(this.a[_index], this.b[_index], sides);
        }
    }

    void drawQuickly(Graphics2D _g2) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged()) {
            this.computeCorners();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        if (this.numberOfTiles < 1) {
            return;
        }
        _g2.setStroke(this.getRealStyle().getLineStroke());
        if (this.drawQuickInterior) {
            Color fillColor = this.getRealStyle().getFillColor();
            if (fillColor.getAlpha() > this.interiorTransparency) {
                fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), this.interiorTransparency);
            }
            _g2.setPaint(fillColor);
            for (int i = 0; i < this.numberOfTiles; ++i) {
                _g2.fillPolygon(this.a[i], this.b[i], this.corners[i].length);
            }
        }
        _g2.setColor(this.getRealStyle().getLineColor());
        for (int i = 0; i < this.numberOfTiles; ++i) {
            _g2.drawPolygon(this.a[i], this.b[i], this.corners[i].length);
        }
    }

    protected InteractionTarget getTargetHit(int x, int y) {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computeCorners();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        if (this.numberOfTiles < 1) {
            return null;
        }
        if (this.targetPosition.isEnabled() && Math.abs(this.pixelOrigin[0] - (double)x) < 5.0 && Math.abs(this.pixelOrigin[1] - (double)y) < 5.0) {
            return this.targetPosition;
        }
        return null;
    }

    protected abstract void computeCorners();

    protected void setCorners(double[][][] _data) {
        this.corners = _data;
        if (this.corners == null) {
            this.numberOfTiles = 0;
            this.a = null;
            this.b = null;
            return;
        }
        this.numberOfTiles = this.corners.length;
        this.a = new int[this.numberOfTiles][];
        this.b = new int[this.numberOfTiles][];
        this.objects = new Object3D[this.numberOfTiles];
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int sides = this.corners[i].length;
            this.a[i] = new int[sides];
            this.b[i] = new int[sides];
            this.objects[i] = new Object3D(this, i);
        }
    }

    protected void projectPoints() {
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int k;
            int sides = this.corners[i].length;
            for (k = 0; k < 3; ++k) {
                this.center[k] = 0.0;
            }
            for (int j = 0; j < sides; ++j) {
                this.getPanel().project(this.corners[i][j], this.pixel);
                this.a[i][j] = (int)this.pixel[0];
                this.b[i][j] = (int)this.pixel[1];
                for (int k2 = 0; k2 < 3; ++k2) {
                    int n = k2;
                    this.center[n] = this.center[n] + this.corners[i][j][k2];
                }
            }
            k = 0;
            while (k < 3) {
                int n = k++;
                this.center[n] = this.center[n] / (double)sides;
            }
            this.getPanel().project(this.center, this.pixel);
            this.objects[i].setDistance(this.pixel[2] * this.displacementFactor);
        }
        this.getPanel().project(this.getHotSpot(this.targetPosition), this.pixelOrigin);
        this.setNeedToProject(false);
    }

    private double levelScalarProduct(double[] point) {
        return (point[0] - this.levelx) * this.leveldx + (point[1] - this.levely) * this.leveldy + (point[2] - this.levelz) * this.leveldz;
    }

    private void drawColorCoded(Graphics2D _g2, int _index) {
        int k;
        double level;
        int j;
        int sides = this.corners[_index].length;
        int[] region = new int[sides];
        if (this.levelBelowWhenEqual) {
            block0: for (j = 0; j < sides; ++j) {
                region[j] = 0;
                level = this.levelScalarProduct(this.corners[_index][j]);
                for (k = this.levelZ.length - 1; k >= 0; --k) {
                    if (!(level > this.levelZ[k])) continue;
                    region[j] = k + 1;
                    continue block0;
                }
            }
        } else {
            block2: for (j = 0; j < sides; ++j) {
                region[j] = this.levelZ.length;
                level = this.levelScalarProduct(this.corners[_index][j]);
                int l = this.levelZ.length;
                for (k = 0; k < l; ++k) {
                    if (!(level < this.levelZ[k])) continue;
                    region[j] = k;
                    continue block2;
                }
            }
        }
        int[] newCornersA = new int[sides * 2];
        int[] newCornersB = new int[sides * 2];
        int l = this.levelZ.length;
        for (int k2 = 0; k2 <= l; ++k2) {
            int newCornersCounter = 0;
            for (int j2 = 0; j2 < sides; ++j2) {
                double t;
                int next = (j2 + 1) % sides;
                if (region[j2] <= k2 && region[next] >= k2) {
                    if (region[j2] == k2) {
                        newCornersA[newCornersCounter] = this.a[_index][j2];
                        newCornersB[newCornersCounter] = this.b[_index][j2];
                        ++newCornersCounter;
                    } else {
                        t = this.levelScalarProduct(this.corners[_index][j2]);
                        t = (this.levelZ[k2 - 1] - t) / (this.levelScalarProduct(this.corners[_index][next]) - t);
                        newCornersA[newCornersCounter] = (int)Math.round((double)this.a[_index][j2] + t * (double)(this.a[_index][next] - this.a[_index][j2]));
                        newCornersB[newCornersCounter] = (int)Math.round((double)this.b[_index][j2] + t * (double)(this.b[_index][next] - this.b[_index][j2]));
                        ++newCornersCounter;
                    }
                    if (region[next] <= k2) continue;
                    t = this.levelScalarProduct(this.corners[_index][j2]);
                    t = (this.levelZ[k2] - t) / (this.levelScalarProduct(this.corners[_index][next]) - t);
                    newCornersA[newCornersCounter] = (int)Math.round((double)this.a[_index][j2] + t * (double)(this.a[_index][next] - this.a[_index][j2]));
                    newCornersB[newCornersCounter] = (int)Math.round((double)this.b[_index][j2] + t * (double)(this.b[_index][next] - this.b[_index][j2]));
                    ++newCornersCounter;
                    continue;
                }
                if (region[j2] < k2 || region[next] > k2) continue;
                if (region[j2] == k2) {
                    newCornersA[newCornersCounter] = this.a[_index][j2];
                    newCornersB[newCornersCounter] = this.b[_index][j2];
                    ++newCornersCounter;
                } else {
                    t = this.levelScalarProduct(this.corners[_index][j2]);
                    t = (this.levelZ[k2] - t) / (this.levelScalarProduct(this.corners[_index][next]) - t);
                    newCornersA[newCornersCounter] = (int)Math.round((double)this.a[_index][j2] + t * (double)(this.a[_index][next] - this.a[_index][j2]));
                    newCornersB[newCornersCounter] = (int)Math.round((double)this.b[_index][j2] + t * (double)(this.b[_index][next] - this.b[_index][j2]));
                    ++newCornersCounter;
                }
                if (region[next] >= k2) continue;
                t = this.levelScalarProduct(this.corners[_index][j2]);
                t = (this.levelZ[k2 - 1] - t) / (this.levelScalarProduct(this.corners[_index][next]) - t);
                newCornersA[newCornersCounter] = (int)Math.round((double)this.a[_index][j2] + t * (double)(this.a[_index][next] - this.a[_index][j2]));
                newCornersB[newCornersCounter] = (int)Math.round((double)this.b[_index][j2] + t * (double)(this.b[_index][next] - this.b[_index][j2]));
                ++newCornersCounter;
            }
            if (newCornersCounter <= 0) continue;
            Color theFillColor = this.levelColors[k2];
            _g2.setPaint(theFillColor);
            _g2.fillPolygon(newCornersA, newCornersB, newCornersCounter);
        }
        _g2.setColor(this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.objects[_index].getDistance()));
        _g2.setStroke(this.getRealStyle().getLineStroke());
        _g2.drawPolygon(this.a[_index], this.b[_index], sides);
    }
}

