/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Camera;
import org.opensourcephysics.display3d.simple3d.DrawingPanel3D;
import org.opensourcephysics.numerics.Quaternion;
import org.opensourcephysics.numerics.Transformation;
import org.opensourcephysics.numerics.VectorMath;

public class Camera
implements org.opensourcephysics.display3d.core.Camera {
    private static final double ratioToScreen = 2.5;
    private static final double ratioToFocus = 2.0;
    private static final double[] vertical = new double[]{0.0, 0.0, 1.0};
    static final int CHANGE_ANY = 0;
    static final int CHANGE_MODE = 1;
    static final int CHANGE_POSITION = 2;
    static final int CHANGE_FOCUS = 3;
    static final int CHANGE_ROTATION = 4;
    static final int CHANGE_SCREEN = 5;
    static final int CHANGE_ANGLES = 6;
    private int projectionMode = 11;
    private double posX;
    private double posY;
    private double posZ;
    private double focusX;
    private double focusY;
    private double focusZ;
    private double distanceToScreen;
    private double rotationAngle = 0.0;
    private double alpha = 0.0;
    private double beta = 0.0;
    private double distanceToFocus;
    private double panelMaxSizeConstant;
    double cosAlpha = 1.0;
    double sinAlpha = 0.0;
    double cosBeta = 1.0;
    double sinBeta = 0.0;
    private double cosRot = 1.0;
    private double sinRot = 0.0;
    private double[] e1;
    private double[] e2;
    private double[] e3;
    private Projection projection = new Projection();
    private Quaternion rotation = new Quaternion(1.0, 0.0, 0.0, 0.0);
    private DrawingPanel3D panel;

    Camera(DrawingPanel3D aPanel) {
        this.panel = aPanel;
    }

    void setPanel(DrawingPanel3D aPanel) {
        this.panel = aPanel;
    }

    public void setProjectionMode(int mode) {
        this.projectionMode = mode;
        if (this.panel != null) {
            this.panelMaxSizeConstant = this.panel.getMaximum3DSize() * 0.01;
            this.panel.cameraChanged(1);
        }
    }

    public final int getProjectionMode() {
        return this.projectionMode;
    }

    public void reset() {
        double[] center = this.panel.getCenter();
        this.focusX = center[0];
        this.focusY = center[1];
        this.focusZ = center[2];
        this.panelMaxSizeConstant = this.panel.getMaximum3DSize();
        this.rotationAngle = 0.0;
        this.cosRot = 1.0;
        this.sinRot = 0.0;
        this.distanceToScreen = 2.5 * this.panelMaxSizeConstant;
        this.distanceToFocus = 2.0 * this.panelMaxSizeConstant;
        this.posX = center[0] + this.distanceToFocus;
        this.posY = center[1];
        this.posZ = center[2];
        this.alpha = 0.0;
        this.cosAlpha = 1.0;
        this.sinAlpha = 0.0;
        this.beta = 0.0;
        this.cosBeta = 1.0;
        this.sinBeta = 0.0;
        this.e1 = new double[]{-1.0, 0.0, 0.0};
        this.e2 = new double[]{0.0, 1.0, 0.0};
        this.e3 = new double[]{0.0, 0.0, 1.0};
        this.panelMaxSizeConstant *= 0.01;
        this.panel.cameraChanged(0);
    }

    public void setXYZ(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.updateCamera(2);
    }

    public void setXYZ(double[] point) {
        this.setXYZ(point[0], point[1], point[2]);
    }

    public final double getX() {
        return this.posX;
    }

    public final double getY() {
        return this.posY;
    }

    public final double getZ() {
        return this.posZ;
    }

    public void setFocusXYZ(double x, double y, double z) {
        this.focusX = x;
        this.focusY = y;
        this.focusZ = z;
        this.updateCamera(3);
    }

    public void setFocusXYZ(double[] point) {
        this.setFocusXYZ(point[0], point[1], point[2]);
    }

    public final double getFocusX() {
        return this.focusX;
    }

    public final double getFocusY() {
        return this.focusY;
    }

    public final double getFocusZ() {
        return this.focusZ;
    }

    public void setRotation(double angle) {
        this.rotationAngle = angle;
        this.cosRot = Math.cos(this.rotationAngle / 2.0);
        this.sinRot = Math.sin(this.rotationAngle / 2.0);
        this.updateCamera(4);
    }

    public final double getRotation() {
        return this.rotationAngle;
    }

    public void setDistanceToScreen(double distance) {
        this.distanceToScreen = distance;
        if (this.panel != null) {
            this.panel.cameraChanged(5);
        }
    }

    public final double getDistanceToScreen() {
        return this.distanceToScreen;
    }

    public void setAzimuth(double angle) {
        this.alpha = angle;
        this.cosAlpha = Math.cos(this.alpha);
        this.sinAlpha = Math.sin(this.alpha);
        this.updateCamera(6);
    }

    public final double getAzimuth() {
        return this.alpha;
    }

    public void setAltitude(double angle) {
        this.beta = angle;
        if (this.beta < -1.5707963267948966) {
            this.beta = -1.5707963267948966;
        } else if (this.beta > 1.5707963267948966) {
            this.beta = 1.5707963267948966;
        }
        this.cosBeta = Math.cos(this.beta);
        this.sinBeta = Math.sin(this.beta);
        this.updateCamera(6);
    }

    public final double getAltitude() {
        return this.beta;
    }

    public void setAzimuthAndAltitude(double azimuth, double altitude) {
        this.alpha = azimuth;
        this.beta = altitude;
        if (this.beta < -1.5707963267948966) {
            this.beta = -1.5707963267948966;
        } else if (this.beta > 1.5707963267948966) {
            this.beta = 1.5707963267948966;
        }
        this.cosAlpha = Math.cos(this.alpha);
        this.sinAlpha = Math.sin(this.alpha);
        this.cosBeta = Math.cos(this.beta);
        this.sinBeta = Math.sin(this.beta);
        this.updateCamera(6);
    }

    public final Transformation getTransformation() {
        return this.projection;
    }

    private void updateCamera(int change) {
        switch (change) {
            case 2: 
            case 3: {
                this.distanceToFocus = this.computeCameraVectors();
                this.alpha = Math.atan2(-this.e1[1], -this.e1[0]);
                this.beta = Math.atan2(-this.e1[2], Math.abs(this.e1[0]));
                this.cosAlpha = Math.cos(this.alpha);
                this.sinAlpha = Math.sin(this.alpha);
                this.cosBeta = Math.cos(this.beta);
                this.sinBeta = Math.sin(this.beta);
                break;
            }
            case 4: {
                this.computeCameraVectors();
                break;
            }
            case 6: {
                this.posX = this.focusX + this.distanceToFocus * this.cosBeta * this.cosAlpha;
                this.posY = this.focusY + this.distanceToFocus * this.cosBeta * this.sinAlpha;
                this.posZ = this.focusZ + this.distanceToFocus * this.sinBeta;
                this.computeCameraVectors();
            }
        }
        if (this.panel != null) {
            this.panel.cameraChanged(change);
        }
    }

    private double computeCameraVectors() {
        this.e1 = new double[]{this.focusX - this.posX, this.focusY - this.posY, this.focusZ - this.posZ};
        double magnitudeE1 = VectorMath.magnitude(this.e1);
        int i = 0;
        while (i < this.e1.length) {
            int n = i++;
            this.e1[n] = this.e1[n] / magnitudeE1;
        }
        this.e2 = VectorMath.cross3D(this.e1, vertical);
        double magnitude = VectorMath.magnitude(this.e2);
        int i2 = 0;
        while (i2 < this.e2.length) {
            int n = i2++;
            this.e2[n] = this.e2[n] / magnitude;
        }
        this.e3 = VectorMath.cross3D(this.e2, this.e1);
        magnitude = VectorMath.magnitude(this.e3);
        i2 = 0;
        while (i2 < this.e3.length) {
            int n = i2++;
            this.e3[n] = this.e3[n] / magnitude;
        }
        this.rotation.setCoordinates(this.cosRot, this.e1[0] * this.sinRot, this.e1[1] * this.sinRot, this.e1[2] * this.sinRot);
        this.rotation.direct(this.e2);
        this.rotation.direct(this.e3);
        return magnitudeE1;
    }

    boolean is3dMode() {
        switch (this.projectionMode) {
            case 0: 
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    double[] projectSize(double[] p, double[] size, double[] pixelSize) {
        switch (this.projectionMode) {
            case 0: {
                pixelSize[0] = size[0];
                pixelSize[1] = size[1];
                return pixelSize;
            }
            case 1: {
                pixelSize[0] = size[0];
                pixelSize[1] = size[2];
                return pixelSize;
            }
            case 2: {
                pixelSize[0] = size[1];
                pixelSize[1] = size[2];
                return pixelSize;
            }
            case 10: {
                pixelSize[0] = Math.max(size[0], size[1]);
                pixelSize[1] = size[2];
                return pixelSize;
            }
        }
        double factor = (p[0] - this.posX) * this.e1[0] + (p[1] - this.posY) * this.e1[1] + (p[2] - this.posZ) * this.e1[2];
        if (Math.abs(factor) < this.panelMaxSizeConstant) {
            factor = this.panelMaxSizeConstant;
        }
        factor = this.distanceToScreen / factor;
        pixelSize[0] = Math.max(size[0], size[1]) * factor;
        pixelSize[1] = size[2] * factor;
        return pixelSize;
    }

    public static XML.ObjectLoader getLoader() {
        return new CameraLoader();
    }

    protected static class CameraLoader
    extends Camera.Loader {
        protected CameraLoader() {
        }

        public Object createObject(XMLControl control) {
            return new Camera(null);
        }
    }

    private class Projection
    implements Transformation {
        private Projection() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException exc) {
                exc.printStackTrace();
                return null;
            }
        }

        public double[] direct(double[] p) {
            double factor;
            switch (Camera.this.projectionMode) {
                case 0: {
                    p[0] = p[0] - Camera.this.focusX;
                    p[1] = p[1] - Camera.this.focusY;
                    p[2] = 1.0 - (p[2] - Camera.this.focusZ) / Camera.this.distanceToFocus;
                    return p;
                }
                case 1: {
                    double aux = p[1];
                    p[0] = p[0] - Camera.this.focusX;
                    p[1] = p[2] - Camera.this.focusZ;
                    p[2] = 1.0 - (aux - Camera.this.focusY) / Camera.this.distanceToFocus;
                    return p;
                }
                case 2: {
                    double aux = p[0];
                    p[0] = p[1] - Camera.this.focusY;
                    p[1] = p[2] - Camera.this.focusZ;
                    p[2] = 1.0 - (aux - Camera.this.focusX) / Camera.this.distanceToFocus;
                    return p;
                }
                case 10: {
                    p[0] = p[0] - Camera.this.posX;
                    p[1] = p[1] - Camera.this.posY;
                    p[2] = p[2] - Camera.this.posZ;
                    double aux1 = VectorMath.dot(p, Camera.this.e1);
                    double aux2 = VectorMath.dot(p, Camera.this.e2);
                    p[1] = VectorMath.dot(p, Camera.this.e3);
                    p[0] = aux2;
                    p[2] = aux1 / Camera.this.distanceToFocus;
                    return p;
                }
            }
            p[0] = p[0] - Camera.this.posX;
            p[1] = p[1] - Camera.this.posY;
            p[2] = p[2] - Camera.this.posZ;
            double aux1 = factor = VectorMath.dot(p, Camera.this.e1);
            if (Math.abs(factor) < Camera.this.panelMaxSizeConstant) {
                factor = Camera.this.panelMaxSizeConstant;
            }
            factor = Camera.this.distanceToScreen / factor;
            double aux2 = VectorMath.dot(p, Camera.this.e2) * factor;
            p[1] = VectorMath.dot(p, Camera.this.e3) * factor;
            p[0] = aux2;
            p[2] = aux1 / Camera.this.distanceToFocus;
            return p;
        }

        public double[] inverse(double[] point) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

