/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.MouseController;
import org.opensourcephysics.display.OSPLayout;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display.TextPanel;
import org.opensourcephysics.display3d.core.DrawingPanel3D;
import org.opensourcephysics.display3d.core.interaction.InteractionEvent;
import org.opensourcephysics.display3d.core.interaction.InteractionListener;
import org.opensourcephysics.display3d.simple3d.Camera;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.ElementArrow;
import org.opensourcephysics.display3d.simple3d.ElementSegment;
import org.opensourcephysics.display3d.simple3d.ElementText;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;
import org.opensourcephysics.display3d.simple3d.Resolution;
import org.opensourcephysics.display3d.simple3d.VisualizationHints;

public class DrawingPanel3D
extends JPanel
implements Renderable,
org.opensourcephysics.display3d.core.DrawingPanel3D,
Printable,
ActionListener {
    private static final int AXIS_DIVISIONS = 10;
    private static final Color bgColor = new Color(239, 239, 255);
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double zmin;
    private double zmax;
    private VisualizationHints visHints = null;
    private Camera camera = null;
    private boolean quickRedrawOn = false;
    private boolean squareAspect = true;
    private double centerX;
    private double centerY;
    private double centerZ;
    private double maximumSize;
    private double aconstant;
    private double bconstant;
    private int acenter;
    private int bcenter;
    private ArrayList list3D = new ArrayList();
    private ArrayList decorationList = new ArrayList();
    private ArrayList elementList = new ArrayList();
    private Object3D.Comparator3D comparator = new Object3D.Comparator3D();
    private ElementArrow xAxis;
    private ElementArrow yAxis;
    private ElementArrow zAxis;
    private ElementText xText;
    private ElementText yText;
    private ElementText zText;
    private ElementSegment[] boxSides = new ElementSegment[12];
    private final InteractionTarget myTarget = new InteractionTarget(null, 0);
    private int trackersVisible;
    private int keyPressed = -1;
    private int lastX = 0;
    private int lastY = 0;
    private InteractionTarget targetHit = null;
    private InteractionTarget targetEntered = null;
    private double[] trackerPoint = null;
    private ArrayList listeners = new ArrayList();
    private ElementSegment[] trackerLines = null;
    private volatile boolean dirtyImage = true;
    private volatile BufferedImage offscreenImage;
    private BufferedImage workingImage = this.offscreenImage = new BufferedImage(1, 1, 1);
    private Timer updateTimer = new Timer(100, this);
    private boolean needResize = true;
    private boolean needsToRecompute = true;
    protected TextPanel trMessageBox = new TextPanel();
    protected TextPanel tlMessageBox = new TextPanel();
    protected TextPanel brMessageBox = new TextPanel();
    protected TextPanel blMessageBox = new TextPanel();
    protected GlassPanel glassPanel = new GlassPanel();
    protected OSPLayout glassPanelLayout = new OSPLayout();
    protected Rectangle viewRect = null;

    public DrawingPanel3D() {
        int i;
        this.glassPanel.setLayout(this.glassPanelLayout);
        super.setLayout(new BorderLayout());
        this.glassPanel.add((Component)this.trMessageBox, "TopRightCorner");
        this.glassPanel.add((Component)this.tlMessageBox, "TopLeftCorner");
        this.glassPanel.add((Component)this.brMessageBox, "BottomRightCorner");
        this.glassPanel.add((Component)this.blMessageBox, "BottomLeftCorner");
        this.glassPanel.setOpaque(false);
        super.add((Component)this.glassPanel, "Center");
        this.setBackground(bgColor);
        this.setPreferredSize(new Dimension(300, 300));
        this.visHints = new VisualizationHints(this);
        this.camera = new Camera(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                DrawingPanel3D.this.needResize = true;
                DrawingPanel3D.this.dirtyImage = true;
            }
        });
        IADMouseController mouseController = new IADMouseController();
        this.addMouseListener(mouseController);
        this.addMouseMotionListener(mouseController);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent _e) {
                DrawingPanel3D.this.keyPressed = _e.getKeyCode();
            }

            public void keyReleased(KeyEvent _e) {
                DrawingPanel3D.this.keyPressed = -1;
            }
        });
        this.setFocusable(true);
        Resolution axesRes = new Resolution(10, 1, 1);
        int n = this.boxSides.length;
        for (i = 0; i < n; ++i) {
            this.boxSides[i] = new ElementSegment();
            this.boxSides[i].getRealStyle().setResolution(axesRes);
            this.boxSides[i].setPanel(this);
            this.decorationList.add(this.boxSides[i]);
        }
        this.boxSides[0].getStyle().setLineColor(new Color(128, 0, 0));
        this.boxSides[3].getStyle().setLineColor(new Color(0, 128, 0));
        this.boxSides[8].getStyle().setLineColor(new Color(0, 0, 255));
        this.xAxis = new ElementArrow();
        this.xAxis.getRealStyle().setResolution(axesRes);
        this.xAxis.getStyle().setFillColor(new Color(128, 0, 0));
        this.xAxis.setPanel(this);
        this.decorationList.add(this.xAxis);
        this.xText = new ElementText();
        this.xText.setText("X");
        this.xText.setJustification(0);
        this.xText.getRealStyle().setLineColor(Color.BLACK);
        this.xText.setFont(new Font("Dialog", 0, 12));
        this.xText.setPanel(this);
        this.decorationList.add(this.xText);
        this.yAxis = new ElementArrow();
        this.yAxis.getRealStyle().setResolution(axesRes);
        this.yAxis.getStyle().setFillColor(new Color(0, 128, 0));
        this.yAxis.setPanel(this);
        this.decorationList.add(this.yAxis);
        this.yText = new ElementText();
        this.yText.setText("Y");
        this.yText.setJustification(0);
        this.yText.getRealStyle().setLineColor(Color.BLACK);
        this.yText.setFont(new Font("Dialog", 0, 12));
        this.yText.setPanel(this);
        this.decorationList.add(this.yText);
        this.zAxis = new ElementArrow();
        this.zAxis.getRealStyle().setResolution(axesRes);
        this.zAxis.getStyle().setFillColor(new Color(0, 0, 255));
        this.zAxis.setPanel(this);
        this.decorationList.add(this.zAxis);
        this.zText = new ElementText();
        this.zText.setText("Z");
        this.zText.setJustification(0);
        this.zText.getRealStyle().setLineColor(Color.BLACK);
        this.zText.setFont(new Font("Dialog", 0, 12));
        this.zText.setPanel(this);
        this.decorationList.add(this.zText);
        this.trackerLines = new ElementSegment[9];
        n = this.trackerLines.length;
        for (i = 0; i < n; ++i) {
            this.trackerLines[i] = new ElementSegment();
            this.trackerLines[i].getRealStyle().setResolution(axesRes);
            this.trackerLines[i].setVisible(false);
            this.trackerLines[i].setPanel(this);
            this.decorationList.add(this.trackerLines[i]);
        }
        this.setCursorMode();
        if (this.camera.is3dMode()) {
            this.visHints.setDecorationType(2);
            this.visHints.setUseColorDepth(true);
        } else {
            this.visHints.setDecorationType(0);
            this.visHints.setUseColorDepth(false);
        }
        this.setPreferredMinMax(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.dirtyImage || this.needsUpdate()) {
            this.render();
        }
    }

    public void setIgnoreRepaint(boolean ignoreRepaint) {
        super.setIgnoreRepaint(ignoreRepaint);
        this.glassPanel.setIgnoreRepaint(ignoreRepaint);
    }

    private void updatePanel() {
        if (this.getIgnoreRepaint()) {
            return;
        }
        this.updateTimer.setRepeats(false);
        this.updateTimer.setCoalesce(true);
        this.updateTimer.start();
    }

    public void paintComponent(Graphics g) {
        this.viewRect = null;
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JViewport)) continue;
            this.viewRect = ((JViewport)c).getViewRect();
            this.glassPanel.setBounds(this.viewRect);
            this.glassPanelLayout.checkLayoutRect(this.glassPanel, this.viewRect);
            break;
        }
        int xoff = (this.getWidth() - this.offscreenImage.getWidth()) / 2;
        int yoff = (this.getHeight() - this.offscreenImage.getHeight()) / 2;
        g.drawImage(this.offscreenImage, xoff, yoff, null);
        if (this.dirtyImage || this.needsUpdate()) {
            this.updatePanel();
        }
    }

    public Image render(Image image) {
        Graphics g = image.getGraphics();
        this.paintEverything(g, image.getWidth(null), image.getHeight(null));
        Rectangle viewRect = this.viewRect;
        if (viewRect != null) {
            Rectangle r = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
            this.glassPanel.setBounds(r);
            this.glassPanelLayout.checkLayoutRect(this.glassPanel, r);
            this.glassPanel.render(g);
            this.glassPanel.setBounds(viewRect);
            this.glassPanelLayout.checkLayoutRect(this.glassPanel, viewRect);
        } else {
            this.glassPanel.render(g);
        }
        g.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage render() {
        BufferedImage workingImage;
        if (!this.isShowing() || this.isIconified()) {
            this.needsToRecompute = true;
            return null;
        }
        BufferedImage bufferedImage = workingImage = this.checkImageSize(this.workingImage);
        synchronized (bufferedImage) {
            if (this.needResize) {
                this.computeConstants(workingImage.getWidth(), workingImage.getHeight());
                this.needResize = false;
            }
            this.render(workingImage);
            this.workingImage = this.offscreenImage;
            this.offscreenImage = workingImage;
            this.dirtyImage = false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.paintImmediately(this.getVisibleRect());
        } else {
            Runnable doNow = new Runnable(){

                public void run() {
                    DrawingPanel3D.this.paintImmediately(DrawingPanel3D.this.getVisibleRect());
                }
            };
            try {
                SwingUtilities.invokeAndWait(doNow);
            }
            catch (InvocationTargetException ex) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return workingImage;
    }

    private final boolean needsUpdate() {
        Iterator it = ((AbstractList)this.elementList).iterator();
        while (it.hasNext()) {
            if (!((Element)it.next()).getElementChanged()) continue;
            return true;
        }
        return false;
    }

    private BufferedImage checkImageSize(BufferedImage image) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 2 || height <= 2) {
            return new BufferedImage(1, 1, 1);
        }
        if (image == null || width != image.getWidth() || height != image.getHeight()) {
            return this.getGraphicsConfiguration().createCompatibleImage(width, height);
        }
        return image;
    }

    private boolean isIconified() {
        Container c = this.getTopLevelAncestor();
        if (c instanceof Frame) {
            return (((Frame)c).getExtendedState() & 1) == 1;
        }
        return false;
    }

    public Component getComponent() {
        return this;
    }

    public void setPreferredMinMax(double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        this.xmin = minX;
        this.xmax = maxX;
        this.ymin = minY;
        this.ymax = maxY;
        this.zmin = minZ;
        this.zmax = maxZ;
        this.centerX = (this.xmax + this.xmin) / 2.0;
        this.centerY = (this.ymax + this.ymin) / 2.0;
        this.centerZ = (this.zmax + this.zmin) / 2.0;
        this.maximumSize = this.getMaximum3DSize();
        this.resetDecoration(this.xmax - this.xmin, this.ymax - this.ymin, this.zmax - this.zmin);
        this.camera.reset();
        this.needsToRecompute = true;
        this.dirtyImage = true;
    }

    public final double getPreferredMinX() {
        return this.xmin;
    }

    public final double getPreferredMaxX() {
        return this.xmax;
    }

    public final double getPreferredMinY() {
        return this.ymin;
    }

    public final double getPreferredMaxY() {
        return this.ymax;
    }

    public final double getPreferredMinZ() {
        return this.zmin;
    }

    public final double getPreferredMaxZ() {
        return this.zmax;
    }

    final double[] getCenter() {
        return new double[]{this.centerX, this.centerY, this.centerZ};
    }

    final double getMaximum3DSize() {
        double dx = this.xmax - this.xmin;
        double dy = this.ymax - this.ymin;
        double dz = this.zmax - this.zmin;
        switch (this.camera.getProjectionMode()) {
            case 0: {
                return Math.max(dx, dy);
            }
            case 1: {
                return Math.max(dx, dz);
            }
            case 2: {
                return Math.max(dy, dz);
            }
        }
        return Math.max(Math.max(dx, dy), dz);
    }

    public void zoomToFit() {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double[] firstPoint = new double[3];
        double[] secondPoint = new double[3];
        Iterator it = ((AbstractList)this.getElements()).iterator();
        while (it.hasNext()) {
            ((Element)it.next()).getExtrema(firstPoint, secondPoint);
            minX = Math.min(Math.min(minX, firstPoint[0]), secondPoint[0]);
            maxX = Math.max(Math.max(maxX, firstPoint[0]), secondPoint[0]);
            minY = Math.min(Math.min(minY, firstPoint[1]), secondPoint[1]);
            maxY = Math.max(Math.max(maxY, firstPoint[1]), secondPoint[1]);
            minZ = Math.min(Math.min(minZ, firstPoint[2]), secondPoint[2]);
            maxZ = Math.max(Math.max(maxZ, firstPoint[2]), secondPoint[2]);
        }
        double max = Math.max(Math.max(maxX - minX, maxY - minY), maxZ - minZ);
        if (max == 0.0) {
            max = 2.0;
        }
        if (minX >= maxX) {
            minX = maxX - max / 2.0;
            maxX = minX + max;
        }
        if (minY >= maxY) {
            minY = maxY - max / 2.0;
            maxY = minY + max;
        }
        if (minZ >= maxZ) {
            minZ = maxZ - max / 2.0;
            maxZ = minZ + max;
        }
        this.setPreferredMinMax(minX, maxX, minY, maxY, minZ, maxZ);
    }

    public void setSquareAspect(boolean square) {
        if (this.squareAspect != square) {
            this.needsToRecompute = true;
            this.updatePanel();
        }
        this.squareAspect = square;
    }

    public boolean isSquareAspect() {
        return this.squareAspect;
    }

    public org.opensourcephysics.display3d.core.VisualizationHints getVisualizationHints() {
        return this.visHints;
    }

    public org.opensourcephysics.display3d.core.Camera getCamera() {
        return this.camera;
    }

    public void addElement(org.opensourcephysics.display3d.core.Element element) {
        if (!(element instanceof Element)) {
            throw new UnsupportedOperationException("Can't add element to panel (incorrect implementation)");
        }
        if (!this.elementList.contains(element)) {
            this.elementList.add(element);
        }
        ((Element)element).setPanel(this);
        this.dirtyImage = true;
    }

    public void removeElement(org.opensourcephysics.display3d.core.Element element) {
        ((AbstractCollection)this.elementList).remove(element);
        this.dirtyImage = true;
    }

    public void removeAllElements() {
        this.elementList.clear();
        this.dirtyImage = true;
    }

    public synchronized ArrayList getElements() {
        return (ArrayList)this.elementList.clone();
    }

    public void setMessage(String msg) {
        this.brMessageBox.setText(msg);
    }

    public void setMessage(String msg, int location) {
        switch (location) {
            case 0: {
                this.blMessageBox.setText(msg);
                break;
            }
            default: {
                this.brMessageBox.setText(msg);
                break;
            }
            case 2: {
                this.trMessageBox.setText(msg);
                break;
            }
            case 3: {
                this.tlMessageBox.setText(msg);
            }
        }
    }

    public org.opensourcephysics.display3d.core.interaction.InteractionTarget getInteractionTarget(int target) {
        return this.myTarget;
    }

    public void addInteractionListener(InteractionListener listener) {
        if (listener == null || this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeInteractionListener(InteractionListener listener) {
        ((AbstractCollection)this.listeners).remove(listener);
    }

    private void invokeActions(InteractionEvent event) {
        Iterator it = ((AbstractList)this.listeners).iterator();
        while (it.hasNext()) {
            ((InteractionListener)it.next()).interactionPerformed(event);
        }
    }

    private synchronized void paintEverything(Graphics g, int width, int height) {
        if (this.needsToRecompute || width != this.getWidth() || height != this.getHeight()) {
            this.computeConstants(width, height);
        }
        ArrayList tempList = this.getElements();
        tempList.addAll(this.decorationList);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        this.paintDrawableList(g, tempList);
    }

    private void paintDrawableList(Graphics g, ArrayList tempList) {
        int i;
        int n;
        Object[] objects;
        Graphics2D g2 = (Graphics2D)g;
        Iterator it = ((AbstractList)tempList).iterator();
        if (this.quickRedrawOn || !this.visHints.isRemoveHiddenLines()) {
            while (it.hasNext()) {
                ((Element)it.next()).drawQuickly(g2);
            }
            return;
        }
        this.list3D.clear();
        while (it.hasNext()) {
            objects = ((Element)it.next()).getObjects3D();
            if (objects == null) continue;
            n = objects.length;
            for (i = 0; i < n; ++i) {
                if (Double.isNaN(((Object3D)objects[i]).getDistance())) continue;
                this.list3D.add(objects[i]);
            }
        }
        if (this.list3D.size() <= 0) {
            return;
        }
        objects = this.list3D.toArray();
        Arrays.sort(objects, this.comparator);
        n = objects.length;
        for (i = 0; i < n; ++i) {
            Object3D obj = (Object3D)objects[i];
            obj.getElement().draw(g2, obj.getIndex());
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= 1) {
            return 1;
        }
        if (g == null) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double scalex = pageFormat.getImageableWidth() / (double)this.getWidth();
        double scaley = pageFormat.getImageableHeight() / (double)this.getHeight();
        double scale = Math.min(scalex, scaley);
        g2.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        g2.scale(scale, scale);
        this.paintEverything(g2, this.getWidth(), this.getHeight());
        return 0;
    }

    void hintChanged(int hintThatChanged) {
        switch (hintThatChanged) {
            case 0: {
                switch (this.visHints.getDecorationType()) {
                    case 0: {
                        int n = this.boxSides.length;
                        for (int i = 0; i < n; ++i) {
                            this.boxSides[i].setVisible(false);
                        }
                        this.xAxis.setVisible(false);
                        this.yAxis.setVisible(false);
                        this.zAxis.setVisible(false);
                        this.xText.setVisible(false);
                        this.yText.setVisible(false);
                        this.zText.setVisible(false);
                        break;
                    }
                    case 2: {
                        int n = this.boxSides.length;
                        for (int i = 0; i < n; ++i) {
                            this.boxSides[i].setVisible(true);
                        }
                        this.xAxis.setVisible(false);
                        this.yAxis.setVisible(false);
                        this.zAxis.setVisible(false);
                        this.xText.setVisible(false);
                        this.yText.setVisible(false);
                        this.zText.setVisible(false);
                        break;
                    }
                    case 1: {
                        int n = this.boxSides.length;
                        for (int i = 0; i < n; ++i) {
                            this.boxSides[i].setVisible(false);
                        }
                        this.xAxis.setVisible(true);
                        this.yAxis.setVisible(true);
                        this.zAxis.setVisible(true);
                        this.xText.setVisible(true);
                        this.yText.setVisible(true);
                        this.zText.setVisible(true);
                    }
                }
                break;
            }
            case 4: {
                this.setCursorMode();
                break;
            }
        }
        this.dirtyImage = true;
    }

    void cameraChanged(int howItChanged) {
        switch (howItChanged) {
            case 1: {
                double dx = this.xmax - this.xmin;
                double dy = this.ymax - this.ymin;
                double dz = this.zmax - this.zmin;
                this.maximumSize = this.getMaximum3DSize();
                this.resetDecoration(dx, dy, dz);
                this.needsToRecompute = true;
                this.updatePanel();
            }
        }
        this.reportTheNeedToProject();
        this.dirtyImage = true;
    }

    double[] project(double[] p, double[] pixel) {
        double[] projected = this.camera.getTransformation().direct((double[])p.clone());
        double factor = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 10: {
                factor = 1.3;
            }
            case 11: {
                factor = 1.0;
            }
        }
        pixel[0] = (double)this.acenter + projected[0] * factor * this.aconstant;
        pixel[1] = (double)this.bcenter - projected[1] * factor * this.bconstant;
        pixel[2] = projected[2];
        return pixel;
    }

    double[] projectSize(double[] p, double[] size, double[] pixelSize) {
        this.camera.projectSize(p, size, pixelSize);
        double factor = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 10: {
                factor = 1.3;
            }
            case 11: {
                factor = 1.0;
            }
        }
        pixelSize[0] = pixelSize[0] * (factor * this.aconstant);
        pixelSize[1] = pixelSize[1] * (factor * this.bconstant);
        return pixelSize;
    }

    Color projectColor(Color _aColor, double _depth) {
        if (!this.visHints.isUseColorDepth()) {
            return _aColor;
        }
        float[] crc = new float[4];
        try {
            _aColor.getRGBComponents(crc);
            for (int i = 0; i < 3; ++i) {
                int n = i;
                crc[n] = (float)((double)crc[n] / _depth);
                crc[i] = (float)Math.max(Math.min((double)crc[i], 1.0), 0.0);
            }
            return new Color(crc[0], crc[1], crc[2], crc[3]);
        }
        catch (Exception _exc) {
            return _aColor;
        }
    }

    private double[] worldPoint(int a, int b) {
        double factor = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 0: {
                return new double[]{this.centerX + (double)(a - this.acenter) / (factor * this.aconstant), this.centerY + (double)(this.bcenter - b) / (factor * this.bconstant), this.zmax};
            }
            case 1: {
                return new double[]{this.centerX + (double)(a - this.acenter) / (factor * this.aconstant), this.ymax, this.centerZ + (double)(this.bcenter - b) / (factor * this.bconstant)};
            }
            case 2: {
                return new double[]{this.xmax, this.centerY + (double)(a - this.acenter) / (factor * this.aconstant), this.centerZ + (double)(this.bcenter - b) / (factor * this.bconstant)};
            }
        }
        return new double[]{this.centerX, this.centerY, this.centerZ};
    }

    private double[] worldDistance(int dx, int dy) {
        double factor = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 0: {
                return new double[]{(double)dx / (factor * this.aconstant), (double)(-dy) / (factor * this.bconstant), 0.0};
            }
            case 1: {
                return new double[]{(double)dx / (factor * this.aconstant), 0.0, (double)(-dy) / (factor * this.bconstant)};
            }
            case 2: {
                return new double[]{0.0, (double)dx / (factor * this.aconstant), (double)(-dy) / (factor * this.bconstant)};
            }
        }
        return new double[]{(double)dx / (1.3 * this.aconstant), (double)dy / (1.3 * this.bconstant), 0.0};
    }

    private void computeConstants(int width, int height) {
        this.acenter = width / 2;
        this.bcenter = height / 2;
        if (this.squareAspect) {
            width = height = Math.min(width, height);
        }
        this.aconstant = 0.5 * (double)width / this.maximumSize;
        this.bconstant = 0.5 * (double)height / this.maximumSize;
        this.reportTheNeedToProject();
        this.needsToRecompute = false;
    }

    private void reportTheNeedToProject() {
        Iterator it = ((AbstractList)this.getElements()).iterator();
        while (it.hasNext()) {
            ((Element)it.next()).setNeedToProject(true);
        }
        it = ((AbstractList)((ArrayList)this.decorationList.clone())).iterator();
        while (it.hasNext()) {
            ((Element)it.next()).setNeedToProject(true);
        }
    }

    private void resetDecoration(double _dx, double _dy, double _dz) {
        this.boxSides[0].setXYZ(this.xmin, this.ymin, this.zmin);
        this.boxSides[0].setSizeXYZ(_dx, 0.0, 0.0);
        this.boxSides[1].setXYZ(this.xmax, this.ymin, this.zmin);
        this.boxSides[1].setSizeXYZ(0.0, _dy, 0.0);
        this.boxSides[2].setXYZ(this.xmin, this.ymax, this.zmin);
        this.boxSides[2].setSizeXYZ(_dx, 0.0, 0.0);
        this.boxSides[3].setXYZ(this.xmin, this.ymin, this.zmin);
        this.boxSides[3].setSizeXYZ(0.0, _dy, 0.0);
        this.boxSides[4].setXYZ(this.xmin, this.ymin, this.zmax);
        this.boxSides[4].setSizeXYZ(_dx, 0.0, 0.0);
        this.boxSides[5].setXYZ(this.xmax, this.ymin, this.zmax);
        this.boxSides[5].setSizeXYZ(0.0, _dy, 0.0);
        this.boxSides[6].setXYZ(this.xmin, this.ymax, this.zmax);
        this.boxSides[6].setSizeXYZ(_dx, 0.0, 0.0);
        this.boxSides[7].setXYZ(this.xmin, this.ymin, this.zmax);
        this.boxSides[7].setSizeXYZ(0.0, _dy, 0.0);
        this.boxSides[8].setXYZ(this.xmin, this.ymin, this.zmin);
        this.boxSides[8].setSizeXYZ(0.0, 0.0, _dz);
        this.boxSides[9].setXYZ(this.xmax, this.ymin, this.zmin);
        this.boxSides[9].setSizeXYZ(0.0, 0.0, _dz);
        this.boxSides[10].setXYZ(this.xmax, this.ymax, this.zmin);
        this.boxSides[10].setSizeXYZ(0.0, 0.0, _dz);
        this.boxSides[11].setXYZ(this.xmin, this.ymax, this.zmin);
        this.boxSides[11].setSizeXYZ(0.0, 0.0, _dz);
        this.xAxis.setXYZ(this.xmin, this.ymin, this.zmin);
        this.xAxis.setSizeXYZ(_dx, 0.0, 0.0);
        this.xText.setXYZ(this.xmax + _dx * 0.02, this.ymin, this.zmin);
        this.yAxis.setXYZ(this.xmin, this.ymin, this.zmin);
        this.yAxis.setSizeXYZ(0.0, _dy, 0.0);
        this.yText.setXYZ(this.xmin, this.ymax + _dy * 0.02, this.zmin);
        this.zAxis.setXYZ(this.xmin, this.ymin, this.zmin);
        this.zAxis.setSizeXYZ(0.0, 0.0, _dz);
        this.zText.setXYZ(this.xmin, this.ymin, this.zmax + _dz * 0.02);
    }

    private void setCursorMode() {
        switch (this.visHints.getCursorType()) {
            case 0: {
                this.trackersVisible = 0;
                break;
            }
            case 2: {
                this.trackersVisible = 9;
                break;
            }
            default: {
                this.trackersVisible = 3;
                break;
            }
            case 3: {
                this.trackersVisible = 3;
            }
        }
    }

    private void showTrackers(boolean value) {
        int n = this.trackerLines.length;
        for (int i = 0; i < n; ++i) {
            if (i < this.trackersVisible) {
                this.trackerLines[i].setVisible(value);
                continue;
            }
            this.trackerLines[i].setVisible(false);
        }
    }

    private void positionTrackers() {
        switch (this.visHints.getCursorType()) {
            case 0: {
                return;
            }
            default: {
                this.trackerLines[0].setXYZ(this.trackerPoint[0], this.ymin, this.zmin);
                this.trackerLines[0].setSizeXYZ(0.0, this.trackerPoint[1] - this.ymin, 0.0);
                this.trackerLines[1].setXYZ(this.xmin, this.trackerPoint[1], this.zmin);
                this.trackerLines[1].setSizeXYZ(this.trackerPoint[0] - this.xmin, 0.0, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint[0], this.trackerPoint[1], this.zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - this.zmin);
                break;
            }
            case 2: {
                this.trackerLines[0].setXYZ(this.xmin, this.trackerPoint[1], this.trackerPoint[2]);
                this.trackerLines[0].setSizeXYZ(this.trackerPoint[0] - this.xmin, 0.0, 0.0);
                this.trackerLines[1].setXYZ(this.trackerPoint[0], this.ymin, this.trackerPoint[2]);
                this.trackerLines[1].setSizeXYZ(0.0, this.trackerPoint[1] - this.ymin, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint[0], this.trackerPoint[1], this.zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - this.zmin);
                this.trackerLines[3].setXYZ(this.trackerPoint[0], this.ymin, this.zmin);
                this.trackerLines[3].setSizeXYZ(0.0, this.trackerPoint[1] - this.ymin, 0.0);
                this.trackerLines[4].setXYZ(this.xmin, this.trackerPoint[1], this.zmin);
                this.trackerLines[4].setSizeXYZ(this.trackerPoint[0] - this.xmin, 0.0, 0.0);
                this.trackerLines[5].setXYZ(this.trackerPoint[0], this.ymin, this.zmin);
                this.trackerLines[5].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - this.zmin);
                this.trackerLines[6].setXYZ(this.xmin, this.ymin, this.trackerPoint[2]);
                this.trackerLines[6].setSizeXYZ(this.trackerPoint[0] - this.xmin, 0.0, 0.0);
                this.trackerLines[7].setXYZ(this.xmin, this.trackerPoint[1], this.zmin);
                this.trackerLines[7].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - this.zmin);
                this.trackerLines[8].setXYZ(this.xmin, this.ymin, this.trackerPoint[2]);
                this.trackerLines[8].setSizeXYZ(0.0, this.trackerPoint[1] - this.ymin, 0.0);
                break;
            }
            case 3: {
                this.trackerLines[0].setXYZ(this.xmin, this.trackerPoint[1], this.trackerPoint[2]);
                this.trackerLines[0].setSizeXYZ(this.xmax - this.xmin, 0.0, 0.0);
                this.trackerLines[1].setXYZ(this.trackerPoint[0], this.ymin, this.trackerPoint[2]);
                this.trackerLines[1].setSizeXYZ(0.0, this.ymax - this.ymin, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint[0], this.trackerPoint[1], this.zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.zmax - this.zmin);
            }
        }
    }

    private InteractionTarget getTargetHit(int x, int y) {
        Iterator it = ((AbstractList)this.getElements()).iterator();
        InteractionTarget target = null;
        while (it.hasNext()) {
            target = ((Element)it.next()).getTargetHit(x, y);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    private void setMouseCursor(Cursor cursor) {
        Container c = this.getTopLevelAncestor();
        this.setCursor(cursor);
        if (c != null) {
            c.setCursor(cursor);
        }
    }

    private void displayPosition(double[] _point) {
        this.visHints.displayPosition(this.camera.getProjectionMode(), _point);
    }

    private boolean mouseDraggedComputations(MouseEvent e) {
        if (e.isControlDown()) {
            if (this.camera.is3dMode()) {
                double fx = this.camera.getFocusX();
                double fy = this.camera.getFocusY();
                double fz = this.camera.getFocusZ();
                double dx = (double)(e.getX() - this.lastX) * this.maximumSize * 0.01;
                double dy = (double)(e.getY() - this.lastY) * this.maximumSize * 0.01;
                switch (this.keyPressed) {
                    case 88: {
                        if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(fx + dy, fy, fz);
                            break;
                        }
                        if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                            this.camera.setFocusXYZ(fx + dx, fy, fz);
                            break;
                        }
                        if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(fx - dy, fy, fz);
                            break;
                        }
                        this.camera.setFocusXYZ(fx - dx, fy, fz);
                        break;
                    }
                    case 89: {
                        if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(fx, fy - dx, fz);
                            break;
                        }
                        if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                            this.camera.setFocusXYZ(fx, fy + dy, fz);
                            break;
                        }
                        if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(fx, fy + dx, fz);
                            break;
                        }
                        this.camera.setFocusXYZ(fx, fy - dy, fz);
                        break;
                    }
                    case 90: {
                        if (this.camera.cosBeta >= 0.0) {
                            this.camera.setFocusXYZ(fx, fy, fz + dy);
                            break;
                        }
                        this.camera.setFocusXYZ(fx, fy, fz - dy);
                        break;
                    }
                    default: {
                        if (this.camera.cosBeta < 0.0) {
                            dy = -dy;
                        }
                        if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(fx, fy - dx, fz + dy);
                            break;
                        }
                        if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                            this.camera.setFocusXYZ(fx + dx, fy, fz + dy);
                            break;
                        }
                        if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(fx, fy + dx, fz - dy);
                            break;
                        }
                        this.camera.setFocusXYZ(fx - dx, fy, fz - dy);
                    }
                }
            }
            return false;
        }
        if (e.isShiftDown()) {
            this.camera.setDistanceToScreen(this.camera.getDistanceToScreen() - (double)(e.getY() - this.lastY) * this.maximumSize * 0.01);
            return false;
        }
        if (this.camera.is3dMode() && this.targetHit == null && !e.isAltDown()) {
            this.camera.setAzimuthAndAltitude(this.camera.getAzimuth() - (double)(e.getX() - this.lastX) * 0.01, this.camera.getAltitude() + (double)(e.getY() - this.lastY) * 0.005);
            return false;
        }
        if (this.trackerPoint == null) {
            return true;
        }
        double[] point = this.worldDistance(e.getX() - this.lastX, e.getY() - this.lastY);
        if (!this.camera.is3dMode()) {
            switch (this.keyPressed) {
                case 88: {
                    this.trackerPoint[0] = this.trackerPoint[0] + point[0];
                    break;
                }
                case 89: {
                    this.trackerPoint[1] = this.trackerPoint[1] + point[1];
                    break;
                }
                case 90: {
                    this.trackerPoint[2] = this.trackerPoint[2] + point[2];
                    break;
                }
                default: {
                    this.trackerPoint[0] = this.trackerPoint[0] + point[0];
                    this.trackerPoint[1] = this.trackerPoint[1] + point[1];
                    this.trackerPoint[2] = this.trackerPoint[2] + point[2];
                    break;
                }
            }
        } else {
            switch (this.keyPressed) {
                case 88: {
                    if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] + point[1];
                        break;
                    }
                    if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] - point[0];
                        break;
                    }
                    if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] - point[1];
                        break;
                    }
                    this.trackerPoint[0] = this.trackerPoint[0] + point[0];
                    break;
                }
                case 89: {
                    if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] + point[0];
                        break;
                    }
                    if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] + point[1];
                        break;
                    }
                    if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] - point[0];
                        break;
                    }
                    this.trackerPoint[1] = this.trackerPoint[1] - point[1];
                    break;
                }
                case 90: {
                    if (this.camera.cosBeta >= 0.0) {
                        this.trackerPoint[2] = this.trackerPoint[2] - point[1];
                        break;
                    }
                    this.trackerPoint[2] = this.trackerPoint[2] - point[2];
                    break;
                }
                default: {
                    this.trackerPoint[2] = this.camera.cosBeta >= 0.0 ? this.trackerPoint[2] - point[1] : this.trackerPoint[2] + point[1];
                    if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] + point[0];
                        break;
                    }
                    if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] - point[0];
                        break;
                    }
                    if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] - point[0];
                        break;
                    }
                    this.trackerPoint[0] = this.trackerPoint[0] + point[0];
                }
            }
        }
        return true;
    }

    private void resetInteraction() {
        this.targetHit = null;
        this.showTrackers(false);
        this.displayPosition(null);
        this.dirtyImage = true;
        this.updatePanel();
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawingPanel3DLoader();
    }

    static /* synthetic */ double[] access$1102(DrawingPanel3D x0, double[] x1) {
        x0.trackerPoint = x1;
        return x1;
    }

    private static class DrawingPanel3DLoader
    extends DrawingPanel3D.Loader {
        private DrawingPanel3DLoader() {
        }

        public Object createObject(XMLControl control) {
            return new DrawingPanel3D();
        }

        public Object loadObject(XMLControl control, Object obj) {
            super.loadObject(control, obj);
            DrawingPanel3D panel = (DrawingPanel3D)obj;
            VisualizationHints hints = (VisualizationHints)control.getObject("visualization hints");
            hints.setPanel(panel);
            panel.visHints = hints;
            panel.hintChanged(0);
            Camera cam = (Camera)control.getObject("camera");
            cam.setPanel(panel);
            panel.camera = cam;
            panel.cameraChanged(0);
            panel.needsToRecompute = true;
            panel.dirtyImage = true;
            panel.updatePanel();
            return obj;
        }
    }

    private class GlassPanel
    extends JPanel {
        private GlassPanel() {
        }

        public void render(Graphics g) {
            Component[] c = DrawingPanel3D.this.glassPanelLayout.getComponents();
            int n = c.length;
            for (int i = 0; i < n; ++i) {
                if (c[i] == null) continue;
                g.translate(c[i].getX(), c[i].getY());
                c[i].print(g);
                g.translate(-c[i].getX(), -c[i].getY());
            }
        }
    }

    private class IADMouseController
    extends MouseController {
        private IADMouseController() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void mousePressed(MouseEvent _evt) {
            DrawingPanel3D.this.requestFocus();
            if (DrawingPanel3D.this.visHints.isAllowQuickRedraw() && (_evt.getModifiers() & 0x10) != 0) {
                DrawingPanel3D.this.quickRedrawOn = true;
            } else {
                DrawingPanel3D.this.quickRedrawOn = false;
            }
            DrawingPanel3D.this.lastX = _evt.getX();
            DrawingPanel3D.this.lastY = _evt.getY();
            DrawingPanel3D.this.targetHit = DrawingPanel3D.this.getTargetHit(DrawingPanel3D.this.lastX, DrawingPanel3D.this.lastY);
            if (DrawingPanel3D.this.targetHit != null) {
                Element el = DrawingPanel3D.this.targetHit.getElement();
                DrawingPanel3D.access$1102(DrawingPanel3D.this, el.getHotSpot(DrawingPanel3D.this.targetHit));
                el.invokeActions(new InteractionEvent((Object)el, 2000, DrawingPanel3D.this.targetHit.getActionCommand(), DrawingPanel3D.this.targetHit, _evt));
                DrawingPanel3D.access$1102(DrawingPanel3D.this, el.getHotSpot(DrawingPanel3D.this.targetHit));
            } else {
                if (!DrawingPanel3D.this.myTarget.isEnabled()) {
                    DrawingPanel3D.this.resetInteraction();
                    return;
                }
                if (DrawingPanel3D.this.camera.is3dMode() && !_evt.isAltDown()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2000, DrawingPanel3D.this.myTarget.getActionCommand(), null, _evt));
                    DrawingPanel3D.this.resetInteraction();
                    return;
                }
                DrawingPanel3D.access$1102(DrawingPanel3D.this, DrawingPanel3D.this.worldPoint(_evt.getX(), _evt.getY()));
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2000, DrawingPanel3D.this.myTarget.getActionCommand(), DrawingPanel3D.this.trackerPoint, _evt));
            }
            DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
            DrawingPanel3D.this.positionTrackers();
            DrawingPanel3D.this.showTrackers(true);
            DrawingPanel3D.this.dirtyImage = true;
            DrawingPanel3D.this.updatePanel();
        }

        public void mouseReleased(MouseEvent _evt) {
            if (DrawingPanel3D.this.targetHit != null) {
                Element el = DrawingPanel3D.this.targetHit.getElement();
                el.invokeActions(new InteractionEvent((Object)el, 2002, DrawingPanel3D.this.targetHit.getActionCommand(), DrawingPanel3D.this.targetHit, _evt));
            } else if (DrawingPanel3D.this.myTarget.isEnabled()) {
                if (!DrawingPanel3D.this.camera.is3dMode() || _evt.isAltDown()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2002, DrawingPanel3D.this.myTarget.getActionCommand(), DrawingPanel3D.this.trackerPoint, _evt));
                } else {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2002, DrawingPanel3D.this.myTarget.getActionCommand(), null, _evt));
                }
            }
            DrawingPanel3D.this.quickRedrawOn = false;
            DrawingPanel3D.this.resetInteraction();
        }

        public void mouseDragged(MouseEvent _evt) {
            boolean trackerMoved = DrawingPanel3D.this.mouseDraggedComputations(_evt);
            DrawingPanel3D.this.lastX = _evt.getX();
            DrawingPanel3D.this.lastY = _evt.getY();
            if (!trackerMoved) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2001, DrawingPanel3D.this.myTarget.getActionCommand(), null, _evt));
                DrawingPanel3D.this.resetInteraction();
                return;
            }
            if (DrawingPanel3D.this.targetHit != null) {
                Element el = DrawingPanel3D.this.targetHit.getElement();
                el.updateHotSpot(DrawingPanel3D.this.targetHit, DrawingPanel3D.this.trackerPoint);
                el.invokeActions(new InteractionEvent((Object)el, 2001, DrawingPanel3D.this.targetHit.getActionCommand(), DrawingPanel3D.this.targetHit, _evt));
                DrawingPanel3D.access$1102(DrawingPanel3D.this, el.getHotSpot(DrawingPanel3D.this.targetHit));
                DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
                DrawingPanel3D.this.positionTrackers();
                DrawingPanel3D.this.showTrackers(true);
            } else if (DrawingPanel3D.this.myTarget.isEnabled()) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2001, DrawingPanel3D.this.myTarget.getActionCommand(), DrawingPanel3D.this.trackerPoint, _evt));
                DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
                DrawingPanel3D.this.positionTrackers();
                DrawingPanel3D.this.showTrackers(true);
            }
            DrawingPanel3D.this.dirtyImage = true;
            DrawingPanel3D.this.updatePanel();
        }

        public void mouseEntered(MouseEvent _evt) {
            DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            if (DrawingPanel3D.this.myTarget.isEnabled()) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2003, DrawingPanel3D.this.myTarget.getActionCommand(), null, _evt));
            }
            DrawingPanel3D.this.targetHit = (DrawingPanel3D.this.targetEntered = null);
        }

        public void mouseExited(MouseEvent _evt) {
            DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(0));
            if (DrawingPanel3D.this.myTarget.isEnabled()) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2004, DrawingPanel3D.this.myTarget.getActionCommand(), null, _evt));
            }
            DrawingPanel3D.this.targetHit = (DrawingPanel3D.this.targetEntered = null);
        }

        public void mouseClicked(MouseEvent _evt) {
        }

        public void mouseMoved(MouseEvent _evt) {
            InteractionTarget target = DrawingPanel3D.this.getTargetHit(_evt.getX(), _evt.getY());
            if (target != null) {
                if (DrawingPanel3D.this.targetEntered == null) {
                    target.getElement().invokeActions(new InteractionEvent((Object)target.getElement(), 2003, target.getActionCommand(), target, _evt));
                }
                DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(12));
            } else {
                if (DrawingPanel3D.this.targetEntered != null) {
                    DrawingPanel3D.this.targetEntered.getElement().invokeActions(new InteractionEvent((Object)DrawingPanel3D.this.targetEntered.getElement(), 2004, DrawingPanel3D.this.targetEntered.getActionCommand(), DrawingPanel3D.this.targetEntered, _evt));
                } else if (DrawingPanel3D.this.myTarget.isEnabled()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2005, DrawingPanel3D.this.myTarget.getActionCommand(), null, _evt));
                }
                DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
            DrawingPanel3D.this.targetEntered = target;
        }
    }
}

