/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementArrow;
import org.opensourcephysics.display3d.simple3d.ElementSegment;

public class ElementArrow
extends ElementSegment
implements org.opensourcephysics.display3d.core.ElementArrow {
    private static final double ARROW_CST = 0.35;
    private static final double ARROW_MAX = 25.0;
    private int headPoints = 0;
    private int[] headA = new int[10];
    private int[] headB = new int[10];

    void draw(Graphics2D _g2, int _index) {
        Color theColor = this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.objects[_index].getDistance());
        if (_index < this.div - 1) {
            _g2.setStroke(this.getRealStyle().getLineStroke());
            _g2.setColor(theColor);
            _g2.drawLine(this.aCoord[_index], this.bCoord[_index], this.aCoord[_index + 1], this.bCoord[_index + 1]);
        } else {
            Color theFillColor = this.getPanel().projectColor(this.getRealStyle().getFillColor(), this.objects[_index].getDistance());
            this.drawHead(_g2, this.aCoord[_index], this.bCoord[_index], theColor, theFillColor);
        }
    }

    synchronized void drawQuickly(Graphics2D _g2) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged()) {
            this.computeDivisions();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        this.drawHead(_g2, this.aCoord[0], this.bCoord[0], this.getRealStyle().getLineColor(), this.getRealStyle().getFillColor());
    }

    void projectPoints() {
        super.projectPoints();
        double a = this.aCoord[this.div] - this.aCoord[0];
        double b = this.bCoord[this.div] - this.bCoord[0];
        double h = Math.sqrt(a * a + b * b);
        if (h == 0.0) {
            this.headPoints = 0;
            return;
        }
        a = 0.35 * a / h;
        b = 0.35 * b / h;
        if (h > 25.0) {
            a *= 25.0 / h;
            b *= 25.0 / h;
        }
        int p0 = (int)((double)this.aCoord[this.div] - a * h);
        int q0 = (int)((double)this.bCoord[this.div] - b * h);
        this.headPoints = 6;
        this.headA[0] = p0;
        this.headB[0] = q0;
        this.headA[1] = p0 - (int)(b *= h / 2.0);
        this.headB[1] = q0 + (int)(a *= h / 2.0);
        this.headA[2] = this.aCoord[this.div];
        this.headB[2] = this.bCoord[this.div];
        this.headA[3] = p0 + (int)b;
        this.headB[3] = q0 - (int)a;
        this.headA[4] = p0;
        this.headB[4] = q0;
    }

    private void drawHead(Graphics2D _g2, int a1, int b1, Color _color, Color _fill) {
        _g2.setStroke(this.getRealStyle().getLineStroke());
        if (this.headPoints == 0) {
            _g2.setColor(_color);
            _g2.drawLine(a1, b1, this.aCoord[this.div], this.bCoord[this.div]);
            return;
        }
        int n = this.headPoints - 1;
        this.headA[n] = a1;
        this.headB[n] = b1;
        if (_fill != null && this.getRealStyle().isDrawingFill()) {
            _g2.setPaint(_fill);
            _g2.fillPolygon(this.headA, this.headB, n);
        }
        _g2.setColor(_color);
        _g2.drawPolyline(this.headA, this.headB, this.headPoints);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementArrow.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl control) {
            return new ElementArrow();
        }
    }
}

