/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementImage;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ElementImage
extends Element
implements org.opensourcephysics.display3d.core.ElementImage {
    private String imageFile = null;
    private double angle = 0.0;
    private Resource resource = null;
    private Image image = null;
    private double[] coordinates = new double[3];
    private double[] size = new double[3];
    private double[] pixel = new double[3];
    private double[] pixelSize = new double[2];
    private Object3D[] objects = new Object3D[]{new Object3D(this, 0)};
    private AffineTransform transform = new AffineTransform();

    public void setImageFile(String file) {
        this.imageFile = file;
        if (file != null) {
            this.resource = ResourceLoader.getResource(file);
            if (this.resource != null) {
                this.image = this.resource.getImage();
            }
        }
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setRotationAngle(double angle) {
        this.angle = angle;
    }

    public double getRotationAngle() {
        return this.angle;
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        return this.objects;
    }

    void draw(Graphics2D _g2, int _index) {
        this.drawIt(_g2);
    }

    void drawQuickly(Graphics2D _g2) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        this.drawIt(_g2);
    }

    protected InteractionTarget getTargetHit(int x, int y) {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        if (this.targetPosition.isEnabled() && Math.abs(this.pixel[0] - (double)x) < 5.0 && Math.abs(this.pixel[1] - (double)y) < 5.0) {
            return this.targetPosition;
        }
        return null;
    }

    private void projectPoints() {
        this.coordinates[2] = 0.0;
        this.coordinates[1] = 0.0;
        this.coordinates[0] = 0.0;
        this.sizeAndToSpaceFrame(this.coordinates);
        this.getPanel().project(this.coordinates, this.pixel);
        this.objects[0].setDistance(this.pixel[2]);
        this.size[0] = this.getSizeX();
        this.size[1] = this.getSizeY();
        this.size[2] = this.getSizeZ();
        this.getPanel().projectSize(this.coordinates, this.size, this.pixelSize);
        this.setElementChanged(false);
        this.setNeedToProject(false);
    }

    private void drawIt(Graphics2D _g2) {
        if (this.image == null) {
            return;
        }
        if (this.angle != 0.0) {
            AffineTransform originalTransform = _g2.getTransform();
            this.transform.setTransform(originalTransform);
            this.transform.rotate(-this.angle, this.pixel[0], this.pixel[1]);
            _g2.setTransform(this.transform);
            _g2.drawImage(this.image, (int)(this.pixel[0] - this.pixelSize[0] / 2.0), (int)(this.pixel[1] - this.pixelSize[1] / 2.0), (int)this.pixelSize[0], (int)this.pixelSize[1], null);
            _g2.setTransform(originalTransform);
        } else {
            _g2.drawImage(this.image, (int)(this.pixel[0] - this.pixelSize[0] / 2.0), (int)(this.pixel[1] - this.pixelSize[1] / 2.0), (int)this.pixelSize[0], (int)this.pixelSize[1], null);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementImage.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl control) {
            return new ElementImage();
        }
    }
}

