/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementSurface;
import org.opensourcephysics.display3d.simple3d.AbstractTile;

public class ElementSurface
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementSurface {
    protected double[][][] data;
    protected int nu = -1;
    protected int nv = -1;

    public ElementSurface() {
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void setData(double[][][] data) {
        this.data = data;
        this.setElementChanged(true);
    }

    public double[][][] getData() {
        return this.data;
    }

    public void getExtrema(double[] min, double[] max) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double[] aPoint = new double[3];
        int n1 = this.data.length;
        for (int i = 0; i < n1; ++i) {
            int n2 = this.data[0].length;
            for (int j = 0; j < n2; ++j) {
                System.arraycopy(this.data[i][j], 0, aPoint, 0, 3);
                this.sizeAndToSpaceFrame(aPoint);
                minX = Math.min(minX, aPoint[0]);
                maxX = Math.max(maxX, aPoint[0]);
                minY = Math.min(minY, aPoint[1]);
                maxY = Math.max(maxY, aPoint[1]);
                minZ = Math.min(minZ, aPoint[2]);
                maxZ = Math.max(maxZ, aPoint[2]);
            }
        }
        min[0] = minX;
        max[0] = maxX;
        min[1] = minY;
        max[1] = maxY;
        min[2] = minZ;
        max[2] = maxZ;
    }

    protected synchronized void computeCorners() {
        if (this.data == null) {
            return;
        }
        int theNu = this.data.length - 1;
        int theNv = this.data[0].length - 1;
        if (this.nu != theNu || this.nv != theNv) {
            this.nu = theNu;
            this.nv = theNv;
            this.setCorners(new double[this.nu * this.nv][4][3]);
        }
        int tile = 0;
        for (int v = 0; v < this.nv; ++v) {
            int u = 0;
            while (u < this.nu) {
                for (int k = 0; k < 3; ++k) {
                    this.corners[tile][0][k] = this.data[u][v][k];
                    this.corners[tile][1][k] = this.data[u + 1][v][k];
                    this.corners[tile][2][k] = this.data[u + 1][v + 1][k];
                    this.corners[tile][3][k] = this.data[u][v + 1][k];
                }
                ++u;
                ++tile;
            }
        }
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int sides = this.corners[i].length;
            for (int j = 0; j < sides; ++j) {
                this.sizeAndToSpaceFrame(this.corners[i][j]);
            }
        }
        this.setElementChanged(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementSurface.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl control) {
            return new ElementSurface();
        }
    }
}

