/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementTrail;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.Object3D;

public class ElementTrail
extends Element
implements org.opensourcephysics.display3d.core.ElementTrail {
    private boolean connected = true;
    private int maximum = 0;
    private int theFirstPoint = 0;
    protected ArrayList list = new ArrayList();
    private TrailPoint[] points = new TrailPoint[0];

    public void addPoint(double x, double y, double z) {
        this.addPoint(x, y, z, this.connected);
    }

    public void addPoint(double[] point) {
        if (point.length > 2) {
            this.addPoint(point[0], point[1], point[2], this.connected);
        } else {
            this.addPoint(point[0], point[1], 0.0, this.connected);
        }
    }

    public void moveToPoint(double x, double y, double z) {
        this.addPoint(x, y, z, false);
    }

    public void setMaximumPoints(int maximum) {
        this.maximum = Math.max(maximum, 0);
        this.clear();
    }

    public int getMaximumPoints() {
        return this.maximum;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
        this.points = new TrailPoint[0];
        this.theFirstPoint = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPoint(double _x, double _y, double _z, boolean _c) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int position = this.list.size();
            if (this.maximum > 0 && position >= this.maximum) {
                position = this.theFirstPoint;
                this.list.remove(this.theFirstPoint);
                this.theFirstPoint = (this.theFirstPoint + 1) % this.maximum;
            }
            TrailPoint point = new TrailPoint(position, _x, _y, _z, _c);
            this.list.add(position, point);
            if (this.getPanel() != null) {
                point.transformAndProject();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getExtrema(double[] min, double[] max) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double[] aPoint = new double[3];
        TrailPoint[] tmpPoints = new TrailPoint[]{};
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            tmpPoints = this.list.toArray(tmpPoints);
        }
        int n = tmpPoints.length;
        for (int i = 0; i < n; ++i) {
            aPoint[0] = tmpPoints[i].xp;
            aPoint[1] = tmpPoints[i].yp;
            aPoint[2] = tmpPoints[i].zp;
            this.sizeAndToSpaceFrame(aPoint);
            minX = Math.min(minX, aPoint[0]);
            maxX = Math.max(maxX, aPoint[0]);
            minY = Math.min(minY, aPoint[1]);
            maxY = Math.max(maxY, aPoint[1]);
            minZ = Math.min(minZ, aPoint[2]);
            maxZ = Math.max(maxZ, aPoint[2]);
        }
        min[0] = minX;
        max[0] = maxX;
        min[1] = minY;
        max[1] = maxY;
        min[2] = minZ;
        max[2] = maxZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object3D[] getObjects3D() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (!this.isReallyVisible() || this.list.size() <= 0) {
                return null;
            }
            this.points = this.list.toArray(this.points);
        }
        if (this.hasChanged()) {
            this.transformAndProjectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        return this.points;
    }

    void draw(Graphics2D _g2, int _index) {
        TrailPoint point = this.points[_index];
        Color theColor = this.getPanel().projectColor(this.getRealStyle().getLineColor(), point.getDistance());
        _g2.setStroke(this.getRealStyle().getLineStroke());
        _g2.setColor(theColor);
        if (_index == this.theFirstPoint || !point.connected) {
            _g2.drawLine((int)point.pixel[0], (int)point.pixel[1], (int)point.pixel[0], (int)point.pixel[1]);
        } else {
            if (_index == 0) {
                _index = this.maximum;
            }
            TrailPoint pointPrev = this.points[_index - 1];
            _g2.drawLine((int)point.pixel[0], (int)point.pixel[1], (int)pointPrev.pixel[0], (int)pointPrev.pixel[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawQuickly(Graphics2D _g2) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (!this.isReallyVisible() || this.list.size() <= 0) {
                return;
            }
            this.points = this.list.toArray(this.points);
        }
        if (this.hasChanged()) {
            this.transformAndProjectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        _g2.setStroke(this.getRealStyle().getLineStroke());
        _g2.setColor(this.getRealStyle().getLineColor());
        TrailPoint point = this.points[this.theFirstPoint];
        int aPrev = (int)point.pixel[0];
        int bPrev = (int)point.pixel[1];
        _g2.drawLine(aPrev, bPrev, aPrev, bPrev);
        int n = this.points.length;
        for (int i = 1; i < n; ++i) {
            int index = this.maximum > 0 ? (i + this.theFirstPoint) % this.maximum : i;
            point = this.points[index];
            if (point.connected) {
                _g2.drawLine((int)point.pixel[0], (int)point.pixel[1], aPrev, bPrev);
            } else {
                _g2.drawLine((int)point.pixel[0], (int)point.pixel[1], (int)point.pixel[0], (int)point.pixel[1]);
            }
            aPrev = (int)point.pixel[0];
            bPrev = (int)point.pixel[1];
        }
    }

    synchronized void transformAndProjectPoints() {
        int n = this.points.length;
        for (int i = 0; i < n; ++i) {
            this.points[i].transformAndProject();
        }
        this.setNeedToProject(false);
        this.setElementChanged(false);
    }

    synchronized void projectPoints() {
        int n = this.points.length;
        for (int i = 0; i < n; ++i) {
            this.points[i].transformAndProject();
        }
        this.setNeedToProject(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementTrail.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl control) {
            return new ElementTrail();
        }
    }

    private class TrailPoint
    extends Object3D {
        boolean connected;
        private double xp;
        private double yp;
        private double zp;
        private double[] coordinates = new double[3];
        double[] pixel = new double[3];

        TrailPoint(int _index, double _x, double _y, double _z, boolean _c) {
            super(ElementTrail.this, _index);
            this.xp = _x;
            this.yp = _y;
            this.zp = _z;
            this.connected = _c;
        }

        void transformAndProject() {
            this.coordinates[0] = this.xp;
            this.coordinates[1] = this.yp;
            this.coordinates[2] = this.zp;
            ElementTrail.this.sizeAndToSpaceFrame(this.coordinates);
            ElementTrail.this.getPanel().project(this.coordinates, this.pixel);
            super.setDistance(this.pixel[2]);
        }

        void project() {
            ElementTrail.this.getPanel().project(this.coordinates, this.pixel);
            super.setDistance(this.pixel[2]);
        }
    }
}

