/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.core.Style;
import org.opensourcephysics.display3d.simple3d.Element;

public class Style
implements org.opensourcephysics.display3d.core.Style {
    static final int STYLE_LINE_COLOR = 0;
    static final int STYLE_LINE_WIDTH = 1;
    static final int STYLE_FILL_COLOR = 2;
    static final int STYLE_RESOLUTION = 3;
    static final int STYLE_DRAWING_FILL = 4;
    static final int STYLE_DRAWING_LINES = 5;
    private boolean drawsFill = true;
    private boolean drawsLines = true;
    private Color lineColor = Color.black;
    private float lineWidth = 1.0f;
    private Color fillColor = Color.blue;
    private Resolution resolution = null;
    private boolean drawFillsSet = false;
    private boolean drawLinesSet = false;
    private Element element = null;
    private Stroke lineStroke = new BasicStroke(this.lineWidth);

    Style(Element _element) {
        this.element = _element;
    }

    void setElement(Element _element) {
        this.element = _element;
    }

    public void setLineColor(Color _color) {
        if (_color == null) {
            return;
        }
        this.lineColor = _color;
        if (this.element != null) {
            this.element.styleChanged(0);
        }
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public void setLineWidth(float _width) {
        if (this.lineWidth == _width) {
            return;
        }
        this.lineWidth = _width;
        this.lineStroke = new BasicStroke(this.lineWidth);
        if (this.element != null) {
            this.element.styleChanged(1);
        }
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    final Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setFillColor(Color _color) {
        if (_color == null) {
            return;
        }
        this.fillColor = _color;
        if (this.element != null) {
            this.element.styleChanged(2);
        }
    }

    public final Color getFillColor() {
        return this.fillColor;
    }

    public void setResolution(Resolution _res) {
        this.resolution = _res;
        if (this.element != null) {
            this.element.styleChanged(3);
        }
    }

    public final Resolution getResolution() {
        return this.resolution;
    }

    public boolean isDrawingFill() {
        return this.drawsFill;
    }

    public void setDrawingFill(boolean _drawsFill) {
        this.drawsFill = _drawsFill;
        this.drawFillsSet = true;
        if (this.element != null) {
            this.element.styleChanged(4);
        }
    }

    public boolean isDrawingLines() {
        return this.drawsLines;
    }

    public void setDrawingLines(boolean _drawsLines) {
        this.drawsLines = _drawsLines;
        this.drawLinesSet = true;
        if (this.element != null) {
            this.element.styleChanged(5);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new StyleLoader();
    }

    protected static class StyleLoader
    extends Style.Loader {
        protected StyleLoader() {
        }

        public Object createObject(XMLControl control) {
            return new Style(null);
        }

        public void saveObject(XMLControl control, Object obj) {
            Style style = (Style)obj;
            control.setValue("line color", style.getLineColor());
            control.setValue("line width", style.getLineWidth());
            control.setValue("fill color", style.getFillColor());
            control.setValue("resolution", style.getResolution());
            if (style.drawFillsSet) {
                control.setValue("drawing fill", style.isDrawingFill());
            }
            if (style.drawLinesSet) {
                control.setValue("drawing lines", style.isDrawingLines());
            }
        }

        public Object loadObject(XMLControl control, Object obj) {
            Style style = (Style)obj;
            style.setLineColor((Color)control.getObject("line color"));
            style.setLineWidth((float)control.getDouble("line width"));
            style.setFillColor((Color)control.getObject("fill color"));
            style.setResolution((Resolution)control.getObject("resolution"));
            if (control.getPropertyType("drawing fill") != null) {
                System.out.println("Reading drawFills");
                style.setDrawingFill(control.getBoolean("drawing fill"));
            } else {
                System.out.println("Not reading drawFills");
            }
            if (control.getPropertyType("drawing lines") != null) {
                System.out.println("Reading drawLines");
                style.setDrawingLines(control.getBoolean("drawing lines"));
            } else {
                System.out.println("Not reading drawLines");
            }
            return obj;
        }
    }
}

