/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d.utils;

public class VectorAlgebra {
    public static double norm(double[] u) {
        return Math.sqrt(u[0] * u[0] + u[1] * u[1] + u[2] * u[2]);
    }

    public static double[] crossProduct(double[] u, double[] v) {
        return new double[]{u[1] * v[2] - u[2] * v[1], u[2] * v[0] - u[0] * v[2], u[0] * v[1] - u[1] * v[0]};
    }

    public static double[] normalize(double[] u) {
        double r = VectorAlgebra.norm(u);
        return new double[]{u[0] / r, u[1] / r, u[2] / r};
    }

    public static double[] normalTo(double[] vector) {
        if (vector[0] == 0.0) {
            return new double[]{1.0, 0.0, 0.0};
        }
        if (vector[1] == 0.0) {
            return new double[]{0.0, 1.0, 0.0};
        }
        if (vector[2] == 0.0) {
            return new double[]{0.0, 0.0, 1.0};
        }
        double norm = Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1]);
        return new double[]{-vector[1] / norm, vector[0] / norm, 0.0};
    }
}

