/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.ejs.Model;
import org.opensourcephysics.ejs.Simulation;
import org.opensourcephysics.ejs.View;

public class LauncherApplet
extends JApplet {
    private JFrame _parentFrame = null;
    public Model _model = null;
    public Simulation _simulation = null;
    public View _view = null;

    public String getParameter(String key, String def) {
        return this.getParameter(key) != null ? this.getParameter(key) : def;
    }

    public void _play() {
        this._simulation.play();
    }

    public void _pause() {
        this._simulation.pause();
    }

    public void _step() {
        this._simulation.step();
    }

    public void _setFPS(int _fps) {
        this._simulation.setFPS(_fps);
    }

    public void _setDelay(int _delay) {
        this._simulation.setDelay(_delay);
    }

    public void _reset() {
        this._simulation.reset();
    }

    public void _initialize() {
        this._simulation.initialize();
    }

    public boolean _saveState(String _filename) {
        return this._simulation.saveState(_filename);
    }

    public boolean _readState(String _filename) {
        return this._simulation.readState(_filename, this.getCodeBase());
    }

    public boolean _setVariables(String _command, String _delim, String _arrayDelim) {
        return this._simulation.setVariables(_command, _delim, _arrayDelim);
    }

    public boolean _setVariables(String _command) {
        return this._simulation.setVariables(_command);
    }

    public String _getVariable(String _varName) {
        return this._simulation.getVariable(_varName);
    }

    public void _resetView() {
        this._view.reset();
    }

    public void init() {
        String simClass = null;
        String windowToCapture = null;
        try {
            simClass = this.getParameter("simulation", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            windowToCapture = this.getParameter("capture", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (windowToCapture != null && this.getParentFrame() != null && this.getParentFrame() instanceof Frame) {
            this._model = LauncherApplet.createModel(simClass, windowToCapture, this.getParentFrame(), this.getCodeBase());
            this._simulation = this._model.getSimulation();
            this._view = this._model.getView();
            this.captureWindow(this._model.getView(), windowToCapture);
        } else {
            this._model = LauncherApplet.createModel(simClass, null, null, this.getCodeBase());
            this._simulation = this._model.getSimulation();
            this._view = this._model.getView();
        }
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"simulation", "String", "The simulation"}, {"capture", "String", "The name of the component to be captured"}};
        return pinfo;
    }

    private Frame getParentFrame() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Frame)) continue;
            return (Frame)parent;
        }
        return null;
    }

    static Model createModel(String simClass, String _ownerName, Frame _ownerFrame, URL _codebase) {
        Model aModel = null;
        if (_ownerName != null || _codebase != null) {
            try {
                Class<?> c = Class.forName(simClass);
                Constructor<?>[] constructors = c.getConstructors();
                for (int i = 0; i < constructors.length; ++i) {
                    Class<?>[] parameters = constructors[i].getParameterTypes();
                    if (parameters.length != 3 || !parameters[0].isAssignableFrom(_ownerName.getClass()) || !parameters[1].isAssignableFrom(_ownerFrame.getClass()) || !parameters[2].isAssignableFrom(_codebase.getClass())) continue;
                    aModel = (Model)constructors[i].newInstance(_ownerName, _ownerFrame, _codebase);
                    break;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
                aModel = null;
            }
        }
        if (aModel == null) {
            try {
                Class<?> aClass = Class.forName(simClass);
                aModel = (Model)aClass.newInstance();
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return null;
            }
        }
        return aModel;
    }

    private void captureWindow(View _aView, String _aWindow) {
        if (_aWindow == null) {
            return;
        }
        Container root = this._parentFrame != null ? this._parentFrame : this;
        Component comp = _aView.getComponent(_aWindow);
        if (comp == null) {
            return;
        }
        if (comp instanceof DrawingFrame) {
            comp.setVisible(true);
            Container contentPane = ((RootPaneContainer)((Object)comp)).getContentPane();
            contentPane.setVisible(true);
            root.setContentPane(contentPane);
            Component glassPane = ((RootPaneContainer)((Object)comp)).getGlassPane();
            root.setGlassPane(glassPane);
            glassPane.setVisible(true);
            ((DrawingFrame)comp).setKeepHidden(true);
            ((DrawingFrame)comp).setDefaultCloseOperation(2);
        } else if (comp instanceof JDialog) {
            comp.setVisible(true);
            Container contentPane = ((RootPaneContainer)((Object)comp)).getContentPane();
            contentPane.setVisible(true);
            root.setContentPane(contentPane);
            Component glassPane = ((RootPaneContainer)((Object)comp)).getGlassPane();
            root.setGlassPane(glassPane);
            glassPane.setVisible(true);
            ((JDialog)comp).dispose();
        } else {
            root.getContentPane().setLayout(new BorderLayout());
            root.getContentPane().add(comp, "Center");
            root.getContentPane().validate();
            Container oldParent = comp.getParent();
            if (oldParent != null) {
                oldParent.validate();
            }
        }
        if (this._parentFrame != null) {
            this._parentFrame.pack();
        }
    }
}

