/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import org.opensourcephysics.ejs.control.EjsControl;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;
import org.opensourcephysics.numerics.Util;

public class ParsedEjsControl
extends EjsControl {
    public ParsedEjsControl(Object simulation) {
        super(simulation);
    }

    public double getDouble(String var) {
        Value value = this.getValue(var);
        if (value instanceof DoubleValue) {
            return super.getDouble(var);
        }
        if (value instanceof IntegerValue) {
            return super.getInt(var);
        }
        String str = super.getString(var);
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException ex) {
            return Util.evalMath(str);
        }
    }

    public Object getObject(String var) {
        Value value = this.getValue(var);
        if (value == null) {
            return null;
        }
        if (value instanceof IntegerValue) {
            return new Integer(super.getInt(var));
        }
        if (value instanceof DoubleValue) {
            return new Double(super.getDouble(var));
        }
        if (value instanceof BooleanValue) {
            return new Boolean(super.getBoolean(var));
        }
        if (value instanceof StringValue) {
            return super.getString(var);
        }
        return super.getObject(var);
    }

    public int getInt(String var) {
        Value value = this.getValue(var);
        if (value instanceof IntegerValue) {
            return super.getInt(var);
        }
        if (value instanceof DoubleValue) {
            return (int)super.getDouble(var);
        }
        String str = super.getString(var);
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            return (int)Util.evalMath(str);
        }
    }
}

