/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.swing.ConstantParser;
import org.opensourcephysics.ejs.control.swing.ControlRadioButton;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.BooleanValue;

public abstract class ControlContainer
extends ControlSwingElement {
    private static final BooleanValue falseValue = new BooleanValue(false);
    protected Vector radioButtons = new Vector();
    protected Vector children = new Vector();

    public ControlContainer(Object _visual) {
        super(_visual);
    }

    public Container getContainer() {
        return (Container)this.getVisual();
    }

    public void add(ControlElement _child) {
        this.children.add(_child);
        Container container = this.getContainer();
        LayoutManager layout = container.getLayout();
        String indexInParent = _child.getProperty("_ejs_indexInParent_");
        int index = -1;
        if (indexInParent != null) {
            index = Integer.parseInt(indexInParent);
        }
        _child.setProperty("_ejs_indexInParent_", null);
        if (layout instanceof BorderLayout) {
            String pos = _child.getProperty("position");
            if (pos != null) {
                container.add(_child.getComponent(), ConstantParser.constraintsConstant(pos).getString(), index);
            } else {
                container.add(_child.getComponent(), "Center", index);
            }
        } else {
            container.add(_child.getComponent(), index);
        }
        this.adjustSize();
        if (_child instanceof ControlRadioButton) {
            this.radioButtons.add(_child);
            ((ControlRadioButton)_child).setParent(this);
        }
        this.propagateProperty(_child, "font", this.getProperty("font"));
        this.propagateProperty(_child, "foreground", this.getProperty("foreground"));
        this.propagateProperty(_child, "background", this.getProperty("background"));
    }

    public void adjustSize() {
        this.getContainer().validate();
        this.getContainer().repaint();
        ControlContainer.resizeContainer(this.getContainer());
        ControlContainer.resizeContainer(this.getComponent().getParent());
    }

    private static void resizeContainer(Container _container) {
        if (_container == null) {
            return;
        }
        Rectangle b = _container.getBounds();
        _container.setBounds(b.x, b.y, b.width + 1, b.height + 1);
        _container.setBounds(b.x, b.y, b.width, b.height);
        _container.validate();
        _container.repaint();
    }

    public Vector getChildren() {
        return this.children;
    }

    public void remove(ControlElement _child) {
        this.children.remove(_child);
        Container container = this.getContainer();
        container.remove(_child.getComponent());
        container.validate();
        container.repaint();
        if (_child instanceof ControlRadioButton) {
            this.radioButtons.remove(_child);
            ((ControlRadioButton)_child).setParent(null);
        }
    }

    public void informRadioGroup(ControlRadioButton _source, boolean _state) {
        if (!_state) {
            return;
        }
        Enumeration e = this.radioButtons.elements();
        while (e.hasMoreElements()) {
            ControlRadioButton rb = (ControlRadioButton)e.nextElement();
            if (rb == _source) continue;
            boolean wasActive = rb.isActive();
            rb.setActive(false);
            rb.setValue(4, falseValue);
            rb.reportChanges();
            rb.setActive(wasActive);
        }
    }

    private void propagateProperty(ControlElement _child, String _property, String _value) {
        if (_child.getProperty(_property) == null) {
            _child.setProperty(_property, _value);
        }
    }

    private void propagateProperty(String _property, String _value) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.propagateProperty((ControlElement)this.children.elementAt(i), _property, _value);
        }
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("visible")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    public ControlElement setProperty(String _property, String _value) {
        ControlElement returnValue = super.setProperty(_property, _value);
        if (_property.equals("font") || _property.equals("foreground") || _property.equals("background")) {
            this.propagateProperty(_property, _value);
        }
        return returnValue;
    }
}

