/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.util.ArrayList;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.swing.ControlDrawablesParent;
import org.opensourcephysics.ejs.control.swing.NeedsPreUpdate;
import org.opensourcephysics.ejs.control.value.Value;

public abstract class ControlDrawable
extends ControlElement {
    public static final int NAME = 0;
    public static final int PARENT = 1;
    protected ControlDrawablesParent myParent;
    private Drawable myDrawable = null;
    private static ArrayList infoList = null;

    public ControlDrawable(Object _drawable) {
        super(_drawable);
        this.myDrawable = this.createDrawable(_drawable);
        this.myObject = this.myDrawable;
    }

    protected abstract Drawable createDrawable(Object var1);

    public final Drawable getDrawable() {
        return this.myDrawable;
    }

    public final void setDrawable(Drawable _dr) {
        this.myDrawable = _dr;
    }

    public void setParent(ControlDrawablesParent _dp) {
        if (this.myParent != null) {
            ((DrawingPanel)this.myParent.getVisual()).removeDrawable(this.myDrawable);
            if (this instanceof NeedsPreUpdate) {
                this.myParent.removeFromPreupdateList((NeedsPreUpdate)((Object)this));
            }
        }
        if (_dp != null) {
            ((DrawingPanel)_dp.getVisual()).addDrawable(this.myDrawable);
            ((DrawingPanel)_dp.getVisual()).render();
            if (this instanceof NeedsPreUpdate) {
                _dp.addToPreupdateList((NeedsPreUpdate)((Object)this));
            }
            this.myParent = _dp;
        }
    }

    public final ControlDrawablesParent getParent() {
        return this.myParent;
    }

    public void destroy() {
        super.destroy();
        if (this.myParent != null) {
            ((DrawingPanel)this.myParent.getVisual()).render();
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("name");
            infoList.add("parent");
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("name")) {
            return "String         CONSTANT HIDDEN";
        }
        if (_property.equals("parent")) {
            return "ControlElement CONSTANT HIDDEN";
        }
        return null;
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                super.setValue(0, _value);
                break;
            }
            case 1: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent != null) {
                    this.setParent(null);
                }
                if ((parent = this.myGroup.getElement(_value.toString())) == null) {
                    System.err.println(this.getClass().getName() + " : Error! Parent <" + _value + "> not found for " + this.toString());
                    break;
                }
                if (parent instanceof ControlDrawablesParent) {
                    this.setParent((ControlDrawablesParent)parent);
                    break;
                }
                System.err.println(this.getClass().getName() + " : Error! Parent <" + _value + "> is not a ControlDrawablesParent");
                break;
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                super.setDefaultValue(0);
                break;
            }
            case 1: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent == null) break;
                this.setParent(null);
                break;
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            default: 
        }
        return null;
    }
}

