/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JSplitPane;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.swing.ControlRadioButton;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlSplitPanel
extends ControlContainer {
    protected JSplitPane splitpanel;
    private boolean hasOne = false;
    private static ArrayList infoList = null;

    public ControlSplitPanel(Object _visual) {
        super(_visual);
    }

    protected Component createVisual(Object _visual) {
        if (_visual instanceof JSplitPane) {
            this.splitpanel = (JSplitPane)_visual;
        } else {
            this.splitpanel = new JSplitPane();
            this.splitpanel.setOneTouchExpandable(true);
            this.splitpanel.setDividerLocation(-1);
        }
        return this.splitpanel;
    }

    public void reset() {
        this.splitpanel.setDividerLocation(-1);
    }

    public void add(ControlElement _child) {
        if (this.hasOne) {
            this.splitpanel.setBottomComponent(_child.getComponent());
            this.splitpanel.setDividerLocation(-1);
        } else {
            this.splitpanel.setTopComponent(_child.getComponent());
            this.splitpanel.setDividerLocation(-1);
            this.hasOne = true;
        }
        if (_child instanceof ControlRadioButton) {
            this.radioButtons.add(_child);
            ((ControlRadioButton)_child).setParent(this);
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("orientation");
            infoList.add("expandable");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("orientation")) {
            return "Orientation|int";
        }
        if (_property.equals("expandable")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("Orientation") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("vertical")) {
                return new IntegerValue(0);
            }
            if (_value.equals("horizontal")) {
                return new IntegerValue(1);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (this.splitpanel.getOrientation() == _value.getInteger()) break;
                this.splitpanel.setOrientation(_value.getInteger());
                break;
            }
            case 1: {
                this.splitpanel.setOneTouchExpandable(_value.getBoolean());
                break;
            }
            default: {
                super.setValue(_index - 2, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.splitpanel.setOrientation(1);
                break;
            }
            case 1: {
                this.splitpanel.setOneTouchExpandable(true);
                break;
            }
            default: {
                super.setDefaultValue(_index - 2);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(_index - 2);
    }
}

