/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ComplexColorMapper;
import org.opensourcephysics.display2d.ComplexGridPlot;
import org.opensourcephysics.display2d.ComplexInterpolatedPlot;
import org.opensourcephysics.display2d.ComplexSurfacePlot;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridTableFrame;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.SurfacePlotMouseController;

public class Complex2DFrame
extends DrawingFrame {
    GridData gridData;
    Plot2D plot = new ComplexGridPlot(null);
    SurfacePlotMouseController surfacePlotMC;
    JMenuItem surfaceItem;
    JMenuItem gridItem;
    JMenuItem interpolatedItem;
    GridTableFrame tableFrame;
    int[] gutters;

    public Complex2DFrame(String xlabel, String ylabel, String frameTitle) {
        super(new PlottingPanel(xlabel, ylabel, null));
        this.drawingPanel.setPreferredSize(new Dimension(350, 350));
        this.setTitle(frameTitle);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorXGrid(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorYGrid(false);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
        this.gutters = this.drawingPanel.getGutters();
    }

    public void setAutoscaleZ(boolean isAutoscale, double floor, double ceil) {
        this.plot.setAutoscaleZ(isAutoscale, floor, ceil);
    }

    public Complex2DFrame(String frameTitle) {
        super(new InteractivePanel());
        this.setTitle(frameTitle);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
        this.gutters = this.drawingPanel.getGutters();
    }

    protected void addMenuItems() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return;
        }
        JMenu helpMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu menu = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (menu == null) {
            menu = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            menuBar.add(menu);
            menuBar.validate();
        } else {
            menu.addSeparator();
        }
        if (helpMenu != null) {
            menuBar.add(helpMenu);
        }
        ButtonGroup menubarGroup = new ButtonGroup();
        this.gridItem = new JRadioButtonMenuItem("Grid Plot");
        menubarGroup.add(this.gridItem);
        this.gridItem.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Complex2DFrame.this.convertToGridPlot();
            }
        };
        this.gridItem.addActionListener(actionListener);
        menu.add(this.gridItem);
        this.surfaceItem = new JRadioButtonMenuItem("Surface Plot");
        menubarGroup.add(this.surfaceItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Complex2DFrame.this.convertToSurfacePlot();
            }
        };
        this.surfaceItem.addActionListener(actionListener);
        menu.add(this.surfaceItem);
        this.interpolatedItem = new JRadioButtonMenuItem("Interpolated Plot");
        menubarGroup.add(this.interpolatedItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Complex2DFrame.this.convertToInterpolatedPlot();
            }
        };
        this.interpolatedItem.addActionListener(actionListener);
        menu.add(this.interpolatedItem);
        menu.addSeparator();
        JMenuItem legendItem = new JMenuItem("Phase Legend");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComplexColorMapper.showPhaseLegend();
            }
        };
        legendItem.addActionListener(actionListener);
        menu.add(legendItem);
        JMenuItem tableItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        tableItem.setAccelerator(KeyStroke.getKeyStroke(84, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Complex2DFrame.this.showDataTable(true);
            }
        };
        tableItem.addActionListener(actionListener);
        menu.add(tableItem);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            JMenuItem item = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
            item.addActionListener(actionListener);
            this.drawingPanel.getPopupMenu().add(item);
        }
    }

    public synchronized ArrayList getDrawables() {
        ArrayList list = super.getDrawables();
        ((AbstractCollection)list).remove(this.plot);
        return list;
    }

    public synchronized ArrayList getDrawables(Class c) {
        ArrayList list = super.getDrawables(c);
        ((AbstractCollection)list).remove(this.plot);
        return list;
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.plot);
    }

    public void clearData() {
        if (this.gridData != null) {
            this.setAll(new double[2][this.gridData.getNx()][this.gridData.getNy()]);
        }
        this.drawingPanel.invalidateImage();
    }

    public void convertToInterpolatedPlot() {
        if (!(this.plot instanceof ComplexInterpolatedPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
                this.drawingPanel.setGutters(this.gutters);
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).getAxes().setVisible(true);
                }
                this.drawingPanel.setShowCoordinates(true);
            }
            this.drawingPanel.removeDrawable(this.plot);
            this.plot = new ComplexInterpolatedPlot(this.gridData);
            this.drawingPanel.addDrawable(this.plot);
            this.drawingPanel.invalidateImage();
            this.drawingPanel.repaint();
            this.interpolatedItem.setSelected(true);
        }
    }

    public void convertToGridPlot() {
        if (!(this.plot instanceof ComplexGridPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
                this.drawingPanel.setGutters(this.gutters);
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).getAxes().setVisible(true);
                }
                this.drawingPanel.setShowCoordinates(true);
            }
            this.drawingPanel.removeDrawable(this.plot);
            this.plot = new ComplexGridPlot(this.gridData);
            this.drawingPanel.addDrawable(this.plot);
            this.drawingPanel.invalidateImage();
            this.drawingPanel.repaint();
            this.gridItem.setSelected(true);
        }
    }

    public void convertToSurfacePlotOLD() {
        if (!(this.plot instanceof ComplexSurfacePlot)) {
            this.drawingPanel.removeDrawable(this.plot);
            try {
                this.plot = new ComplexSurfacePlot(this.gridData);
            }
            catch (IllegalArgumentException ex) {
                this.plot = null;
                this.surfaceItem.setEnabled(false);
                this.convertToGridPlot();
                return;
            }
            this.drawingPanel.addDrawable(this.plot);
            this.drawingPanel.invalidateImage();
            this.drawingPanel.repaint();
            if (this.surfacePlotMC == null) {
                this.surfacePlotMC = new SurfacePlotMouseController(this.drawingPanel, this.plot);
            }
            this.drawingPanel.addMouseListener(this.surfacePlotMC);
            this.drawingPanel.addMouseMotionListener(this.surfacePlotMC);
            this.surfaceItem.setSelected(true);
        }
    }

    public void convertToSurfacePlot() {
        if (!(this.plot instanceof ComplexSurfacePlot)) {
            Plot2D oldPlot = this.plot;
            try {
                ComplexSurfacePlot newPlot = new ComplexSurfacePlot(this.gridData);
                this.plot = newPlot;
            }
            catch (IllegalArgumentException ex) {
                this.surfaceItem.setEnabled(false);
                this.gridItem.setSelected(true);
                this.convertToGridPlot();
                return;
            }
            this.gutters = this.drawingPanel.getGutters();
            if (this.drawingPanel instanceof PlottingPanel) {
                ((PlottingPanel)this.drawingPanel).getAxes().setVisible(false);
            }
            this.drawingPanel.setShowCoordinates(false);
            this.drawingPanel.setGutters(0, 0, 0, 0);
            boolean isAutoscaleZ = oldPlot.isAutoscaleZ();
            double floor = oldPlot.getFloor();
            double ceil = oldPlot.getCeiling();
            this.plot.setAutoscaleZ(isAutoscaleZ, floor, ceil);
            this.drawingPanel.replaceDrawable(oldPlot, this.plot);
            this.plot.update();
            if (this.tableFrame != null && this.tableFrame.isShowing()) {
                this.tableFrame.refreshTable();
            }
            this.drawingPanel.repaint();
            if (this.surfacePlotMC == null) {
                this.surfacePlotMC = new SurfacePlotMouseController(this.drawingPanel, this.plot);
            }
            this.drawingPanel.addMouseListener(this.surfacePlotMC);
            this.drawingPanel.addMouseMotionListener(this.surfacePlotMC);
            this.surfaceItem.setSelected(true);
        }
    }

    public void resizeGrid(int nx, int ny) {
        double ymax;
        double ymin;
        double xmax;
        double xmin;
        boolean cellScale = false;
        if (this.gridData == null) {
            xmin = this.drawingPanel.getPreferredXMin();
            xmax = this.drawingPanel.getPreferredXMax();
            ymin = this.drawingPanel.getPreferredYMin();
            ymax = this.drawingPanel.getPreferredYMax();
        } else {
            xmin = this.gridData.getLeft();
            xmax = this.gridData.getRight();
            ymin = this.gridData.getBottom();
            ymax = this.gridData.getTop();
            cellScale = this.gridData.isCellData();
        }
        this.gridData = new ArrayData(nx, ny, 3);
        this.gridData.setComponentName(0, "magnitude");
        this.gridData.setComponentName(1, "real");
        this.gridData.setComponentName(2, "imaginary");
        if (cellScale) {
            this.gridData.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.gridData.setScale(xmin, xmax, ymin, ymax);
        }
        if (nx != ny) {
            this.surfaceItem.setEnabled(false);
            if (this.plot instanceof ComplexSurfacePlot) {
                this.convertToGridPlot();
            }
        } else {
            this.surfaceItem.setEnabled(true);
        }
        this.plot.setGridData(this.gridData);
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void setRow(int row, double[][] vals) throws IllegalArgumentException {
        if (this.gridData.getNx() != vals.length) {
            throw new IllegalArgumentException("Row data length does not match grid size.");
        }
        double[] re = this.gridData.getData()[1][row];
        double[] im = this.gridData.getData()[2][row];
        double[] phase = this.gridData.getData()[0][row];
        System.arraycopy(vals[0], 0, re, 0, vals.length);
        System.arraycopy(vals[1], 0, im, 0, vals.length);
        int ny = phase.length;
        for (int j = 0; j < ny; ++j) {
            phase[j] = Math.atan2(re[j], im[j]);
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public void setAll(double[][][] vals, double xmin, double xmax, double ymin, double ymax) {
        this.setAll(vals);
        if (this.gridData.isCellData()) {
            this.gridData.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.gridData.setScale(xmin, xmax, ymin, ymax);
        }
    }

    public void setAll(double[][][] vals) {
        this.resizeGrid(vals[0].length, vals[0][0].length);
        double[][] mag = this.gridData.getData()[0];
        double[][] reData = this.gridData.getData()[1];
        double[][] imData = this.gridData.getData()[2];
        int ny = vals[0][0].length;
        int nx = vals[0].length;
        for (int i = 0; i < nx; ++i) {
            System.arraycopy(vals[0][i], 0, reData[i], 0, ny);
            System.arraycopy(vals[1][i], 0, imData[i], 0, ny);
            for (int j = 0; j < ny; ++j) {
                mag[i][j] = Math.sqrt(vals[0][i][j] * vals[0][i][j] + vals[1][i][j] * vals[1][i][j]);
            }
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public void setAll(double[] vals, int nx, double xmin, double xmax, double ymin, double ymax) {
        if (vals.length / 2 % nx != 0) {
            throw new IllegalArgumentException("Number of values in grid (nx*ny) must match number of values.");
        }
        this.resizeGrid(nx, vals.length / nx);
        this.setAll(vals);
        if (this.gridData.isCellData()) {
            this.gridData.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.gridData.setScale(xmin, xmax, ymin, ymax);
        }
    }

    public void setAll(double[] vals) {
        int ny;
        if (this.gridData == null) {
            throw new IllegalArgumentException("Grid size must be set before using row-major format.");
        }
        int nx = this.gridData.getNx();
        if (vals.length != 2 * nx * (ny = this.gridData.getNy())) {
            throw new IllegalArgumentException("Grid does not have the correct size.");
        }
        double[][] mag = this.gridData.getData()[0];
        double[][] reData = this.gridData.getData()[1];
        double[][] imData = this.gridData.getData()[2];
        for (int j = 0; j < ny; ++j) {
            int offset = 2 * j * nx;
            for (int i = 0; i < nx; ++i) {
                double re = vals[offset + 2 * i];
                double im = vals[offset + 2 * i + 1];
                mag[i][j] = Math.sqrt(re * re + im * im);
                reData[i][j] = re;
                imData[i][j] = im;
            }
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public synchronized void showDataTable(boolean show) {
        if (show) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                if (this.gridData == null) {
                    return;
                }
                this.tableFrame = new GridTableFrame(this.gridData);
                this.tableFrame.setTitle("Complex Field Data");
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.tableFrame.refreshTable();
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }

    public double indexToX(int i) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.indexToX(i);
    }

    public int xToIndex(double x) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.xToIndex(x);
    }

    public int yToIndex(double y) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.yToIndex(y);
    }

    public double indexToY(int i) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.indexToY(i);
    }
}

