/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ComplexColorMapper;
import org.opensourcephysics.display2d.ComplexGridPlot;
import org.opensourcephysics.display2d.ComplexInterpolatedPlot;
import org.opensourcephysics.display2d.ComplexSurfacePlot;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.SurfacePlotMouseController;
import org.opensourcephysics.numerics.FFT2D;

public class FFT2DFrame
extends DrawingFrame {
    static final double PI2 = Math.PI * 2;
    public static final int MODE = 0;
    public static final int FREQ = 1;
    public static final int OMEGA = 2;
    public static final int WAVENUMBER = 3;
    public static final int MOMENTUM = 4;
    protected int domainType = 3;
    GridData gridData;
    FFT2D fft;
    double[] fftData;
    Plot2D plot = new ComplexGridPlot(null);
    SurfacePlotMouseController surfacePlotMC;
    JMenuItem gridItem;
    JMenuItem interpolatedItem;
    JMenuItem surfaceItem;

    public FFT2DFrame(String xlabel, String ylabel, String frameTitle) {
        super(new PlottingPanel(xlabel, ylabel, null));
        this.drawingPanel.setPreferredSize(new Dimension(350, 350));
        this.setTitle(frameTitle);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorXGrid(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorYGrid(false);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    public FFT2DFrame(String frameTitle) {
        super(new InteractivePanel());
        this.setTitle(frameTitle);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    protected void addMenuItems() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return;
        }
        JMenu helpMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu menu = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (menu == null) {
            menu = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            menuBar.add(menu);
            menuBar.validate();
        } else {
            menu.addSeparator();
        }
        if (helpMenu != null) {
            menuBar.add(helpMenu);
        }
        ButtonGroup menubarGroup = new ButtonGroup();
        this.gridItem = new JRadioButtonMenuItem("Grid Plot");
        menubarGroup.add(this.gridItem);
        this.gridItem.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FFT2DFrame.this.convertToGridPlot();
            }
        };
        this.gridItem.addActionListener(actionListener);
        menu.add(this.gridItem);
        this.surfaceItem = new JRadioButtonMenuItem("Surface Plot");
        menubarGroup.add(this.surfaceItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FFT2DFrame.this.convertToSurfacePlot();
            }
        };
        this.surfaceItem.addActionListener(actionListener);
        menu.add(this.surfaceItem);
        this.interpolatedItem = new JRadioButtonMenuItem("Interpolated Plot");
        menubarGroup.add(this.interpolatedItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FFT2DFrame.this.convertToInterpolatedPlot();
            }
        };
        this.interpolatedItem.addActionListener(actionListener);
        menu.add(this.interpolatedItem);
        menu.addSeparator();
        JMenuItem phaseItem = new JMenuItem("Phase Legend");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComplexColorMapper.showPhaseLegend();
            }
        };
        phaseItem.addActionListener(actionListener);
        menu.add(phaseItem);
    }

    public void convertToInterpolatedPlot() {
        if (!(this.plot instanceof ComplexInterpolatedPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
            }
            this.drawingPanel.removeDrawable(this.plot);
            this.plot = new ComplexInterpolatedPlot(this.gridData);
            this.drawingPanel.addDrawable(this.plot);
            this.drawingPanel.repaint();
            this.interpolatedItem.setSelected(true);
        }
    }

    public void convertToGridPlot() {
        if (!(this.plot instanceof ComplexGridPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
            }
            this.drawingPanel.removeDrawable(this.plot);
            this.plot = new ComplexGridPlot(this.gridData);
            this.drawingPanel.addDrawable(this.plot);
            this.drawingPanel.invalidateImage();
            this.drawingPanel.repaint();
            this.gridItem.setSelected(true);
        }
    }

    public void convertToSurfacePlot() {
        if (!(this.plot instanceof ComplexSurfacePlot)) {
            this.drawingPanel.removeDrawable(this.plot);
            this.plot = new ComplexSurfacePlot(this.gridData);
            this.drawingPanel.addDrawable(this.plot);
            this.drawingPanel.invalidateImage();
            this.drawingPanel.repaint();
            if (this.surfacePlotMC == null) {
                this.surfacePlotMC = new SurfacePlotMouseController(this.drawingPanel, this.plot);
            }
            this.drawingPanel.addMouseListener(this.surfacePlotMC);
            this.drawingPanel.addMouseMotionListener(this.surfacePlotMC);
            this.surfaceItem.setSelected(true);
        }
    }

    private void resizeGrid(int nx, int ny) {
        this.fftData = new double[2 * nx * ny];
        this.fft = new FFT2D(nx, ny);
        this.gridData = new ArrayData(nx, ny, 3);
        this.plot.setGridData(this.gridData);
        this.plot.update();
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void setDomainType(int type) {
        this.domainType = type;
        switch (this.domainType) {
            case 0: {
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).setXLabel("x mode");
                }
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setYLabel("y mode");
                break;
            }
            case 1: {
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).setXLabel("x frequency");
                }
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setYLabel("y frequency");
                break;
            }
            case 2: {
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).setXLabel("x omega");
                }
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setYLabel("y omega");
                break;
            }
            case 3: {
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).setXLabel("k_x");
                }
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setYLabel("k_y");
                break;
            }
            case 4: {
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).setXLabel("p_x");
                }
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setYLabel("p_y");
            }
        }
    }

    public void doFFT(double[][][] data, double xmin, double xmax, double ymin, double ymax) {
        if (this.gridData == null) {
            throw new IllegalStateException("Grid must be set before using row-major format.");
        }
        int nx = this.gridData.getNx();
        int ny = this.gridData.getNy();
        if (data[0].length != nx || data[0][0].length != ny) {
            throw new IllegalArgumentException("Grid does not have the correct size.");
        }
        double[][] reData = data[0];
        double[][] imData = data[1];
        int offX = (int)((double)nx * xmin / (xmax - xmin));
        offX = Math.abs(offX);
        int offY = (int)((double)ny * ymin / (ymax - ymin));
        offY = Math.abs(offY);
        for (int i = 0; i < nx; ++i) {
            int ii = (offX + i) % nx;
            int offset = 2 * ii * nx;
            for (int j = 0; j < ny; ++j) {
                int jj = (offX + j) % ny;
                this.fftData[offset + 2 * jj] = reData[i][j];
                this.fftData[offset + 2 * jj + 1] = imData[i][j];
            }
        }
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        double a1 = -nx / 2;
        double a2 = (nx + 1) / 2 - 1;
        double b1 = -ny / 2;
        double b2 = (ny + 1) / 2 - 1;
        switch (this.domainType) {
            case 0: {
                break;
            }
            case 1: {
                a2 = this.fft.getFreqMax(xmin, xmax, nx);
                a1 = this.fft.getFreqMin(xmin, xmax, nx);
                b2 = this.fft.getFreqMax(ymin, ymax, ny);
                b1 = this.fft.getFreqMin(ymin, ymax, ny);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                a2 = Math.PI * 2 * this.fft.getFreqMax(xmin, xmax, nx);
                a1 = Math.PI * 2 * this.fft.getFreqMin(xmin, xmax, nx);
                b2 = Math.PI * 2 * this.fft.getFreqMax(ymin, ymax, ny);
                b1 = Math.PI * 2 * this.fft.getFreqMin(ymin, ymax, ny);
            }
        }
        this.gridData.setCenteredCellScale(a1, a2, b2, b1);
        this.fillGrid(nx, ny, this.fftData);
        this.plot.update();
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void doFFT(double[] data, int nx, double xmin, double xmax, double ymin, double ymax) throws IllegalArgumentException {
        if (data.length / 2 % nx != 0) {
            throw new IllegalArgumentException("Number of values in grid (nx*ny) must match number of values.");
        }
        int ny = data.length / nx / 2;
        this.resizeGrid(nx, ny);
        if (data.length != 2 * nx * ny) {
            throw new IllegalArgumentException("Grid does not have the correct size.");
        }
        int offX = (int)((double)nx * xmin / (xmax - xmin));
        offX = Math.abs(offX);
        int offY = (int)((double)ny * ymin / (ymax - ymin));
        offY = Math.abs(offY);
        for (int j = 0; j < ny; ++j) {
            int jj = (offY + j) % ny;
            int offset = 2 * j * nx;
            int offset2 = 2 * jj * nx;
            for (int i = 0; i < nx; ++i) {
                int ii = (offX + i) % nx;
                this.fftData[offset + 2 * ii] = data[offset2 + 2 * i];
                this.fftData[offset + 2 * ii + 1] = data[offset2 + 2 * i + 1];
            }
        }
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        double a1 = -nx / 2;
        double a2 = (nx + 1) / 2 - 1;
        double b1 = -ny / 2;
        double b2 = (ny + 1) / 2 - 1;
        switch (this.domainType) {
            case 0: {
                break;
            }
            case 1: {
                a2 = this.fft.getFreqMax(xmin, xmax, nx);
                a1 = this.fft.getFreqMin(xmin, xmax, nx);
                b2 = this.fft.getFreqMax(ymin, ymax, ny);
                b1 = this.fft.getFreqMin(ymin, ymax, ny);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                a2 = Math.PI * 2 * this.fft.getFreqMax(xmin, xmax, nx);
                a1 = Math.PI * 2 * this.fft.getFreqMin(xmin, xmax, nx);
                b2 = Math.PI * 2 * this.fft.getFreqMax(ymin, ymax, ny);
                b1 = Math.PI * 2 * this.fft.getFreqMin(ymin, ymax, ny);
            }
        }
        this.gridData.setCenteredCellScale(a1, a2, b2, b1);
        this.fillGrid(nx, ny, this.fftData);
        this.plot.update();
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.plot);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList list = super.getDrawables();
        ((AbstractCollection)list).remove(this.plot);
        return list;
    }

    public synchronized ArrayList getDrawables(Class c) {
        ArrayList list = super.getDrawables(c);
        ((AbstractCollection)list).remove(this.plot);
        return list;
    }

    private void fillGrid(int nx, int ny, double[] vals) {
        double[][] mag = this.gridData.getData()[0];
        double[][] reData = this.gridData.getData()[1];
        double[][] imData = this.gridData.getData()[2];
        for (int j = 0; j < ny; ++j) {
            int offset = 2 * j * nx;
            for (int i = 0; i < nx; ++i) {
                double re = vals[offset + 2 * i];
                double im = vals[offset + 2 * i + 1];
                mag[i][j] = Math.sqrt(re * re + im * im);
                reData[i][j] = re;
                imData[i][j] = im;
            }
        }
    }
}

