/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.display.ComplexDataset;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.numerics.FFT;
import org.opensourcephysics.numerics.Function;

public class FFTFrame
extends DrawingFrame {
    public static final int MODE = 0;
    public static final int FREQ = 1;
    public static final int OMEGA = 2;
    public static final int WAVENUMBER = 3;
    public static final int MOMENTUM = 4;
    protected int domainType = 1;
    protected ComplexDataset complexDataset = new ComplexDataset();
    protected DataTable dataTable = new DataTable();
    protected DataTableFrame tableFrame;
    private double[] fftData = new double[1];
    private FFT fft = new FFT(1);
    JMenuItem ampPhaseItem;
    JMenuItem postItem;
    JMenuItem barItem;

    public FFTFrame(String xlabel, String ylabel, String title) {
        super(new PlottingPanel(xlabel, ylabel, null));
        this.complexDataset.setMarkerShape(4);
        this.complexDataset.setXYColumnNames(xlabel, "re", "im");
        this.drawingPanel.addDrawable(this.complexDataset);
        this.setTitle(title);
        this.dataTable.add(this.complexDataset);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    protected void addMenuItems() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return;
        }
        JMenu helpMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu menu = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (menu == null) {
            menu = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            menuBar.add(menu);
            menuBar.validate();
        } else {
            menu.addSeparator();
        }
        if (helpMenu != null) {
            menuBar.add(helpMenu);
        }
        ButtonGroup menubarGroup = new ButtonGroup();
        this.postItem = new JRadioButtonMenuItem("Post View");
        menubarGroup.add(this.postItem);
        this.postItem.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FFTFrame.this.convertToPostView();
            }
        };
        this.postItem.addActionListener(actionListener);
        menu.add(this.postItem);
        this.barItem = new JRadioButtonMenuItem("Bar View");
        menubarGroup.add(this.barItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FFTFrame.this.convertToPhaseBarView();
            }
        };
        this.barItem.addActionListener(actionListener);
        menu.add(this.barItem);
        this.ampPhaseItem = new JRadioButtonMenuItem("Amp & Phase");
        menubarGroup.add(this.ampPhaseItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FFTFrame.this.convertToAmpAndPhaseView();
            }
        };
        this.ampPhaseItem.addActionListener(actionListener);
        menu.add(this.ampPhaseItem);
        menu.addSeparator();
        JMenuItem tableItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        tableItem.setAccelerator(KeyStroke.getKeyStroke(84, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        ActionListener tableListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FFTFrame.this.showDataTable(true);
            }
        };
        tableItem.addActionListener(tableListener);
        menu.add(tableItem);
        JMenuItem item = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        item.addActionListener(tableListener);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            this.drawingPanel.getPopupMenu().add(item);
        }
        menu.addSeparator();
        tableItem = new JMenuItem("Phase Legend");
        tableListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FFTFrame.this.complexDataset.showLegend();
            }
        };
        tableItem.addActionListener(tableListener);
        menu.add(tableItem);
    }

    public void setXYColumnNames(String xlabel, String reLabel, String imLabel) {
        this.complexDataset.setXYColumnNames(xlabel, reLabel, imLabel);
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setXLabel(xlabel);
        }
    }

    public void setDomainType(int type) {
        this.domainType = type;
        switch (this.domainType) {
            case 0: {
                this.complexDataset.setXYColumnNames("mode", "re", "im");
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setXLabel("mode");
                break;
            }
            case 1: {
                this.complexDataset.setXYColumnNames("f", "re", "im");
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setXLabel("frequency");
                break;
            }
            case 2: {
                this.complexDataset.setXYColumnNames("omega", "re", "im");
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setXLabel("omega");
                break;
            }
            case 3: {
                this.complexDataset.setXYColumnNames("k", "re", "im");
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setXLabel("wavenumber");
                break;
            }
            case 4: {
                this.complexDataset.setXYColumnNames("p", "re", "im");
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setXLabel("momentum");
            }
        }
    }

    public void convertToPostView() {
        this.complexDataset.setMarkerShape(4);
        this.drawingPanel.invalidateImage();
        this.postItem.setSelected(true);
        this.drawingPanel.repaint();
    }

    public void convertToAmpAndPhaseView() {
        this.complexDataset.setMarkerShape(2);
        this.ampPhaseItem.setSelected(true);
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void convertToPhaseBarView() {
        this.complexDataset.setMarkerShape(3);
        this.barItem.setSelected(true);
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void doFFT(Function reF, Function imF, double xmin, double xmax, int n) {
        if (2 * n != this.fftData.length) {
            this.fftData = new double[2 * n];
            this.fft = new FFT(n);
        }
        int off = (int)((double)n * xmin / (xmax - xmin));
        off = Math.abs(off);
        double xi = xmin;
        double dx = (xmax - xmin) / (double)n;
        for (int i = 0; i < n; ++i) {
            int ii = (off + i) % n;
            this.fftData[2 * ii] = reF == null ? 0.0 : reF.evaluate(xi);
            this.fftData[2 * ii + 1] = imF == null ? 0.0 : imF.evaluate(xi);
            xi += dx;
        }
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        double[] domain = null;
        switch (this.domainType) {
            case 0: {
                domain = this.fft.getNaturalModes();
                break;
            }
            case 1: {
                domain = this.fft.getNaturalFreq(xmin, xmax);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                domain = this.fft.getNaturalOmega(xmin, xmax);
            }
        }
        this.complexDataset.clear();
        this.complexDataset.append(domain, this.fftData);
    }

    public void doRealFFT(double[] data, double xmin, double xmax) {
        int n = this.fft.getN();
        if (2 * data.length != this.fftData.length) {
            n = data.length;
            this.fftData = new double[2 * n];
            this.fft = new FFT(n);
        }
        int off = (int)((double)n * xmin / (xmax - xmin));
        off = Math.abs(off);
        for (int i = 0; i < n; ++i) {
            int ii = (off + i) % n;
            this.fftData[2 * ii] = data[i];
            this.fftData[2 * ii + 1] = 0.0;
        }
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        double[] domain = null;
        switch (this.domainType) {
            case 0: {
                domain = this.fft.getNaturalModes();
                break;
            }
            case 1: {
                domain = this.fft.getNaturalFreq(xmin, xmax);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                domain = this.fft.getNaturalOmega(xmin, xmax);
            }
        }
        this.complexDataset.clear();
        this.complexDataset.append(domain, this.fftData);
    }

    public void doFFT(double[] data, double xmin, double xmax) {
        int n = this.fft.getN();
        if (data.length != this.fftData.length) {
            this.fftData = new double[data.length];
            n = data.length / 2;
            this.fft = new FFT(n);
        }
        int off = (int)((double)n * xmin / (xmax - xmin));
        off = Math.abs(off);
        for (int i = 0; i < n; ++i) {
            int ii = (off + i) % n;
            this.fftData[2 * ii] = data[2 * i];
            this.fftData[2 * ii + 1] = data[2 * i + 1];
        }
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        double[] domain = null;
        switch (this.domainType) {
            case 0: {
                domain = this.fft.getNaturalModes();
                break;
            }
            case 1: {
                domain = this.fft.getNaturalFreq(xmin, xmax);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                domain = this.fft.getNaturalOmega(xmin, xmax);
            }
        }
        this.complexDataset.clear();
        this.complexDataset.append(domain, this.fftData);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList list = super.getDrawables();
        ((AbstractCollection)list).remove(this.complexDataset);
        return list;
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.complexDataset);
        this.showDataTable(false);
    }

    public synchronized ArrayList getDrawables(Class c) {
        ArrayList list = super.getDrawables(c);
        ((AbstractCollection)list).remove(this.complexDataset);
        return list;
    }

    public void clearData() {
        this.complexDataset.clear();
        this.dataTable.refreshTable();
        this.drawingPanel.invalidateImage();
    }

    public void setLogScale(boolean xlog, boolean ylog) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setLogScale(xlog, ylog);
        }
    }

    public void showLegend() {
        this.complexDataset.showLegend();
    }

    public synchronized void showDataTable(boolean show) {
        if (show) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                this.tableFrame = new DataTableFrame(this.getTitle() + " Data", this.dataTable);
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.dataTable.refreshTable();
            this.dataTable.sort(0);
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }
}

