/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.Histogram;
import org.opensourcephysics.display.HistogramDataset;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.tools.DatasetTool;

public class HistogramFrame
extends DrawingFrame {
    protected Histogram histogram = new Histogram();
    protected DataTable dataTable = new DataTable();
    protected DataTableFrame tableFrame;
    DatasetTool tool;
    HistogramDataset dataset;
    JCheckBoxMenuItem logItem;
    static /* synthetic */ Class class$org$opensourcephysics$display$Histogram;

    public HistogramFrame(String xlabel, String ylabel, String title) {
        super(new PlottingPanel(xlabel, ylabel, null));
        this.drawingPanel.addDrawable(this.histogram);
        this.setTitle(title);
        this.dataTable.add(this.histogram);
        this.setAnimated(true);
        this.setAutoclear(true);
        this.addMenuItems();
    }

    protected void addMenuItems() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return;
        }
        JMenu helpMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu menu = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (menu == null) {
            menu = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            menuBar.add(menu);
            menuBar.validate();
        } else {
            menu.addSeparator();
        }
        if (helpMenu != null) {
            menuBar.add(helpMenu);
        }
        JMenuItem tableItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        tableItem.setAccelerator(KeyStroke.getKeyStroke(84, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        ActionListener tableListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistogramFrame.this.showDataTable(true);
            }
        };
        tableItem.addActionListener(tableListener);
        menu.add(tableItem);
        menu.addSeparator();
        this.logItem = new JCheckBoxMenuItem("Log Scale", false);
        this.logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistogramFrame.this.histogram.logScale = HistogramFrame.this.logItem.isSelected();
                HistogramFrame.this.drawingPanel.repaint();
            }
        });
        menu.add(this.logItem);
        JMenuItem item = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        item.addActionListener(tableListener);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            this.drawingPanel.getPopupMenu().add(item);
        }
    }

    protected JMenu loadToolsMenu() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        JMenu toolsMenu = new JMenu("Tools");
        menuBar.add(toolsMenu);
        JMenuItem datasetItem = new JMenuItem("Dataset Tool");
        toolsMenu.add(datasetItem);
        datasetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double[][] data = HistogramFrame.this.histogram.logScale ? HistogramFrame.this.getLogPoints() : HistogramFrame.this.getPoints();
                double[] bins = data[0];
                double[] vals = data[1];
                double start = bins[0] - HistogramFrame.this.histogram.getBinWidth() / 2.0;
                double stop = bins[bins.length - 1] + HistogramFrame.this.histogram.getBinWidth() / 2.0;
                if (HistogramFrame.this.tool == null || !HistogramFrame.this.tool.isDisplayable()) {
                    HistogramFrame.this.dataset = new HistogramDataset(start, stop, HistogramFrame.this.histogram.getBinWidth());
                    HistogramFrame.this.dataset.append(bins, vals);
                    HistogramFrame.this.tool = new DatasetTool(HistogramFrame.this.dataset);
                } else {
                    HistogramFrame.this.dataset.clear();
                    HistogramFrame.this.dataset.setBinWidth(start, stop, HistogramFrame.this.histogram.getBinWidth());
                    HistogramFrame.this.dataset.append(bins, vals);
                    HistogramFrame.this.tool.updateData(HistogramFrame.this.dataset);
                }
                HistogramFrame.this.tool.setVisible(true);
            }
        });
        return toolsMenu;
    }

    public double[] getXPoints() {
        return this.histogram.getXPoints();
    }

    public double[] getYPoints() {
        return this.histogram.getYPoints();
    }

    public double[][] getLogPoints() {
        return this.histogram.getLogPoints();
    }

    public double[][] getPoints() {
        return this.histogram.getPoints();
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.histogram);
        this.showDataTable(false);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList list = super.getDrawables();
        ((AbstractCollection)list).remove(this.histogram);
        return list;
    }

    public synchronized ArrayList getDrawables(Class c) {
        ArrayList list = super.getDrawables(c);
        ((AbstractCollection)list).remove(this.histogram);
        return list;
    }

    public void clearData() {
        this.histogram.clear();
        this.dataTable.refreshTable();
        this.drawingPanel.invalidateImage();
    }

    public void append(double v) {
        this.histogram.append(v);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(double value, double numberOfOccurences) {
        this.histogram.append(value, numberOfOccurences);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(double[] values) {
        this.histogram.append(values);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void setLogScale(boolean b) {
        this.histogram.logScale = b;
        this.logItem.setSelected(b);
    }

    public boolean isLogScale() {
        return this.histogram.logScale;
    }

    public void setBinWidth(double binWidth) {
        this.histogram.setBinWidth(binWidth);
    }

    public double getBinWidth() {
        return this.histogram.getBinWidth();
    }

    public void setBinStyle(short style) {
        this.histogram.setBinStyle(style);
    }

    public void setBinOffset(double binOffset) {
        this.histogram.setBinOffset(binOffset);
    }

    public void setNormalizedToOne(boolean b) {
        this.histogram.setNormalizedToOne(b);
        this.histogram.adjustForWidth = b;
    }

    public void positiveX() {
        boolean b = this.drawingPanel.isAutoscaleX();
        this.drawingPanel.setPreferredMinMaxX(0.0, this.drawingPanel.getPreferredXMax());
        this.drawingPanel.setAutoscaleX(b);
    }

    public synchronized void showDataTable(boolean show) {
        if (show) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                this.tableFrame = new DataTableFrame(this.getTitle() + " Data", this.dataTable);
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.dataTable.refreshTable();
            this.dataTable.sort(0);
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new HistogramFrameLoader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class HistogramFrameLoader
    extends DrawingFrame.DrawingFrameLoader {
        protected HistogramFrameLoader() {
        }

        public Object createObject(XMLControl control) {
            HistogramFrame frame = new HistogramFrame("x", "y", "Histogram Frame");
            return frame;
        }

        public Object loadObject(XMLControl control, Object obj) {
            super.loadObject(control, obj);
            HistogramFrame frame = (HistogramFrame)obj;
            ArrayList list = frame.getObjectOfClass(class$org$opensourcephysics$display$Histogram == null ? (class$org$opensourcephysics$display$Histogram = HistogramFrame.class$("org.opensourcephysics.display.Histogram")) : class$org$opensourcephysics$display$Histogram);
            if (list.size() > 0) {
                frame.histogram = (Histogram)list.get(0);
                frame.histogram.clear();
                frame.dataTable.add(frame.histogram);
            }
            return obj;
        }
    }
}

