/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveCircle;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.PlottingPanel;

public class ParticleFrame
extends DrawingFrame {
    ArrayList partlist = new ArrayList();

    public ParticleFrame(String xlabel, String ylabel, String frameTitle) {
        super(new PlottingPanel(xlabel, ylabel, null));
        this.setTitle(frameTitle);
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    protected Particles checkIndex(int index) {
        while (index >= this.partlist.size()) {
            Particles p = new Particles();
            this.partlist.add(p);
            ((InteractiveCircle)p.shape).color = DatasetManager.getLineColor(this.partlist.indexOf(p));
            this.addDrawable(p);
        }
        return (Particles)this.partlist.get(index);
    }

    public void addParticle(int i, Point2D point) {
        this.checkIndex(i).addParticle(point);
    }

    public void addParicle(int i, Point2D[] points) {
        this.checkIndex(i).addParticles(points);
    }

    public void setDrawingShape(int i, Interactive shape) {
        this.checkIndex((int)i).shape = shape;
    }

    public void clearDrawables() {
        this.clearData();
        this.drawingPanel.clear();
    }

    public void clearData() {
        Iterator it = ((AbstractList)this.partlist).iterator();
        while (it.hasNext()) {
            Particles p = (Particles)it.next();
            p.clear();
            this.drawingPanel.removeDrawable(p);
        }
        this.partlist.clear();
        this.drawingPanel.invalidateImage();
    }

    class Particles
    implements Drawable,
    Measurable {
        Interactive shape = new InteractiveCircle();
        private ArrayList pointList = new ArrayList();
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;

        Particles() {
            this.shape.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addParticle(Point2D point) {
            ArrayList arrayList = this.pointList;
            synchronized (arrayList) {
                this.xmax = Math.max(this.xmax, point.getX());
                this.xmin = Math.min(this.xmin, point.getX());
                this.ymax = Math.max(this.ymax, point.getY());
                this.ymin = Math.min(this.ymin, point.getY());
                this.pointList.add(point);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addParticles(Point2D[] points) {
            int n = points.length;
            for (int i = 0; i < n; ++i) {
                this.xmax = Math.max(this.xmax, points[i].getX());
                this.xmin = Math.min(this.xmin, points[i].getX());
                this.ymax = Math.max(this.ymax, points[i].getY());
                this.ymin = Math.min(this.ymin, points[i].getY());
            }
            ArrayList arrayList = this.pointList;
            synchronized (arrayList) {
                this.pointList.add(points);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            ArrayList arrayList = this.pointList;
            synchronized (arrayList) {
                this.pointList.clear();
                this.xmin = Double.MAX_VALUE;
                this.xmax = -1.7976931348623157E308;
                this.ymin = Double.MAX_VALUE;
                this.ymax = -1.7976931348623157E308;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(DrawingPanel panel, Graphics g) {
            ArrayList arrayList = this.pointList;
            synchronized (arrayList) {
                Iterator it = ((AbstractList)this.pointList).iterator();
                while (it.hasNext()) {
                    Point2D point = (Point2D)it.next();
                    this.shape.setXY(point.getX(), point.getY());
                    this.shape.draw(panel, g);
                }
            }
        }

        public double getXMax() {
            return this.xmax;
        }

        public double getXMin() {
            return this.xmin;
        }

        public double getYMax() {
            return this.ymax;
        }

        public double getYMin() {
            return this.ymin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isMeasured() {
            ArrayList arrayList = this.pointList;
            synchronized (arrayList) {
                return this.pointList.size() > 0;
            }
        }
    }
}

