/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ContourPlot;
import org.opensourcephysics.display2d.GrayscalePlot;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPlot;
import org.opensourcephysics.display2d.GridTableFrame;
import org.opensourcephysics.display2d.InterpolatedPlot;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.SurfacePlot;
import org.opensourcephysics.display2d.SurfacePlotMouseController;

public class Scalar2DFrame
extends DrawingFrame {
    String plotType = "";
    int paletteType = 0;
    GridData gridData;
    Plot2D plot = new GridPlot(null);
    SurfacePlotMouseController surfacePlotMC;
    JMenuItem surfaceItem;
    JMenuItem contourItem;
    JMenuItem gridItem;
    JMenuItem interpolatedItem;
    JMenuItem grayscaleItem;
    GridTableFrame tableFrame;
    int[] gutters;

    public Scalar2DFrame(String xlabel, String ylabel, String frameTitle) {
        super(new PlottingPanel(xlabel, ylabel, null));
        this.drawingPanel.setPreferredSize(new Dimension(350, 350));
        this.setTitle(frameTitle);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorXGrid(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorYGrid(false);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
        this.gutters = this.drawingPanel.getGutters();
    }

    public Scalar2DFrame(String frameTitle) {
        super(new InteractivePanel());
        this.setTitle(frameTitle);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
        this.gutters = this.drawingPanel.getGutters();
    }

    public double indexToX(int i) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.indexToX(i);
    }

    public int xToIndex(double x) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.xToIndex(x);
    }

    public int yToIndex(double y) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.yToIndex(y);
    }

    public double indexToY(int i) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.indexToY(i);
    }

    public int getNx() {
        if (this.gridData == null) {
            return 0;
        }
        return this.gridData.getNx();
    }

    public int getNy() {
        if (this.gridData == null) {
            return 0;
        }
        return this.gridData.getNy();
    }

    public void setZRange(boolean isAutoscale, double floor, double ceil) {
        this.plot.setAutoscaleZ(isAutoscale, floor, ceil);
    }

    public void setPaletteType(int type) {
        this.paletteType = type;
        this.plot.setPaletteType(type);
    }

    protected void addMenuItems() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return;
        }
        JMenu helpMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu menu = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (menu == null) {
            menu = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            menuBar.add(menu);
            menuBar.validate();
        } else {
            menu.addSeparator();
        }
        if (helpMenu != null) {
            menuBar.add(helpMenu);
        }
        ButtonGroup menubarGroup = new ButtonGroup();
        this.gridItem = new JRadioButtonMenuItem("Grid Plot");
        menubarGroup.add(this.gridItem);
        this.gridItem.setSelected(true);
        ActionListener tableListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scalar2DFrame.this.convertToGridPlot();
            }
        };
        this.gridItem.addActionListener(tableListener);
        menu.add(this.gridItem);
        this.contourItem = new JRadioButtonMenuItem("Contour Plot");
        menubarGroup.add(this.contourItem);
        tableListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scalar2DFrame.this.convertToContourPlot();
            }
        };
        this.contourItem.addActionListener(tableListener);
        menu.add(this.contourItem);
        this.surfaceItem = new JRadioButtonMenuItem("Surface Plot");
        menubarGroup.add(this.surfaceItem);
        tableListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scalar2DFrame.this.convertToSurfacePlot();
            }
        };
        this.surfaceItem.addActionListener(tableListener);
        menu.add(this.surfaceItem);
        this.interpolatedItem = new JRadioButtonMenuItem("Interpolated Plot");
        menubarGroup.add(this.interpolatedItem);
        tableListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scalar2DFrame.this.convertToInterpolatedPlot();
            }
        };
        this.interpolatedItem.addActionListener(tableListener);
        menu.add(this.interpolatedItem);
        this.grayscaleItem = new JRadioButtonMenuItem("Grayscale Plot");
        menubarGroup.add(this.grayscaleItem);
        tableListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scalar2DFrame.this.convertToGrayscalePlot();
            }
        };
        this.grayscaleItem.addActionListener(tableListener);
        menu.add(this.grayscaleItem);
        menu.addSeparator();
        JMenuItem tableItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        tableItem.setAccelerator(KeyStroke.getKeyStroke(84, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scalar2DFrame.this.showDataTable(true);
            }
        };
        tableItem.addActionListener(actionListener);
        menu.add(tableItem);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            JMenuItem item = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
            item.addActionListener(actionListener);
            this.drawingPanel.getPopupMenu().add(item);
        }
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.plot);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList list = super.getDrawables();
        ((AbstractCollection)list).remove(this.plot);
        return list;
    }

    public synchronized ArrayList getDrawables(Class c) {
        ArrayList list = super.getDrawables(c);
        ((AbstractCollection)list).remove(this.plot);
        return list;
    }

    public void clearData() {
        if (this.gridData != null) {
            this.setAll(new double[this.gridData.getNx()][this.gridData.getNy()]);
        }
        this.drawingPanel.invalidateImage();
    }

    public void setPlotType(String type) {
        this.plotType = type;
        if (type.toLowerCase().equals("contour")) {
            this.convertToContourPlot();
            this.surfaceItem.setEnabled(false);
            this.contourItem.setEnabled(true);
            this.gridItem.setEnabled(false);
            this.interpolatedItem.setEnabled(false);
            this.grayscaleItem.setEnabled(false);
        } else if (type.toLowerCase().equals("grayscale")) {
            this.convertToGrayscalePlot();
            this.surfaceItem.setEnabled(false);
            this.contourItem.setEnabled(false);
            this.gridItem.setEnabled(false);
            this.interpolatedItem.setEnabled(false);
            this.grayscaleItem.setEnabled(true);
        } else if (type.toLowerCase().equals("grid")) {
            this.convertToGridPlot();
            this.surfaceItem.setEnabled(false);
            this.contourItem.setEnabled(false);
            this.gridItem.setEnabled(true);
            this.interpolatedItem.setEnabled(false);
            this.grayscaleItem.setEnabled(false);
        } else if (type.toLowerCase().equals("interpolated")) {
            this.convertToInterpolatedPlot();
            this.surfaceItem.setEnabled(false);
            this.contourItem.setEnabled(false);
            this.gridItem.setEnabled(false);
            this.interpolatedItem.setEnabled(true);
            this.grayscaleItem.setEnabled(false);
        } else if (type.toLowerCase().equals("surface")) {
            this.convertToSurfacePlot();
            this.surfaceItem.setEnabled(true);
            this.contourItem.setEnabled(false);
            this.gridItem.setEnabled(false);
            this.interpolatedItem.setEnabled(false);
            this.grayscaleItem.setEnabled(false);
        } else {
            this.plotType = "";
            this.surfaceItem.setEnabled(true);
            this.contourItem.setEnabled(true);
            this.gridItem.setEnabled(true);
            this.interpolatedItem.setEnabled(true);
            this.grayscaleItem.setEnabled(true);
        }
    }

    public void convertToContourPlot() {
        if (!(this.plot instanceof ContourPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
                this.drawingPanel.setGutters(this.gutters);
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).getAxes().setVisible(true);
                }
                this.drawingPanel.setShowCoordinates(true);
            }
            boolean isAutoscaleZ = this.plot.isAutoscaleZ();
            double floor = this.plot.getFloor();
            double ceil = this.plot.getCeiling();
            Plot2D oldPlot = this.plot;
            this.plot = new ContourPlot(this.gridData);
            this.plot.setPaletteType(this.paletteType);
            this.plot.setAutoscaleZ(isAutoscaleZ, floor, ceil);
            this.drawingPanel.replaceDrawable(oldPlot, this.plot);
            this.plot.update();
            if (this.tableFrame != null && this.tableFrame.isShowing()) {
                this.tableFrame.refreshTable();
            }
            this.drawingPanel.repaint();
            this.contourItem.setSelected(true);
        }
    }

    public void convertToInterpolatedPlot() {
        if (!(this.plot instanceof InterpolatedPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
                this.drawingPanel.setGutters(this.gutters);
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).getAxes().setVisible(true);
                }
                this.drawingPanel.setShowCoordinates(true);
            }
            boolean isAutoscaleZ = this.plot.isAutoscaleZ();
            double floor = this.plot.getFloor();
            double ceil = this.plot.getCeiling();
            Plot2D oldPlot = this.plot;
            this.plot = new InterpolatedPlot(this.gridData);
            this.plot.setPaletteType(this.paletteType);
            this.plot.setAutoscaleZ(isAutoscaleZ, floor, ceil);
            this.drawingPanel.replaceDrawable(oldPlot, this.plot);
            this.plot.update();
            if (this.tableFrame != null && this.tableFrame.isShowing()) {
                this.tableFrame.refreshTable();
            }
            this.drawingPanel.repaint();
            this.interpolatedItem.setSelected(true);
        }
    }

    public void convertToGridPlot() {
        if (!(this.plot instanceof GridPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
                this.drawingPanel.setGutters(this.gutters);
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).getAxes().setVisible(true);
                }
                this.drawingPanel.setShowCoordinates(true);
            }
            boolean isAutoscaleZ = this.plot.isAutoscaleZ();
            double floor = this.plot.getFloor();
            double ceil = this.plot.getCeiling();
            Plot2D oldPlot = this.plot;
            this.plot = new GridPlot(this.gridData);
            this.plot.setPaletteType(this.paletteType);
            this.plot.setAutoscaleZ(isAutoscaleZ, floor, ceil);
            this.drawingPanel.replaceDrawable(oldPlot, this.plot);
            this.plot.update();
            if (this.tableFrame != null && this.tableFrame.isShowing()) {
                this.tableFrame.refreshTable();
            }
            this.drawingPanel.repaint();
            this.gridItem.setSelected(true);
        }
    }

    public void convertToGrayscalePlot() {
        if (!(this.plot instanceof GrayscalePlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
                this.drawingPanel.setGutters(this.gutters);
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).getAxes().setVisible(true);
                }
                this.drawingPanel.setShowCoordinates(true);
            }
            boolean isAutoscaleZ = this.plot.isAutoscaleZ();
            double floor = this.plot.getFloor();
            double ceil = this.plot.getCeiling();
            Plot2D oldPlot = this.plot;
            this.plot = new GrayscalePlot(this.gridData);
            this.plot.setPaletteType(this.paletteType);
            this.plot.setAutoscaleZ(isAutoscaleZ, floor, ceil);
            this.drawingPanel.replaceDrawable(oldPlot, this.plot);
            this.plot.update();
            if (this.tableFrame != null && this.tableFrame.isShowing()) {
                this.tableFrame.refreshTable();
            }
            this.drawingPanel.repaint();
            this.grayscaleItem.setSelected(true);
        }
    }

    public void convertToSurfacePlot() {
        if (!(this.plot instanceof SurfacePlot)) {
            Plot2D oldPlot = this.plot;
            try {
                SurfacePlot newPlot = new SurfacePlot(this.gridData);
                this.plot = newPlot;
            }
            catch (IllegalArgumentException ex) {
                this.surfaceItem.setEnabled(false);
                this.gridItem.setSelected(true);
                this.convertToGridPlot();
                return;
            }
            this.gutters = this.drawingPanel.getGutters();
            if (this.drawingPanel instanceof PlottingPanel) {
                ((PlottingPanel)this.drawingPanel).getAxes().setVisible(false);
            }
            this.drawingPanel.setShowCoordinates(false);
            this.drawingPanel.setGutters(0, 0, 0, 0);
            boolean isAutoscaleZ = oldPlot.isAutoscaleZ();
            double floor = oldPlot.getFloor();
            double ceil = oldPlot.getCeiling();
            this.plot.setPaletteType(this.paletteType);
            this.plot.setAutoscaleZ(isAutoscaleZ, floor, ceil);
            this.drawingPanel.replaceDrawable(oldPlot, this.plot);
            this.plot.update();
            if (this.tableFrame != null && this.tableFrame.isShowing()) {
                this.tableFrame.refreshTable();
            }
            this.drawingPanel.repaint();
            if (this.surfacePlotMC == null) {
                this.surfacePlotMC = new SurfacePlotMouseController(this.drawingPanel, this.plot);
            }
            this.drawingPanel.addMouseListener(this.surfacePlotMC);
            this.drawingPanel.addMouseMotionListener(this.surfacePlotMC);
            this.surfaceItem.setSelected(true);
        }
    }

    public void resizeGrid(int nx, int ny) {
        double ymax;
        double ymin;
        double xmax;
        double xmin;
        boolean cellScale = false;
        if (this.gridData == null) {
            xmin = this.drawingPanel.getPreferredXMin();
            xmax = this.drawingPanel.getPreferredXMax();
            ymin = this.drawingPanel.getPreferredYMin();
            ymax = this.drawingPanel.getPreferredYMax();
        } else {
            xmin = this.gridData.getLeft();
            xmax = this.gridData.getRight();
            ymin = this.gridData.getBottom();
            ymax = this.gridData.getTop();
            cellScale = this.gridData.isCellData();
        }
        this.gridData = new ArrayData(nx, ny, 1);
        this.gridData.setComponentName(0, "Amp");
        if (nx != ny) {
            this.surfaceItem.setEnabled(false);
            if (this.plot instanceof SurfacePlot) {
                this.convertToGridPlot();
            }
        } else if (this.plotType.equals("")) {
            this.surfaceItem.setEnabled(true);
        }
        if (cellScale) {
            this.gridData.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.gridData.setScale(xmin, xmax, ymin, ymax);
        }
        this.plot.setGridData(this.gridData);
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void setRow(int row, double[] vals) throws IllegalArgumentException {
        if (this.gridData.getNx() != vals.length) {
            throw new IllegalArgumentException("Row data length does not match grid size.");
        }
        double[] rowData = this.gridData.getData()[0][row];
        System.arraycopy(vals, 0, rowData, 0, vals.length);
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public void setAll(double[][] vals, double xmin, double xmax, double ymin, double ymax) {
        this.setAll(vals);
        if (this.gridData.isCellData()) {
            this.gridData.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.gridData.setScale(xmin, xmax, ymin, ymax);
        }
    }

    public void setAll(double[][] vals) {
        if (this.gridData == null || this.gridData.getNx() != vals.length || this.gridData.getNy() != vals[0].length) {
            this.resizeGrid(vals.length, vals[0].length);
        }
        double[][] data = this.gridData.getData()[0];
        int ny = vals[0].length;
        int nx = data.length;
        for (int i = 0; i < nx; ++i) {
            System.arraycopy(vals[i], 0, data[i], 0, ny);
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public void setAll(double[] vals) {
        int ny;
        if (this.gridData == null) {
            throw new IllegalArgumentException("Grid size must be set before using row-major format.");
        }
        int nx = this.gridData.getNx();
        if (vals.length != nx * (ny = this.gridData.getNy())) {
            throw new IllegalArgumentException("Grid does not have the correct size.");
        }
        double[][] mag = this.gridData.getData()[0];
        for (int j = 0; j < ny; ++j) {
            int offset = j * nx;
            for (int i = 0; i < nx; ++i) {
                mag[i][j] = vals[offset + i];
            }
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public synchronized void showDataTable(boolean show) {
        if (show) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                if (this.gridData == null) {
                    return;
                }
                this.tableFrame = new GridTableFrame(this.gridData);
                this.tableFrame.setTitle("Scalar Field Data");
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.tableFrame.refreshTable();
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }
}

