/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Fehlberg8;
import org.opensourcephysics.numerics.ODE;

public class Adams6
extends Fehlberg8 {
    private double[] fn;
    private double[] fn1;
    private double[] fn2;
    private double[] fn3;
    private double[] fn4;
    private double[] fn5;
    private double[] temp_state;
    private double[] temp_rate;
    private int counter = 0;

    public Adams6(ODE ode) {
        super(ode);
    }

    public void initialize(double stepSize) {
        super.initialize(stepSize);
        this.fn = new double[this.numEqn];
        this.fn1 = new double[this.numEqn];
        this.fn2 = new double[this.numEqn];
        this.fn3 = new double[this.numEqn];
        this.fn4 = new double[this.numEqn];
        this.fn5 = new double[this.numEqn];
        this.temp_state = new double[this.numEqn];
        this.temp_rate = new double[this.numEqn];
        this.counter = 0;
    }

    public double step() {
        double[] state = this.ode.getState();
        if (state == null) {
            return this.stepSize;
        }
        if (state.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.ode.getRate(state, this.fn);
        if (this.counter < 5) {
            this.stepSize = super.step();
            ++this.counter;
        } else {
            int i;
            for (i = 0; i < this.numEqn; ++i) {
                this.temp_state[i] = state[i] + this.stepSize * (4277.0 * this.fn[i] - 7923.0 * this.fn1[i] + 9982.0 * this.fn2[i] - 7298.0 * this.fn3[i] + 2877.0 * this.fn4[i] - 475.0 * this.fn5[i]) / 720.0;
            }
            this.ode.getRate(this.temp_state, this.temp_rate);
            for (i = 0; i < this.numEqn; ++i) {
                state[i] = state[i] + this.stepSize * (475.0 * this.temp_rate[i] + 1427.0 * this.fn[i] - 798.0 * this.fn1[i] + 482.0 * this.fn2[i] - 173.0 * this.fn3[i] + 27.0 * this.fn4[i]) / 1440.0;
            }
        }
        System.arraycopy(this.fn4, 0, this.fn5, 0, this.numEqn);
        System.arraycopy(this.fn3, 0, this.fn4, 0, this.numEqn);
        System.arraycopy(this.fn2, 0, this.fn3, 0, this.numEqn);
        System.arraycopy(this.fn1, 0, this.fn2, 0, this.numEqn);
        System.arraycopy(this.fn, 0, this.fn1, 0, this.numEqn);
        return this.stepSize;
    }
}

