/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;

public class CurveFitting {
    private CurveFitting() {
    }

    public static Function linearRegression(double[] xpoints, double[] ypoints) {
        double xBar_yBar = 0.0;
        double xBar = 0.0;
        double yBar = 0.0;
        double x2Bar = 0.0;
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < xpoints.length; ++i) {
            x = xpoints[i];
            y = ypoints[i];
            xBar_yBar += x * y;
            xBar += x;
            yBar += y;
            x2Bar += x * x;
        }
        int n = xpoints.length;
        double deltaX2 = (x2Bar /= (double)n) - (xBar /= (double)n) * xBar;
        final double m = ((xBar_yBar /= (double)n) - xBar * (yBar /= (double)n)) / deltaX2;
        final double b = yBar - m * xBar;
        return new Function(){

            public double evaluate(double x) {
                return m * x + b;
            }

            public String toString() {
                return "linear regression: y(x) = " + m + "x + " + b;
            }
        };
    }
}

