/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public class Factorials {
    static double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    static long[] fac;

    private Factorials() {
    }

    public static double gammaln(double x) {
        double y = x;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double sum = 1.000000000190015;
        for (int j = 0; j <= 5; ++j) {
            sum += cof[j] / (y += 1.0);
        }
        return -tmp + Math.log(2.5066282746310007 * sum / x);
    }

    public static double factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative value passed to factorial.");
        }
        if (n < fac.length) {
            return fac[n];
        }
        return Math.exp(Factorials.gammaln((double)n + 1.0));
    }

    public static double logFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative value passed to logFactorial.");
        }
        return Factorials.gammaln((double)n + 1.0);
    }

    public static double poisson(double nu, int n) {
        return Math.exp((double)n * Math.log(nu) - nu - Factorials.logFactorial(n));
    }

    public static double logChoose(int n, int k) {
        return Factorials.logFactorial(n) - Factorials.logFactorial(k) - Factorials.logFactorial(n - k);
    }

    static {
        long val = 1L;
        int maxN = 1;
        while (val * (long)maxN >= val) {
            val *= (long)maxN;
            ++maxN;
        }
        fac = new long[maxN];
        Factorials.fac[0] = 1L;
        for (int i = 1; i < maxN; ++i) {
            Factorials.fac[i] = fac[i - 1] * (long)i;
        }
    }
}

