/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.numerics.RK45MultiStep;
import org.opensourcephysics.numerics.Util;

public final class Integral {
    static final int MAX_ITERATIONS = 15;

    private Integral() {
    }

    public static double trapezoidal(Function f, double start, double stop, int n, double tol) {
        double oldSum;
        int sign;
        double step = stop - start;
        int n2 = sign = step < 0.0 ? -1 : 1;
        if (sign < 1) {
            step = -step;
            double temp = start;
            start = stop;
            stop = temp;
        }
        int iterations = 0;
        double sum = (f.evaluate(stop) + f.evaluate(start)) * step * 0.5;
        do {
            oldSum = sum;
            double newSum = 0.0;
            for (double x = start + 0.5 * step; x < stop; x += step) {
                newSum += f.evaluate(x);
            }
            sum = (step * newSum + sum) * 0.5;
            step *= 0.5;
        } while ((n /= 2) > 0 || ++iterations < 15 && Util.relativePrecision(Math.abs(sum - oldSum), sum) > tol);
        return (double)sign * sum;
    }

    public static double simpson(Function f, double start, double stop, int n) throws IllegalArgumentException {
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Number of partitions must be even in Simpson's method.");
        }
        double sumOdd = 0.0;
        double sumEven = 0.0;
        double x = start;
        double h = (stop - start) / (double)(2 * n);
        for (int i = 0; i < n - 1; ++i) {
            sumOdd += f.evaluate(x + h);
            sumEven += f.evaluate(x + 2.0 * h);
            x += 2.0 * h;
        }
        return h / 3.0 * (f.evaluate(start) + 4.0 * (sumOdd += f.evaluate(x + h)) + 2.0 * sumEven + f.evaluate(stop));
    }

    public static double simpson(Function f, double start, double stop, int n, double tol) {
        double sum;
        double result;
        int sign;
        double step = stop - start;
        int n2 = sign = step < 0.0 ? -1 : 1;
        if (sign < 1) {
            step = -step;
            double temp = start;
            start = stop;
            stop = temp;
        }
        int iterations = 0;
        double oldResult = result = (sum = (f.evaluate(stop) + f.evaluate(start)) * step * 0.5);
        do {
            double oldSum = sum;
            double newSum = 0.0;
            for (double x = start + 0.5 * step; x < stop; x += step) {
                newSum += f.evaluate(x);
            }
            sum = (step * newSum + sum) * 0.5;
            step *= 0.5;
            oldResult = result;
            result = (4.0 * sum - oldSum) / 3.0;
        } while ((n /= 2) > 0 || ++iterations < 15 && Util.relativePrecision(Math.abs(result - oldResult), result) > tol);
        return (double)sign * result;
    }

    public static double romberg(Function f, double a, double b, int n, double tol) {
        if (a == b) {
            return 0.0;
        }
        if (tol <= 0.0) {
            return Double.NaN;
        }
        double[] coef = new double[15];
        double h = (b - a) / (double)n;
        coef[0] = 0.5 * (f.evaluate(a) + f.evaluate(b));
        for (int k = 1; k < n; ++k) {
            coef[0] = coef[0] + f.evaluate(a + (double)k * h);
        }
        coef[0] = coef[0] * h;
        for (int j = 1; j < 15; ++j) {
            h /= 2.0;
            double c0 = coef[0];
            coef[j] = 0.0;
            coef[0] = 0.0;
            for (int k = 0; k < n; ++k) {
                coef[0] = coef[0] + f.evaluate(a + (double)(2 * k + 1) * h);
            }
            coef[0] = 0.5 * c0 + h * coef[0];
            int inc = 1;
            for (int k = 1; k <= j; ++k) {
                double Lk = coef[k];
                coef[k] = ((double)(inc *= 4) * coef[k - 1] - c0) / (double)(inc - 1);
                c0 = Lk;
            }
            if (Util.relativePrecision(Math.abs(coef[j] - coef[j - 1]), coef[j]) < tol) {
                return coef[j];
            }
            n *= 2;
        }
        return Double.NaN;
    }

    public static double ode(Function f, double start, double stop, double tol) {
        FunctionRate ode = new FunctionRate(f, start);
        RK45MultiStep ode_method = new RK45MultiStep(ode);
        ode_method.setTolerance(tol);
        ode_method.initialize(stop - start);
        ode_method.step();
        return ode.getState()[0];
    }

    public static double[][] fillArray(Function f, double start, double stop, double tol, int n) {
        double[][] data = new double[2][n];
        return Integral.fillArray(f, start, stop, tol, data);
    }

    public static double[][] fillArray(Function f, double start, double stop, double tol, double[][] data) {
        FunctionRate ode = new FunctionRate(f, start);
        ODEMultistepSolver ode_method = new ODEMultistepSolver(ode);
        ode_method.setTolerance(tol);
        double dx = 1.0;
        int n = data[0].length;
        if (n > 1) {
            dx = (stop - start) / (double)(n - 1);
        }
        ode_method.setStepSize(dx);
        for (int i = 0; i < n; ++i) {
            data[0][i] = ode.getState()[1];
            data[1][i] = ode.getState()[0];
            ode_method.step();
        }
        return data;
    }

    private static final class FunctionRate
    implements ODE {
        double[] state = new double[2];
        Function f;

        private FunctionRate(Function _f, double start) {
            this.state[0] = 0.0;
            this.state[1] = start;
            this.f = _f;
        }

        public double[] getState() {
            return this.state;
        }

        public void getRate(double[] state, double[] rate) {
            rate[0] = this.f.evaluate(state[1]);
            rate[1] = 1.0;
        }
    }
}

