/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public class Interpolation {
    private Interpolation() {
    }

    public static double linear(double x, double x0, double x1, double y0, double y1) {
        if (x1 - x0 == 0.0) {
            return (y0 + y1) / 2.0;
        }
        return y0 + (x - x0) * (y1 - y0) / (x1 - x0);
    }

    public static double lagrange(double x, double[] xd, double[] yd) {
        if (xd.length != yd.length) {
            throw new IllegalArgumentException("Arrays must be of equal length.");
        }
        double sum = 0.0;
        int n = xd.length;
        for (int i = 0; i < n; ++i) {
            if (x - xd[i] == 0.0) {
                return x;
            }
            double product = yd[i];
            for (int j = 0; j < n; ++j) {
                if (i == j || xd[i] - xd[j] == 0.0) continue;
                product *= (x - xd[i]) / (xd[i] - xd[j]);
            }
            sum += product;
        }
        return sum;
    }
}

