/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public class LUPDecomposition {
    private double[][] rows;
    private int[] permutation = null;
    private int parity = 1;

    public LUPDecomposition(double[][] components) throws IllegalArgumentException {
        int n = components.length;
        if (components[0].length != n) {
            throw new IllegalArgumentException("Illegal system: a" + n + " by " + components[0].length + " matrix is not a square matrix");
        }
        this.initialize(components);
    }

    private double[] backwardSubstitution(double[] xTilde) {
        int n = this.rows.length;
        double[] answer = new double[n];
        for (int i = n - 1; i >= 0; --i) {
            answer[i] = xTilde[i];
            for (int j = i + 1; j < n; ++j) {
                int n2 = i;
                answer[n2] = answer[n2] - this.rows[i][j] * answer[j];
            }
            int n3 = i;
            answer[n3] = answer[n3] / this.rows[i][i];
        }
        return answer;
    }

    private void decompose() {
        int i;
        int n = this.rows.length;
        this.permutation = new int[n];
        for (i = 0; i < n; ++i) {
            this.permutation[i] = i;
        }
        this.parity = 1;
        try {
            for (i = 0; i < n; ++i) {
                this.swapRows(i, this.largestPivot(i));
                this.pivot(i);
            }
        }
        catch (ArithmeticException e) {
            this.parity = 0;
        }
    }

    private boolean decomposed() {
        if (this.parity == 1 && this.permutation == null) {
            this.decompose();
        }
        return this.parity != 0;
    }

    public double determinant() {
        if (!this.decomposed()) {
            return Double.NaN;
        }
        double determinant = this.parity;
        for (int i = 0; i < this.rows.length; ++i) {
            determinant *= this.rows[i][i];
        }
        return determinant;
    }

    private double[] forwardSubstitution(double[] c) {
        int n = this.rows.length;
        double[] answer = new double[n];
        for (int i = 0; i < n; ++i) {
            answer[i] = c[this.permutation[i]];
            for (int j = 0; j <= i - 1; ++j) {
                int n2 = i;
                answer[n2] = answer[n2] - this.rows[i][j] * answer[j];
            }
        }
        return answer;
    }

    private void initialize(double[][] components) {
        int n = components.length;
        this.rows = new double[n][n];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(components[i], 0, this.rows[i], 0, n);
        }
        this.permutation = null;
        this.parity = 1;
    }

    public double[][] inverseMatrixComponents() {
        if (!this.decomposed()) {
            return null;
        }
        int n = this.rows.length;
        double[][] inverseMatrix = new double[n][n];
        double[] column = new double[n];
        for (int i = 0; i < n; ++i) {
            int j;
            for (j = 0; j < n; ++j) {
                column[j] = 0.0;
            }
            column[i] = 1.0;
            column = this.solve(column);
            for (j = 0; j < n; ++j) {
                if (Double.isNaN(column[j])) {
                    return null;
                }
                inverseMatrix[j][i] = column[j];
            }
        }
        return inverseMatrix;
    }

    public static void symmetrizeComponents(double[][] components) {
        for (int i = 0; i < components.length; ++i) {
            for (int j = i + 1; j < components.length; ++j) {
                double[] dArray = components[i];
                int n = j;
                dArray[n] = dArray[n] + components[j][i];
                double[] dArray2 = components[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] * 0.5;
                components[j][i] = components[i][j];
            }
        }
    }

    private int largestPivot(int k) {
        double maximum = Math.abs(this.rows[k][k]);
        int index = k;
        for (int i = k + 1; i < this.rows.length; ++i) {
            double abs = Math.abs(this.rows[i][k]);
            if (!(abs > maximum)) continue;
            maximum = abs;
            index = i;
        }
        return index;
    }

    private void pivot(int k) {
        double inversePivot = 1.0 / this.rows[k][k];
        int k1 = k + 1;
        int n = this.rows.length;
        for (int i = k1; i < n; ++i) {
            double[] dArray = this.rows[i];
            int n2 = k;
            dArray[n2] = dArray[n2] * inversePivot;
            for (int j = k1; j < n; ++j) {
                double[] dArray2 = this.rows[i];
                int n3 = j;
                dArray2[n3] = dArray2[n3] - this.rows[i][k] * this.rows[k][j];
            }
        }
    }

    public double[] solve(double[] c) {
        return this.decomposed() ? this.backwardSubstitution(this.forwardSubstitution(c)) : null;
    }

    private void swapRows(int i, int k) {
        if (i != k) {
            for (int j = 0; j < this.rows.length; ++j) {
                double temp = this.rows[i][j];
                this.rows[i][j] = this.rows[k][j];
                this.rows[k][j] = temp;
            }
            int nTemp = this.permutation[i];
            this.permutation[i] = this.permutation[k];
            this.permutation[k] = nTemp;
            this.parity = -this.parity;
        }
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        char[] separator = new char[]{'[', ' '};
        int n = this.rows.length;
        for (i = 0; i < n; ++i) {
            separator[0] = 123;
            for (int j = 0; j < n; ++j) {
                sb.append(separator);
                sb.append(this.rows[i][j]);
                separator[0] = 32;
            }
            sb.append('}');
            sb.append('\n');
        }
        if (this.permutation != null) {
            sb.append(this.parity == 1 ? (char)'+' : '-');
            sb.append("( " + this.permutation[0]);
            for (i = 1; i < n; ++i) {
                sb.append(", " + this.permutation[i]);
            }
            sb.append(')');
            sb.append('\n');
        }
        return sb.toString();
    }
}

