/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.Verlet;

public class LeapFrog
extends AbstractODESolver {
    private double[] rate;
    private double[] priorState;
    private double[] currentState;

    public LeapFrog(ODE ode) {
        super(ode);
    }

    public void initialize(double stepSize) {
        super.initialize(stepSize);
        this.rate = new double[this.numEqn];
        this.priorState = new double[this.numEqn];
        this.currentState = new double[this.numEqn];
        this.estimatePreviousState();
    }

    public void setStepSize(double stepSize) {
        this.initialize(stepSize);
    }

    void estimatePreviousState() {
        double[] state;
        double[] dArray = state = this.ode == null ? null : this.ode.getState();
        if (state == null) {
            return;
        }
        System.arraycopy(state, 0, this.currentState, 0, state.length);
        Verlet verlet = new Verlet(this.ode);
        verlet.setStepSize(-this.stepSize);
        verlet.step();
        System.arraycopy(state, 0, this.priorState, 0, state.length);
        System.arraycopy(this.currentState, 0, state, 0, state.length);
        verlet = null;
    }

    public double step() {
        double[] state = this.ode.getState();
        if (state.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        System.arraycopy(state, 0, this.currentState, 0, this.numEqn);
        this.ode.getRate(state, this.rate);
        double dtSquared = this.stepSize * this.stepSize;
        double dt2 = 2.0 * this.stepSize;
        for (int i = 0; i < this.numEqn - 1; i += 2) {
            int n = i;
            state[n] = state[n] + (state[i] - this.priorState[i] + dtSquared * this.rate[i + 1]);
            state[i + 1] = (state[i] - this.priorState[i]) / dt2 + this.rate[i + 1] * this.stepSize;
        }
        if (this.numEqn % 2 == 1) {
            int n = this.numEqn - 1;
            state[n] = state[n] + this.stepSize * this.rate[this.numEqn - 1];
        }
        System.arraycopy(this.currentState, 0, this.priorState, 0, this.numEqn);
        return this.stepSize;
    }
}

