/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.MatrixTransformation;
import org.opensourcephysics.numerics.VectorMath;

public class Matrix3DTransformation
implements MatrixTransformation {
    double[] origin = new double[3];
    double[][] matrix = new double[3][3];
    double[][] inverse = null;

    public Matrix3DTransformation(double[][] matrix) {
        if (matrix == null) {
            this.matrix[2][2] = 1.0;
            this.matrix[1][1] = 1.0;
            this.matrix[0][0] = 1.0;
            return;
        }
        for (int i = 0; i < matrix.length; ++i) {
            System.arraycopy(matrix[i], 0, this.matrix[i], 0, matrix[i].length);
        }
    }

    public static Matrix3DTransformation rotationX(double theta) {
        Matrix3DTransformation at = new Matrix3DTransformation(null);
        double[][] mat = at.matrix;
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        mat[0][0] = 1.0;
        mat[1][1] = cos;
        mat[1][2] = -sin;
        mat[2][1] = sin;
        mat[2][2] = cos;
        double[][] inv = new double[3][3];
        at.inverse = inv;
        inv[0][0] = 1.0;
        inv[1][1] = cos;
        inv[1][2] = sin;
        inv[2][1] = -sin;
        inv[2][2] = cos;
        return at;
    }

    public static Matrix3DTransformation rotationY(double theta) {
        Matrix3DTransformation at = new Matrix3DTransformation(null);
        double[][] mat = at.matrix;
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        mat[1][1] = 1.0;
        mat[0][0] = cos;
        mat[0][2] = sin;
        mat[2][0] = -sin;
        mat[2][2] = cos;
        double[][] inv = new double[3][3];
        at.inverse = inv;
        inv[1][1] = 1.0;
        inv[0][0] = cos;
        inv[0][2] = -sin;
        inv[2][0] = sin;
        inv[2][2] = cos;
        return at;
    }

    public static Matrix3DTransformation rotationZ(double theta) {
        double cos;
        Matrix3DTransformation at = new Matrix3DTransformation(null);
        double[][] mat = at.matrix;
        double sin = Math.sin(theta);
        mat[0][0] = cos = Math.cos(theta);
        mat[0][1] = -sin;
        mat[1][0] = sin;
        mat[1][1] = cos;
        mat[2][2] = 1.0;
        double[][] inv = new double[3][3];
        at.inverse = inv;
        inv[0][0] = cos;
        inv[0][1] = sin;
        inv[1][0] = -sin;
        inv[1][1] = cos;
        inv[2][2] = 1.0;
        return at;
    }

    public static Matrix3DTransformation rotation(double theta, double[] axis) {
        Matrix3DTransformation at = new Matrix3DTransformation(null);
        double[][] mat = at.matrix;
        double x = axis[0];
        double y = axis[1];
        double z = axis[2];
        double norm = x * x + y * y + z * z;
        if (norm != 1.0) {
            norm = 1.0 / Math.sqrt(norm);
            x *= norm;
            y *= norm;
            z *= norm;
        }
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        double t = 1.0 - c;
        mat[0][0] = t * x * x + c;
        mat[0][1] = t * x * y - s * z;
        mat[0][2] = t * x * z + s * y;
        mat[1][0] = t * x * y + s * z;
        mat[1][1] = t * y * y + c;
        mat[1][2] = t * y * z - s * x;
        mat[2][0] = t * x * z - s * y;
        mat[2][1] = t * y * z + s * x;
        mat[2][2] = t * z * z + c;
        double[][] inv = new double[3][3];
        at.inverse = inv;
        inv[0][0] = mat[0][0];
        inv[1][0] = mat[0][1];
        inv[2][0] = mat[0][2];
        inv[0][1] = mat[1][0];
        inv[1][1] = mat[1][1];
        inv[2][1] = mat[1][2];
        inv[0][2] = mat[2][0];
        inv[1][2] = mat[2][1];
        inv[2][2] = mat[2][2];
        return at;
    }

    public static Matrix3DTransformation Quaternion(double[] quaternion) {
        return Matrix3DTransformation.Quaternion(quaternion[0], quaternion[1], quaternion[2], quaternion[3]);
    }

    public static Matrix3DTransformation Quaternion(double q0, double q1, double q2, double q3) {
        Matrix3DTransformation at = new Matrix3DTransformation(null);
        double[][] atMatrix = at.matrix;
        double norm = q0 * q0 + q1 * q1 + q2 * q2 + q3 * q3;
        if (norm != 1.0) {
            norm = 1.0 / Math.sqrt(norm);
            q0 *= norm;
            q1 *= norm;
            q2 *= norm;
            q3 *= norm;
        }
        double q11 = 2.0 * q1 * q1;
        double q22 = 2.0 * q2 * q2;
        double q33 = 2.0 * q3 * q3;
        double q12 = 2.0 * q1 * q2;
        double q13 = 2.0 * q1 * q3;
        double q23 = 2.0 * q2 * q3;
        double q01 = 2.0 * q0 * q1;
        double q02 = 2.0 * q0 * q2;
        double q03 = 2.0 * q0 * q3;
        atMatrix[0][0] = 1.0 - q22 - q33;
        atMatrix[0][1] = q12 - q03;
        atMatrix[0][2] = q13 + q02;
        atMatrix[1][0] = q12 + q03;
        atMatrix[1][1] = 1.0 - q11 - q33;
        atMatrix[1][2] = q23 - q01;
        atMatrix[2][0] = q13 - q02;
        atMatrix[2][1] = q23 + q01;
        atMatrix[2][2] = 1.0 - q11 - q22;
        double[][] inv = new double[3][3];
        at.inverse = inv;
        inv[0][0] = atMatrix[0][0];
        inv[1][0] = atMatrix[0][1];
        inv[2][0] = atMatrix[0][2];
        inv[0][1] = atMatrix[1][0];
        inv[1][1] = atMatrix[1][1];
        inv[2][1] = atMatrix[1][2];
        inv[0][2] = atMatrix[2][0];
        inv[1][2] = atMatrix[2][1];
        inv[2][2] = atMatrix[2][2];
        return at;
    }

    public Object clone() {
        return new Matrix3DTransformation(this.matrix);
    }

    public final double[] getFlatMatrix(double[] mat) {
        if (mat == null) {
            mat = new double[16];
        }
        mat[0] = this.matrix[0][0];
        mat[4] = this.matrix[0][1];
        mat[8] = this.matrix[0][2];
        mat[1] = this.matrix[1][0];
        mat[5] = this.matrix[1][1];
        mat[9] = this.matrix[1][2];
        mat[2] = this.matrix[2][0];
        mat[3] = 0.0;
        mat[6] = this.matrix[2][1];
        mat[7] = 0.0;
        mat[10] = this.matrix[2][2];
        mat[11] = 0.0;
        mat[12] = this.origin[0];
        mat[13] = this.origin[1];
        mat[14] = this.origin[2];
        mat[15] = 1.0;
        return mat;
    }

    public final double[] getSquareMatrix(double[] mat) {
        if (mat == null) {
            mat = new double[]{this.matrix[0][0], this.matrix[0][1], this.matrix[0][2], 0.0, this.matrix[1][0], this.matrix[1][1], this.matrix[1][2], 0.0, this.matrix[2][0], this.matrix[2][1], this.matrix[2][2], 0.0, this.origin[0], this.origin[1], this.origin[2], 1.0};
        }
        return mat;
    }

    public static Matrix3DTransformation createAlignmentTransformation(double[] v1, double[] v2) {
        v1 = VectorMath.normalize((double[])v1.clone());
        v2 = VectorMath.normalize((double[])v2.clone());
        double theta = Math.acos(VectorMath.dot(v1, v2));
        double[] axis = VectorMath.cross3D(v1, v2);
        return Matrix3DTransformation.rotation(theta, axis);
    }

    public void setOrigin(double ox, double oy, double oz) {
        this.origin[0] = ox;
        this.origin[1] = oy;
        this.origin[2] = oz;
    }

    public final void multiply(Matrix3DTransformation trans) {
        this.multiply(trans.matrix);
    }

    public final void multiply(double[][] mat) {
        int n = this.matrix.length;
        for (int i = 0; i < n; ++i) {
            double[] row = (double[])this.matrix[i].clone();
            int m = this.matrix[0].length;
            for (int j = 0; j < m; ++j) {
                this.matrix[i][j] = 0.0;
                for (int k = 0; k < m; ++k) {
                    double[] dArray = this.matrix[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + row[k] * mat[k][j];
                }
            }
        }
    }

    public double[] setOrigin(double[] origin) {
        this.origin[0] = origin[0];
        this.origin[1] = origin[1];
        this.origin[2] = origin[2];
        return origin;
    }

    public double[] direct(double[] point) {
        point[0] = point[0] - this.origin[0];
        point[1] = point[1] - this.origin[1];
        point[2] = point[2] - this.origin[2];
        double[] tempPoint = (double[])point.clone();
        int n = point.length;
        for (int i = 0; i < n; ++i) {
            point[i] = 0.0;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                point[n2] = point[n2] + (this.matrix[i][j] * tempPoint[j] + this.origin[i]);
            }
        }
        return point;
    }

    public double[] inverse(double[] point) throws UnsupportedOperationException {
        if (this.inverse == null) {
            this.calcInverse();
            if (this.inverse == null) {
                throw new UnsupportedOperationException("The inverse matrix does not exist.");
            }
        }
        point[0] = point[0] - this.origin[0];
        point[1] = point[1] - this.origin[1];
        point[2] = point[2] - this.origin[2];
        double[] tempPoint = (double[])point.clone();
        int n = point.length;
        for (int i = 0; i < n; ++i) {
            point[i] = 0.0;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                point[n2] = point[n2] + (this.inverse[i][j] * tempPoint[j] + point[i]);
            }
        }
        return point;
    }

    private void calcInverse() {
        LUPDecomposition lupd = new LUPDecomposition(this.matrix);
        this.inverse = lupd.inverseMatrixComponents();
    }

    public static XML.ObjectLoader getLoader() {
        return new Affine3DTransformationLoader();
    }

    protected static class Affine3DTransformationLoader
    extends XMLLoader {
        protected Affine3DTransformationLoader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            Matrix3DTransformation transf = (Matrix3DTransformation)obj;
            control.setValue("matrix", transf.matrix);
            if (transf.inverse != null) {
                control.setValue("inverse", transf.inverse);
            }
            control.setValue("origin", transf.origin);
        }

        public Object createObject(XMLControl control) {
            return new Matrix3DTransformation(null);
        }

        public Object loadObject(XMLControl control, Object obj) {
            Matrix3DTransformation transf = (Matrix3DTransformation)obj;
            transf.matrix = (double[][])control.getObject("matrix");
            transf.inverse = (double[][])control.getObject("inverse");
            transf.origin = (double[])control.getObject("origin");
            return obj;
        }
    }
}

