/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.numerics.DormandPrince45;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.numerics.ODESolverException;
import org.opensourcephysics.numerics.RK45;

public class ODEMultistepSolver
implements ODEAdaptiveSolver {
    private static int maxMessages = 4;
    protected int err_code = 0;
    protected int maxIterations = 200;
    protected boolean enableExceptions = false;
    protected String err_msg = "";
    protected ODEAdaptiveSolver odeEngine;
    protected double fixedStepSize = 0.1;
    protected InternalODE internalODE;

    public ODEMultistepSolver(ODE ode) {
        this.odeEngine = new DormandPrince45(this.setODE(ode));
    }

    protected ODEMultistepSolver() {
    }

    protected InternalODE setODE(ODE ode) {
        this.internalODE = new InternalODE(ode);
        return this.internalODE;
    }

    public static ODEAdaptiveSolver MultistepRK45(ODE ode) {
        ODEMultistepSolver multistepSolver = new ODEMultistepSolver();
        multistepSolver.odeEngine = new RK45(multistepSolver.setODE(ode));
        return multistepSolver;
    }

    public void enableRuntimeExpecptions(boolean enable) {
        this.enableExceptions = enable;
    }

    public void setMaxIterations(int n) {
        this.maxIterations = Math.max(1, n);
    }

    public void setTolerance(double tol) {
        this.odeEngine.setTolerance(tol);
    }

    public double getTolerance() {
        return this.odeEngine.getTolerance();
    }

    public int getErrorCode() {
        return this.err_code;
    }

    public double step() {
        this.internalODE.setInitialConditions();
        double remainder = 0.0;
        remainder = this.fixedStepSize > 0.0 ? this.plus() : this.minus();
        if (this.err_code == 0) {
            this.internalODE.update();
            return this.fixedStepSize - remainder;
        }
        return 0.0;
    }

    private double plus() {
        double tol = this.odeEngine.getTolerance();
        double remainder = this.fixedStepSize;
        if (this.odeEngine.getStepSize() <= 0.0 || this.odeEngine.getStepSize() > this.fixedStepSize || this.fixedStepSize - this.odeEngine.getStepSize() == this.fixedStepSize) {
            this.odeEngine.setStepSize(this.fixedStepSize);
        }
        int counter = 0;
        while (remainder > tol * this.fixedStepSize) {
            ++counter;
            double oldRemainder = remainder;
            if (remainder < this.odeEngine.getStepSize()) {
                double tempStep = this.odeEngine.getStepSize();
                this.odeEngine.setStepSize(remainder);
                double delta = this.odeEngine.step();
                remainder -= delta;
                this.odeEngine.setStepSize(tempStep);
            } else {
                remainder -= this.odeEngine.step();
            }
            if (this.odeEngine.getErrorCode() == 0 && !(Math.abs(oldRemainder - remainder) <= (double)1.4E-45f) && !(tol * this.fixedStepSize / 10.0 > this.odeEngine.getStepSize()) && counter <= this.maxIterations) continue;
            this.err_msg = "ODEMultiStep did not converge. Remainder=" + remainder;
            this.err_code = 1;
            if (this.enableExceptions) {
                throw new ODESolverException(this.err_msg);
            }
            if (maxMessages <= 0) break;
            --maxMessages;
            OSPLog.warning(this.err_msg);
            break;
        }
        return remainder;
    }

    private double minus() {
        double tol = this.odeEngine.getTolerance();
        double remainder = this.fixedStepSize;
        if (this.odeEngine.getStepSize() >= 0.0 || this.odeEngine.getStepSize() < this.fixedStepSize || this.fixedStepSize - this.odeEngine.getStepSize() == this.fixedStepSize) {
            this.odeEngine.setStepSize(this.fixedStepSize);
        }
        int counter = 0;
        while (remainder < tol * this.fixedStepSize) {
            ++counter;
            double oldRemainder = remainder;
            if (remainder > this.odeEngine.getStepSize()) {
                double tempStep = this.odeEngine.getStepSize();
                this.odeEngine.setStepSize(remainder);
                double delta = this.odeEngine.step();
                remainder -= delta;
                this.odeEngine.setStepSize(tempStep);
            } else {
                remainder -= this.odeEngine.step();
            }
            if (this.odeEngine.getErrorCode() == 0 && !(Math.abs(oldRemainder - remainder) <= (double)1.4E-45f) && !(tol * this.fixedStepSize / 10.0 < this.odeEngine.getStepSize()) && counter <= this.maxIterations) continue;
            this.err_msg = "ODEMultiStep did not converge. Remainder=" + remainder;
            this.err_code = 1;
            if (this.enableExceptions) {
                throw new ODESolverException(this.err_msg);
            }
            if (maxMessages <= 0) continue;
            --maxMessages;
            OSPLog.warning(this.err_msg);
        }
        return remainder;
    }

    public void initialize(double stepSize) {
        maxMessages = 4;
        this.err_msg = "";
        this.err_code = 0;
        this.fixedStepSize = stepSize;
        this.internalODE.setInitialConditions();
        this.odeEngine.initialize(stepSize);
    }

    public void setStepSize(double stepSize) {
        maxMessages = 4;
        this.fixedStepSize = stepSize;
        if (stepSize < 0.0) {
            this.odeEngine.setStepSize(Math.max(-Math.abs(this.odeEngine.getStepSize()), stepSize));
        } else {
            this.odeEngine.setStepSize(Math.min(this.odeEngine.getStepSize(), stepSize));
        }
    }

    public void setMaximumNumberOfErrorMessages(int n) {
        maxMessages = n;
    }

    public double getStepSize() {
        return this.fixedStepSize;
    }

    protected final class InternalODE
    implements ODE {
        private ODE ode;
        private double[] engineState = new double[0];

        InternalODE(ODE ode) {
            this.ode = ode;
            this.setInitialConditions();
        }

        public void getRate(double[] state, double[] rate) {
            this.ode.getRate(state, rate);
        }

        public double[] getState() {
            return this.engineState;
        }

        public void setInitialConditions() {
            double[] state = this.ode.getState();
            if (state == null) {
                return;
            }
            if (this.engineState == null || this.engineState.length != state.length) {
                this.engineState = new double[state.length];
            }
            System.arraycopy(state, 0, this.engineState, 0, state.length);
        }

        public void update() {
            System.arraycopy(this.engineState, 0, this.ode.getState(), 0, this.engineState.length);
        }
    }
}

