/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.Polynomial;

public class PolynomialLeastSquareFit
extends Polynomial {
    double[][] systemMatrix;
    double[] systemConstants;

    public PolynomialLeastSquareFit(double[] xd, double[] yd, int degree) {
        super(new double[degree + 1]);
        int ncoef = degree + 1;
        this.systemMatrix = new double[ncoef][ncoef];
        this.systemConstants = new double[ncoef];
        this.fitData(xd, yd);
    }

    public PolynomialLeastSquareFit(double[] coeffs) {
        super(coeffs);
        int n = coeffs.length;
        this.systemMatrix = new double[n][n];
        this.systemConstants = new double[n];
    }

    public void fitData(double[] xd, double[] yd) {
        int i;
        if (xd.length != yd.length) {
            throw new IllegalArgumentException("Arrays must be of equal length.");
        }
        if (xd.length < this.degree() + 1) {
            return;
        }
        for (i = 0; i < this.systemConstants.length; ++i) {
            this.systemConstants[i] = 0.0;
            for (int j = 0; j < this.systemConstants.length; ++j) {
                this.systemMatrix[i][j] = 0.0;
            }
        }
        int n = xd.length;
        for (i = 0; i < n; ++i) {
            double xp1 = 1.0;
            for (int j = 0; j < this.systemConstants.length; ++j) {
                int n2 = j;
                this.systemConstants[n2] = this.systemConstants[n2] + xp1 * yd[i];
                double xp2 = xp1;
                int k = 0;
                while (k <= j) {
                    double[] dArray = this.systemMatrix[j];
                    int n3 = k++;
                    dArray[n3] = dArray[n3] + xp2;
                    xp2 *= xd[i];
                }
                xp1 *= xd[i];
            }
        }
        this.computeCoefficients();
    }

    protected void computeCoefficients() {
        for (int i = 0; i < this.systemConstants.length; ++i) {
            for (int j = i + 1; j < this.systemConstants.length; ++j) {
                this.systemMatrix[i][j] = this.systemMatrix[j][i];
            }
        }
        LUPDecomposition lupSystem = new LUPDecomposition(this.systemMatrix);
        double[][] components = lupSystem.inverseMatrixComponents();
        LUPDecomposition.symmetrizeComponents(components);
        this.coefficients = lupSystem.solve(this.systemConstants);
    }
}

