/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.numerics.SuryonoParser;

public final class Util {
    public static final double SQRT2PI = Math.sqrt(Math.PI * 2);
    public static final double LOG10 = Math.log(10.0);
    public static final double defaultNumericalPrecision = Math.sqrt(Double.MIN_VALUE);
    private static SuryonoParser parser = new SuryonoParser(0);

    private Util() {
    }

    public static String f2(double d) {
        return ControlUtils.f2(d);
    }

    public static String f3(double d) {
        return ControlUtils.f3(d);
    }

    public static String f4(double d) {
        return ControlUtils.f4(d);
    }

    public static double relativePrecision(double epsilon, double result) {
        return result > defaultNumericalPrecision ? epsilon / result : epsilon;
    }

    public static int checkSorting(double[] array) {
        int sign = array[0] <= array[array.length - 1] ? 1 : -1;
        int n = array.length;
        block4: for (int i = 1; i < n; ++i) {
            switch (sign) {
                case -1: {
                    if (!(array[i - 1] < array[i])) continue block4;
                    return 0;
                }
                case 1: {
                    if (!(array[i - 1] > array[i])) continue block4;
                    return 0;
                }
            }
        }
        return sign;
    }

    public static double[] getRange(Function f, double a, double b, int n) {
        double min = f.evaluate(a);
        double max = f.evaluate(a);
        double x = a;
        double dx = (b - a) / (double)(n - 1);
        for (int i = 1; i < n; ++i) {
            double y = f.evaluate(x);
            min = Math.min(min, y);
            max = Math.max(max, y);
            x += dx;
        }
        return new double[]{min, max};
    }

    public static double[][] functionFill(Function f, double start, double stop, double[][] data) {
        double dx = 1.0;
        int n = data[0].length;
        if (n > 1) {
            dx = (stop - start) / (double)(n - 1);
        }
        double x = start;
        for (int i = 0; i < n; ++i) {
            data[0][i] = x;
            data[1][i] = f.evaluate(x);
            x += dx;
        }
        return data;
    }

    public static double[] functionFill(Function f, double start, double stop, double[] data) {
        double dx = 1.0;
        int n = data.length;
        if (n > 1) {
            dx = (stop - start) / (double)(n - 1);
        }
        double x = start;
        for (int i = 0; i < n; ++i) {
            data[i] = f.evaluate(x);
            x += dx;
        }
        return data;
    }

    public static double computeAverage(double[] array, int start, int num) {
        double sum = 0.0;
        int stop = start + num;
        for (int i = start; i < stop; ++i) {
            sum += array[i];
        }
        return sum / (double)num;
    }

    public static Function constantFunction(final double c) {
        return new Function(){

            public double evaluate(double x) {
                return c;
            }
        };
    }

    public static Function linearFunction(final double m, final double b) {
        return new Function(){

            public double evaluate(double x) {
                return m * x + b;
            }
        };
    }

    public static Function gaussian(final double x0, final double sigma) {
        final double s2 = 2.0 * sigma * sigma;
        return new Function(){

            public double evaluate(double x) {
                return Math.exp(-(x - x0) * (x - x0) / s2) / sigma / SQRT2PI;
            }
        };
    }

    public static synchronized double evalMath(String str) {
        try {
            parser.parse(str);
            return parser.evaluate();
        }
        catch (ParserException parserException) {
            return Double.NaN;
        }
    }
}

