/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public final class VectorMath {
    private VectorMath() {
    }

    public static double[] plus(double[] a, double[] b, double c) {
        int aLength = a.length;
        if (aLength != b.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal length to add.");
        }
        for (int i = 0; i < aLength; ++i) {
            int n = i;
            a[n] = a[n] + c * b[i];
        }
        return a;
    }

    public static double[] plus(double[] a, double[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal length to add.");
        }
        for (int i = 0; i < aLength; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
        return a;
    }

    public static double[] normalize(double[] a) {
        double mag = VectorMath.magnitude(a);
        if (mag == 0.0) {
            a[0] = 1.0;
            return a;
        }
        a[0] = a[0] / mag;
        a[1] = a[1] / mag;
        a[2] = a[2] / mag;
        return a;
    }

    public static double dot(double[] a, double[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal dimension in dot product.");
        }
        double sum = 0.0;
        for (int i = 0; i < aLength; ++i) {
            sum += a[i] * b[i];
        }
        return sum;
    }

    public static double[] project(double[] a, double[] b) {
        int i;
        int aLength = a.length;
        if (aLength != b.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal dimension to compute projection.");
        }
        double[] result = (double[])b.clone();
        double asquared = 0.0;
        double dot = 0.0;
        for (i = 0; i < aLength; ++i) {
            dot += a[i] * b[i];
            asquared += a[i] * a[i];
        }
        dot /= asquared;
        i = 0;
        while (i < aLength) {
            int n = i++;
            result[n] = result[n] / dot;
        }
        return result;
    }

    public static double[] perp(double[] a, double[] b) {
        int i;
        int aLength = a.length;
        if (aLength != b.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal dimension to find the perpendicular component.");
        }
        double[] result = (double[])b.clone();
        double asquared = 0.0;
        double dot = 0.0;
        for (i = 0; i < aLength; ++i) {
            dot += a[i] * b[i];
            asquared += a[i] * a[i];
        }
        dot /= asquared;
        for (i = 0; i < aLength; ++i) {
            result[i] = a[i] - b[i] / dot;
        }
        return result;
    }

    public static double magnitudeSquared(double[] a) {
        int aLength = a.length;
        double sum = 0.0;
        for (int i = 0; i < aLength; ++i) {
            sum += a[i] * a[i];
        }
        return sum;
    }

    public static double magnitude(double[] a) {
        double sum = 0.0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            sum += a[i] * a[i];
        }
        return Math.sqrt(sum);
    }

    public static final double[] cross3D(double[] v1, double[] v2) {
        double[] v = new double[]{v1[1] * v2[2] - v1[2] * v2[1], v2[0] * v1[2] - v2[2] * v1[0], v1[0] * v2[1] - v1[1] * v2[0]};
        return v;
    }

    public static double[] cross2D(double[] v, double b) {
        if (v.length != 2) {
            throw new UnsupportedOperationException("ERROR: Cross2D product requires 2 component array.");
        }
        double temp = v[0];
        v[0] = v[1] * b;
        v[1] = -temp * b;
        return v;
    }

    public static double cross2D(double[] a, double[] b) {
        if (a.length != 2 || b.length != 2) {
            throw new UnsupportedOperationException("ERROR: Cross2D product requires 2 component arrays.");
        }
        return a[0] * b[1] - a[1] * b[0];
    }
}

