/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.tools.ArrayTableModel;

public class ArrayTable
extends JTable {
    ArrayTableModel tableModel;
    ArrayIndexRenderer indexRenderer;

    public ArrayTable(int[] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(int[][] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(double[] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(double[][] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(String[] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(String[][] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(boolean[] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(boolean[][] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    protected void init() {
        TableColumn column;
        String name;
        this.setModel(this.tableModel);
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                ArrayTable.this.firePropertyChange("cell", null, e);
            }
        });
        this.setColumnSelectionAllowed(true);
        this.indexRenderer = new ArrayIndexRenderer();
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(this.indexRenderer);
        this.setAutoResizeMode(0);
        this.setGridColor(Color.BLACK);
        int width = 24;
        if (this.getColumnCount() > 0) {
            name = this.getColumnName(0);
            column = this.getColumn(name);
            column.setMinWidth(width);
            column.setMaxWidth(2 * width);
            column.setWidth(width);
        }
        width = 60;
        int n = this.getColumnCount();
        for (int i = 1; i < n; ++i) {
            name = this.getColumnName(i);
            column = this.getColumn(name);
            column.setMinWidth(width);
            column.setMaxWidth(3 * width);
            column.setWidth(width);
        }
        InputMap im = this.getInputMap(1);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        final Action prevTabAction = this.getActionMap().get(im.get(tab));
        AbstractAction tabAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                prevTabAction.actionPerformed(e);
                JTable table = (JTable)e.getSource();
                int rowCount = table.getRowCount();
                int row = table.getSelectedRow();
                int column = table.getSelectedColumn();
                while (!table.isCellEditable(row, column)) {
                    if (column == 0) {
                        column = 1;
                    } else {
                        ++row;
                    }
                    if (row == rowCount) {
                        row = 0;
                    }
                    if (row != table.getSelectedRow() || column != table.getSelectedColumn()) continue;
                }
                table.changeSelection(row, column, false, false);
            }
        };
        this.getActionMap().put(im.get(tab), tabAction);
        AbstractAction enterAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JTable table = (JTable)e.getSource();
                int row = table.getSelectedRow();
                int column = table.getSelectedColumn();
                table.editCellAt(row, column, e);
                Component comp = table.getEditorComponent();
                if (comp instanceof JTextField) {
                    JTextField field = (JTextField)comp;
                    field.requestFocus();
                    field.selectAll();
                }
            }
        };
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.getActionMap().put(im.get(enter), enterAction);
    }

    public void refreshTable() {
        Runnable refresh = new Runnable(){

            public synchronized void run() {
                ArrayTable.this.tableChanged(new TableModelEvent(ArrayTable.this.tableModel, -1));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            refresh.run();
        } else {
            SwingUtilities.invokeLater(refresh);
        }
    }

    public void setEditable(boolean editable) {
        this.tableModel.setEditable(editable);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        int i = this.convertColumnIndexToModel(column);
        if (i == 0) {
            return this.indexRenderer;
        }
        return this.getDefaultRenderer(this.getColumnClass(column));
    }

    static class ArrayIndexRenderer
    extends JLabel
    implements TableCellRenderer {
        public ArrayIndexRenderer() {
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            this.setOpaque(true);
            this.setForeground(Color.BLACK);
            this.setBackground(Color.LIGHT_GRAY);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(0);
            }
            this.setText(value.toString());
            this.setPreferredSize(new Dimension(20, 18));
            return this;
        }
    }
}

