/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTree;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.tools.DatasetTab;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.JobManager;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;

public class DatasetTool
extends OSPFrame
implements Tool {
    protected static JFileChooser chooser;
    protected static OSPLog log;
    protected static Dimension dim;
    protected JTabbedPane tabbedPane;
    protected boolean useChooser = true;
    protected JPanel contentPane = new JPanel(new BorderLayout());
    protected PropertyChangeSupport support;
    protected XMLControl control = new XMLControlElement();
    protected JobManager jobManager = new JobManager(this);
    protected JMenu addMenu;
    protected JMenu subtractMenu;
    protected JMenu multiplyMenu;
    protected JMenu divideMenu;
    static final DatasetTool DATASET_TOOL;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$opensourcephysics$display$Dataset;

    public static DatasetTool getTool() {
        return DATASET_TOOL;
    }

    public DatasetTool() {
        super(ToolsRes.getString("Frame.Title"));
        String name = "DatasetTool";
        this.setName(name);
        this.createGUI();
        Toolbox.addTool(name, this);
    }

    public DatasetTool(String fileName) {
        this();
        this.open(fileName);
    }

    public DatasetTool(Dataset dataset) {
        this();
        this.addTab(dataset);
    }

    public DatasetTool(XMLControl control) {
        this();
        this.loadDatasets(control);
    }

    public String open(String fileName) {
        OSPLog.fine("opening " + fileName);
        XMLControlElement control = new XMLControlElement(fileName);
        if (!this.loadDatasets(control).isEmpty()) {
            return fileName;
        }
        OSPLog.finest("no datasets found");
        return null;
    }

    public void send(Job job, Tool replyTo) throws RemoteException {
        XMLControlElement control = new XMLControlElement(job.getXML());
        if (control.failedToRead() || control.getObjectClass() == (class$java$lang$Object == null ? (class$java$lang$Object = DatasetTool.class$("java.lang.Object")) : class$java$lang$Object)) {
            return;
        }
        this.jobManager.log(job, replyTo);
        Collection datasetsLoaded = this.loadDatasets(control);
        Iterator it = datasetsLoaded.iterator();
        while (it.hasNext()) {
            this.jobManager.associate(job, it.next());
        }
    }

    public void setUseChooser(boolean useChooser) {
        this.useChooser = useChooser;
    }

    public boolean isUseChooser() {
        return this.useChooser;
    }

    public Collection loadDatasets(XMLControl control) {
        return this.loadDatasets(control, this.useChooser);
    }

    public Collection loadDatasets(XMLControl control, boolean useChooser) {
        List props;
        HashSet<Dataset> datasets = new HashSet<Dataset>();
        if (useChooser) {
            XMLTreeChooser chooser = new XMLTreeChooser(ToolsRes.getString("Chooser.Title"), ToolsRes.getString("Chooser.Label"), this);
            props = chooser.choose(control, class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = DatasetTool.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset);
        } else {
            XMLTree tree = new XMLTree(control);
            tree.setHighlightedClass(class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = DatasetTool.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset);
            tree.selectHighlightedProperties();
            props = tree.getSelectedProperties();
            if (props.isEmpty()) {
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Dialog.NoDatasets.Message"));
            }
        }
        if (!props.isEmpty()) {
            Iterator it = props.iterator();
            while (it.hasNext()) {
                XMLControl prop = (XMLControl)it.next();
                Dataset dataset = null;
                if (prop instanceof XMLControlElement) {
                    XMLControlElement element = (XMLControlElement)prop;
                    dataset = (Dataset)element.loadObject(null, true, true);
                } else {
                    dataset = (Dataset)prop.loadObject(null);
                }
                this.addTab(dataset);
                datasets.add(dataset);
            }
        }
        return datasets;
    }

    public Collection getDatasets() {
        HashSet<Dataset> datasets = new HashSet<Dataset>();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            DatasetTab tab = (DatasetTab)this.tabbedPane.getComponentAt(i);
            datasets.add(tab.getDataset());
        }
        return datasets;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public Dataset getSelectedDataset() {
        DatasetTab tab = this.getSelectedTab();
        if (tab != null) {
            return tab.getDataset();
        }
        return null;
    }

    protected boolean addTab(Dataset dataset) {
        int i = this.getTabIndex(dataset);
        if (i >= 0) {
            this.tabbedPane.setSelectedIndex(i);
            double[] x = dataset.getXPoints();
            double[] y = dataset.getYPoints();
            DatasetTab tab = this.getSelectedTab();
            tab.original.setName(dataset.getName());
            tab.dataset.clear();
            tab.dataset.append(x, y);
            tab.dataset.setName(dataset.getName());
            tab.dataTable.tableChanged(null);
            tab.refresh();
            this.refreshTabTitles();
            return false;
        }
        final DatasetTab tab = new DatasetTab(dataset);
        tab.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (!tab.fitCheckBox.isSelected()) {
                    tab.splitPanes[1].setDividerLocation(1.0);
                }
                if (!tab.statsCheckBox.isSelected()) {
                    tab.splitPanes[2].setDividerLocation(0);
                }
            }
        });
        String title = dataset.getName() + " (" + dataset.getColumnName(0) + ", " + dataset.getColumnName(1) + ")";
        OSPLog.finer("adding tab " + title);
        this.tabbedPane.addTab(title, tab);
        this.tabbedPane.setSelectedComponent(tab);
        tab.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
                DatasetTool.this.refreshTabTitles();
            }
        });
        this.validate();
        tab.init();
        tab.refresh();
        this.refreshTabTitles();
        return true;
    }

    protected DatasetTab getSelectedTab() {
        return (DatasetTab)this.tabbedPane.getSelectedComponent();
    }

    protected String open() {
        int result = OSPFrame.getChooser().showOpenDialog(null);
        if (result == 0) {
            OSPFrame.chooserDir = OSPFrame.getChooser().getCurrentDirectory().toString();
            String fileName = OSPFrame.getChooser().getSelectedFile().getAbsolutePath();
            fileName = XML.getRelativePath(fileName);
            return this.open(fileName);
        }
        return null;
    }

    protected int getTabIndex(Dataset data) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            DatasetTab tab = (DatasetTab)this.tabbedPane.getComponentAt(i);
            Dataset dataset = tab.getDataset();
            if (dataset != data && dataset.getID() != data.getID()) continue;
            return i;
        }
        return -1;
    }

    protected Dataset getDataset(int i) {
        if (i < 0 || i >= this.tabbedPane.getTabCount()) {
            return null;
        }
        DatasetTab tab = (DatasetTab)this.tabbedPane.getComponentAt(i);
        return tab.getDataset();
    }

    public void updateData(Dataset dataset) {
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            Dataset original = ((DatasetTab)this.tabbedPane.getComponentAt(i)).getDataset();
            if (original != dataset) continue;
            ((DatasetTab)this.tabbedPane.getComponentAt(i)).updateData();
        }
    }

    protected void removeTab(int index) {
        if (index >= 0 && index < this.tabbedPane.getTabCount()) {
            String title = this.tabbedPane.getTitleAt(index);
            OSPLog.finer("removing tab " + title);
            this.tabbedPane.removeTabAt(index);
            this.refreshTabTitles();
        }
    }

    protected void removeAllButTab(int index) {
        for (int i = this.tabbedPane.getTabCount() - 1; i >= 0; --i) {
            if (i == index) continue;
            String title = this.tabbedPane.getTitleAt(i);
            OSPLog.finer("removing tab " + title);
            this.tabbedPane.removeTabAt(i);
        }
        this.refreshTabTitles();
    }

    protected void removeAllTabs() {
        for (int i = this.tabbedPane.getTabCount() - 1; i >= 0; --i) {
            String title = this.tabbedPane.getTitleAt(i);
            OSPLog.finer("removing tab " + title);
            this.tabbedPane.removeTabAt(i);
        }
    }

    protected void refreshTabTitles() {
        int i;
        String[] tabTitles = new String[this.tabbedPane.getTabCount()];
        String[] datasetNames = new String[this.tabbedPane.getTabCount()];
        boolean singleName = true;
        for (i = 0; i < tabTitles.length; ++i) {
            DatasetTab tab = (DatasetTab)this.tabbedPane.getComponentAt(i);
            HighlightableDataset dataset = tab.displayData;
            tabTitles[i] = "(" + dataset.getColumnName(0) + ", " + dataset.getColumnName(1) + ")";
            datasetNames[i] = dataset.getName();
            if (datasetNames[i] == null || datasetNames[i].equals("")) {
                datasetNames[i] = ToolsRes.getString("Dataset.Name.Default");
            }
            singleName = singleName && datasetNames[i].equals(datasetNames[0]);
        }
        for (i = 0; i < tabTitles.length; ++i) {
            if (singleName && datasetNames[i] == ToolsRes.getString("Dataset.Name.Default")) continue;
            tabTitles[i] = datasetNames[i] + " " + tabTitles[i];
        }
        for (i = 0; i < tabTitles.length; ++i) {
            this.tabbedPane.setTitleAt(i, tabTitles[i]);
        }
    }

    protected void createGUI() {
        this.contentPane.setPreferredSize(dim);
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(1);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                DatasetTab tab = DatasetTool.this.getSelectedTab();
                if (tab == null) {
                    return;
                }
                if (!tab.fitCheckBox.isSelected()) {
                    tab.splitPanes[1].setDividerLocation(1.0);
                }
                if (!tab.statsCheckBox.isSelected()) {
                    tab.splitPanes[2].setDividerLocation(0);
                }
            }
        });
        this.tabbedPane = new JTabbedPane(1);
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() || e.getButton() == 3 || e.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1) {
                    final int index = DatasetTool.this.tabbedPane.getSelectedIndex();
                    DatasetTab tab = (DatasetTab)DatasetTool.this.tabbedPane.getComponentAt(index);
                    final HighlightableDataset dataset1 = tab.displayData;
                    final String plotVars = dataset1.getColumnName(0) + ", " + dataset1.getColumnName(1);
                    JMenuItem item = new JMenuItem(ToolsRes.getString("MenuItem.Close"));
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            DatasetTool.this.removeTab(index);
                        }
                    });
                    item = new JMenuItem(ToolsRes.getString("MenuItem.CloseOthers"));
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            DatasetTool.this.removeAllButTab(index);
                        }
                    });
                    item = new JMenuItem(ToolsRes.getString("MenuItem.CloseAll"));
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            DatasetTool.this.removeAllTabs();
                        }
                    });
                    ArrayList<String> tabs = new ArrayList<String>();
                    final String noName = ToolsRes.getString("Dataset.Name.Default");
                    for (int i = 0; i < DatasetTool.this.tabbedPane.getTabCount(); ++i) {
                        if (i == index) continue;
                        tab = (DatasetTab)DatasetTool.this.tabbedPane.getComponentAt(i);
                        HighlightableDataset target = tab.displayData;
                        if (!target.getColumnName(0).equals(dataset1.getColumnName(0))) continue;
                        tabs.add(String.valueOf(i));
                    }
                    if (!tabs.isEmpty()) {
                        AbstractAction operateAction = new AbstractAction(){

                            public void actionPerformed(ActionEvent e) {
                                int i = Integer.parseInt(e.getActionCommand());
                                DatasetTab tab = (DatasetTab)(this).DatasetTool.this.tabbedPane.getComponentAt(i);
                                HighlightableDataset dataset2 = tab.displayData;
                                String name1 = dataset1.getName();
                                String name2 = dataset2.getName();
                                String var1 = dataset1.getColumnName(1);
                                String var2 = dataset2.getColumnName(1);
                                if (name1 == null || name1.equals("")) {
                                    name1 = noName;
                                }
                                if (name2 == null || name2.equals("")) {
                                    name2 = noName;
                                }
                                if (name1.indexOf(" - ") > -1 || name1.indexOf(" + ") > -1 || name1.indexOf(" * ") > -1 || name1.indexOf(" / ") > -1) {
                                    name1 = "(" + name1 + ")";
                                }
                                if (var1.indexOf("-") > -1 || var1.indexOf("+") > -1 || var1.indexOf("*") > -1 || var1.indexOf("/") > -1) {
                                    var1 = "(" + var1 + ")";
                                }
                                if (name2.indexOf(" - ") > -1 || name2.indexOf(" + ") > -1 || name2.indexOf(" * ") > -1 || name2.indexOf(" / ") > -1) {
                                    name2 = "(" + name2 + ")";
                                }
                                if (var2.indexOf("-") > -1 || var2.indexOf("+") > -1 || var2.indexOf("*") > -1 || var2.indexOf("/") > -1) {
                                    var2 = "(" + var2 + ")";
                                }
                                String operation = "";
                                JMenuItem selectedItem = (JMenuItem)e.getSource();
                                if (selectedItem.getParent() == (this).DatasetTool.this.addMenu.getPopupMenu()) {
                                    operation = "+";
                                }
                                if (selectedItem.getParent() == (this).DatasetTool.this.subtractMenu.getPopupMenu()) {
                                    operation = "-";
                                } else if (selectedItem.getParent() == (this).DatasetTool.this.multiplyMenu.getPopupMenu()) {
                                    operation = "*";
                                } else if (selectedItem.getParent() == (this).DatasetTool.this.divideMenu.getPopupMenu()) {
                                    operation = "/";
                                }
                                String newName = name1;
                                if (!name1.equals(name2)) {
                                    newName = newName + " " + operation + " " + name2;
                                }
                                String newVar = var1 + operation + var2;
                                for (int j = 0; j < (this).DatasetTool.this.tabbedPane.getTabCount(); ++j) {
                                    tab = (DatasetTab)(this).DatasetTool.this.tabbedPane.getComponentAt(j);
                                    if (!newName.equals(tab.dataset.getName()) || !plotVars.equals(tab.dataset.getColumnName(0) + ", " + newVar)) continue;
                                    (this).DatasetTool.this.tabbedPane.setSelectedIndex(j);
                                    (this).DatasetTool.this.getSelectedTab().dataTable.tableChanged(null);
                                    DatasetTool.this.getSelectedTab().refresh();
                                    DatasetTool.this.refreshTabTitles();
                                    return;
                                }
                                double[] x1 = dataset1.getXPoints();
                                double[] y1 = dataset1.getYPoints();
                                double[] x2 = dataset2.getXPoints();
                                double[] y2 = dataset2.getYPoints();
                                int n = Math.min(y1.length, y2.length);
                                Dataset newdata = new Dataset();
                                for (int j = 0; j < n; ++j) {
                                    if (x1[j] != x2[j]) continue;
                                    if (operation.equals("+")) {
                                        newdata.append(x1[j], y1[j] + y2[j]);
                                        continue;
                                    }
                                    if (operation.equals("-")) {
                                        newdata.append(x1[j], y1[j] - y2[j]);
                                        continue;
                                    }
                                    if (operation.equals("*")) {
                                        newdata.append(x1[j], y1[j] * y2[j]);
                                        continue;
                                    }
                                    if (!operation.equals("/")) continue;
                                    newdata.append(x1[j], y1[j] / y2[j]);
                                }
                                if (newdata.getRowCount() > 0) {
                                    if (!newName.equals(noName)) {
                                        newdata.setName(newName);
                                    }
                                    newdata.setXYColumnNames(dataset1.getColumnName(0), var1 + operation + var2);
                                    newdata.setMarkerShape(dataset1.getMarkerShape());
                                    newdata.setMarkerSize(dataset1.getMarkerSize());
                                    newdata.setConnected(dataset1.isConnected());
                                    newdata.setLineColor(dataset1.getLineColor());
                                    newdata.setMarkerColor(dataset1.getFillColor(), dataset1.getEdgeColor());
                                    DatasetTool.this.addTab(newdata);
                                } else {
                                    String title = ToolsRes.getString("Dialog.AddFailed.Title");
                                    if (selectedItem.getParent() == (this).DatasetTool.this.subtractMenu.getPopupMenu()) {
                                        title = ToolsRes.getString("Dialog.SubtractFailed.Title");
                                    } else if (selectedItem.getParent() == (this).DatasetTool.this.divideMenu.getPopupMenu()) {
                                        title = ToolsRes.getString("Dialog.DivideFailed.Title");
                                    }
                                    JOptionPane.showMessageDialog((this).DatasetTool.this.tabbedPane, ToolsRes.getString("Dialog.OperationFailed.Message"), title, 2);
                                }
                            }
                        };
                        DatasetTool.this.addMenu = new JMenu(ToolsRes.getString("Menu.Add"));
                        DatasetTool.this.subtractMenu = new JMenu(ToolsRes.getString("Menu.Subtract"));
                        DatasetTool.this.multiplyMenu = new JMenu(ToolsRes.getString("Menu.MultiplyBy"));
                        DatasetTool.this.divideMenu = new JMenu(ToolsRes.getString("Menu.DivideBy"));
                        popup.addSeparator();
                        popup.add(DatasetTool.this.addMenu);
                        popup.add(DatasetTool.this.subtractMenu);
                        popup.add(DatasetTool.this.multiplyMenu);
                        popup.add(DatasetTool.this.divideMenu);
                        Iterator it = ((AbstractList)tabs).iterator();
                        while (it.hasNext()) {
                            String s = (String)it.next();
                            int i = Integer.parseInt(s);
                            item = new JMenuItem(DatasetTool.this.tabbedPane.getTitleAt(i));
                            item.setActionCommand(s);
                            item.addActionListener(operateAction);
                            DatasetTool.this.addMenu.add(item);
                            item = new JMenuItem(DatasetTool.this.tabbedPane.getTitleAt(i));
                            item.setActionCommand(s);
                            item.addActionListener(operateAction);
                            DatasetTool.this.subtractMenu.add(item);
                            item = new JMenuItem(DatasetTool.this.tabbedPane.getTitleAt(i));
                            item.setActionCommand(s);
                            item.addActionListener(operateAction);
                            DatasetTool.this.multiplyMenu.add(item);
                            item = new JMenuItem(DatasetTool.this.tabbedPane.getTitleAt(i));
                            item.setActionCommand(s);
                            item.addActionListener(operateAction);
                            DatasetTool.this.divideMenu.add(item);
                        }
                    }
                    popup.show(DatasetTool.this.tabbedPane, e.getX(), e.getY() + 8);
                }
            }
        });
        int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuBar menubar = new JMenuBar();
        JMenu fileMenu = new JMenu(ToolsRes.getString("Menu.File"));
        menubar.add(fileMenu);
        JMenuItem openItem = new JMenuItem(ToolsRes.getString("MenuItem.Open"));
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, keyMask));
        openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatasetTool.this.open();
            }
        });
        fileMenu.add(openItem);
        JMenuItem closeItem = new JMenuItem(ToolsRes.getString("MenuItem.Close"));
        closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = DatasetTool.this.tabbedPane.getSelectedIndex();
                DatasetTool.this.removeTab(index);
            }
        });
        fileMenu.add(closeItem);
        JMenuItem closeAllItem = new JMenuItem(ToolsRes.getString("MenuItem.CloseAll"));
        closeAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatasetTool.this.removeAllTabs();
            }
        });
        fileMenu.add(closeAllItem);
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem(ToolsRes.getString("MenuItem.Exit"));
        exitItem.setAccelerator(KeyStroke.getKeyStroke(81, keyMask));
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatasetTool.this.removeAllTabs();
                System.exit(0);
            }
        });
        fileMenu.add(exitItem);
        JMenu editMenu = new JMenu(ToolsRes.getString("Menu.Edit"));
        menubar.add(editMenu);
        AbstractAction copyAction = new AbstractAction(ToolsRes.getString("MenuItem.Copy")){

            public void actionPerformed(ActionEvent e) {
                Dataset dataset = DatasetTool.this.getSelectedDataset();
                if (dataset == null) {
                    return;
                }
                int i = DatasetTool.this.tabbedPane.getSelectedIndex();
                String title = DatasetTool.this.tabbedPane.getTitleAt(i);
                OSPLog.finest("copying " + title);
                XMLControlElement control = new XMLControlElement(dataset);
                StringSelection data = new StringSelection(control.toXML());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(data, data);
            }
        };
        JMenuItem copyItem = new JMenuItem(copyAction);
        copyItem.setAccelerator(KeyStroke.getKeyStroke(67, keyMask));
        editMenu.add(copyItem);
        AbstractAction pasteAction = new AbstractAction(ToolsRes.getString("MenuItem.Paste")){

            public void actionPerformed(ActionEvent e) {
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable data = clipboard.getContents(null);
                    String dataString = (String)data.getTransferData(DataFlavor.stringFlavor);
                    if (dataString != null) {
                        XMLControlElement control = new XMLControlElement();
                        control.readXML(dataString);
                        if (!control.failedToRead()) {
                            OSPLog.finest("pasting");
                        }
                        if (DatasetTool.this.loadDatasets(control).isEmpty()) {
                            OSPLog.finest("no datasets found");
                        }
                    }
                }
                catch (UnsupportedFlavorException ex) {
                }
                catch (IOException ex) {
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
        };
        JMenuItem pasteItem = new JMenuItem(pasteAction);
        pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, keyMask));
        editMenu.add(pasteItem);
        JMenu helpMenu = new JMenu(ToolsRes.getString("Menu.Help"));
        menubar.add(helpMenu);
        JMenuItem logItem = new JMenuItem(ToolsRes.getString("MenuItem.Log"));
        logItem.setAccelerator(KeyStroke.getKeyStroke(76, keyMask));
        logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DatasetTool.log.getLocation().x == 0 && DatasetTool.log.getLocation().y == 0) {
                    Point p = DatasetTool.this.getLocation();
                    ((Component)log).setLocation(p.x + 28, p.y + 28);
                }
                log.setVisible(true);
            }
        });
        helpMenu.add(logItem);
        helpMenu.addSeparator();
        JMenuItem aboutItem = new JMenuItem(ToolsRes.getString("MenuItem.About"));
        aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, keyMask));
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatasetTool.this.showAboutDialog();
            }
        });
        helpMenu.add(aboutItem);
        this.setJMenuBar(menubar);
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(x, y);
    }

    protected void showAboutDialog() {
        String aboutString = this.getName() + " 1.0  Jan 2006\n" + "Open Source Physics Project\n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(this, aboutString, ToolsRes.getString("Dialog.About.Title") + " " + this.getName(), 1);
    }

    public static void main(String[] args) {
        DatasetTool tool = DatasetTool.getTool();
        tool.setVisible(true);
    }

    static {
        log = OSPLog.getOSPLog();
        dim = new Dimension(720, 500);
        DATASET_TOOL = new DatasetTool();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

