/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.opensourcephysics.controls.Cryptic;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.JobManager;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;

public class EncryptionTool
extends OSPFrame
implements Tool {
    private static final String VERSION = " 1.0";
    private static Dimension dim = new Dimension(720, 500);
    private XMLTreePanel treePanel;
    private JPanel contentPane = new JPanel(new BorderLayout());
    private JobManager jobManager = new JobManager(this);
    private JTextField passwordField;
    private JCheckBox encryptedCheckBox;
    private JCheckBox previewCheckBox;
    private String fileName;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JLabel passwordLabel;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem openItem;
    private JMenuItem exitItem;
    private JMenuItem logItem;
    private JMenuItem aboutItem;
    private Icon openIcon;
    private JButton openButton;
    private Icon saveIcon;
    private JButton saveButton;
    private static final EncryptionTool ENCRYPTION_TOOL = new EncryptionTool();
    static /* synthetic */ Class class$org$opensourcephysics$controls$Cryptic;

    public static EncryptionTool getTool() {
        return ENCRYPTION_TOOL;
    }

    public EncryptionTool() {
        String name = "EncryptionTool";
        this.setName(name);
        this.createGUI();
        this.refreshGUI();
        Toolbox.addTool(name, this);
    }

    public EncryptionTool(String fileName) {
        this();
        this.open(fileName);
    }

    public String open(String fileName) {
        OSPLog.fine("opening " + fileName);
        XMLControlElement control = new XMLControlElement();
        control.setDecryptPolicy(5);
        control.read(fileName);
        if (control.failedToRead()) {
            return null;
        }
        String pass = control.getPassword();
        if (pass == null) {
            this.passwordField.setText(null);
            this.displayXML(control);
            this.encryptedCheckBox.setEnabled(true);
        } else if (this.passwordField.getText().equals(pass)) {
            this.displayXML(this.decrypt(control));
            this.encryptedCheckBox.setEnabled(true);
        } else {
            this.displayXML(control);
            this.encryptedCheckBox.setEnabled(false);
        }
        this.fileName = fileName;
        this.refreshGUI();
        return fileName;
    }

    public void send(Job job, Tool replyTo) throws RemoteException {
        XMLControlElement control = new XMLControlElement();
        control.setDecryptPolicy(5);
        control.readXML(job.getXML());
        if (control.failedToRead()) {
            return;
        }
        String pass = control.getPassword();
        if (pass == null) {
            this.passwordField.setText(null);
            this.displayXML(control);
        } else if (this.passwordField.getText().equals(pass)) {
            this.displayXML(this.decrypt(control));
        } else {
            this.displayXML(control);
        }
        this.fileName = null;
        this.refreshGUI();
        this.jobManager.log(job, replyTo);
    }

    public void refreshGUI() {
        String title = ToolsRes.getString("EncryptionTool.Title");
        if (this.fileName != null) {
            title = title + ": " + this.fileName;
        }
        this.setTitle(title);
        this.openButton.setToolTipText(ToolsRes.getString("EncryptionTool.Button.Open.ToolTip"));
        this.saveButton.setToolTipText(ToolsRes.getString("EncryptionTool.Button.Save.ToolTip"));
        this.passwordLabel.setText(ToolsRes.getString("EncryptionTool.Label.Password"));
        this.passwordField.setToolTipText(ToolsRes.getString("EncryptionTool.PasswordField.ToolTip"));
        this.encryptedCheckBox.setText(ToolsRes.getString("EncryptionTool.CheckBox.Encrypted"));
        this.encryptedCheckBox.setToolTipText(ToolsRes.getString("EncryptionTool.CheckBox.Encrypted.ToolTip"));
        this.previewCheckBox.setText(ToolsRes.getString("EncryptionTool.CheckBox.Preview"));
        this.previewCheckBox.setToolTipText(ToolsRes.getString("EncryptionTool.CheckBox.Preview.ToolTip"));
        this.fileMenu.setText(ToolsRes.getString("EncryptionTool.Menu.File"));
        this.openItem.setText(ToolsRes.getString("EncryptionTool.MenuItem.Open"));
        this.saveItem.setText(ToolsRes.getString("EncryptionTool.MenuItem.Save"));
        this.saveAsItem.setText(ToolsRes.getString("EncryptionTool.MenuItem.SaveAs"));
        this.exitItem.setText(ToolsRes.getString("EncryptionTool.MenuItem.Exit"));
        this.helpMenu.setText(ToolsRes.getString("EncryptionTool.Menu.Help"));
        this.logItem.setText(ToolsRes.getString("EncryptionTool.MenuItem.Log"));
        this.aboutItem.setText(ToolsRes.getString("EncryptionTool.MenuItem.About"));
        this.saveButton.setEnabled(this.encryptedCheckBox.isEnabled());
        this.saveItem.setEnabled(this.encryptedCheckBox.isEnabled());
        this.saveAsItem.setEnabled(this.encryptedCheckBox.isEnabled());
        XMLControlElement control = this.getCurrentControl();
        this.encryptedCheckBox.setSelected(control != null && control.getPassword() != null);
        this.passwordLabel.setEnabled(this.encryptedCheckBox.isSelected());
        this.passwordField.setEnabled(this.encryptedCheckBox.isSelected());
        this.previewCheckBox.setEnabled(this.encryptedCheckBox.isEnabled() && this.encryptedCheckBox.isSelected());
        this.previewCheckBox.setSelected(control != null && control.getObjectClass() == (class$org$opensourcephysics$controls$Cryptic == null ? (class$org$opensourcephysics$controls$Cryptic = EncryptionTool.class$("org.opensourcephysics.controls.Cryptic")) : class$org$opensourcephysics$controls$Cryptic));
    }

    public static void main(String[] args) {
        EncryptionTool tool = EncryptionTool.getTool();
        tool.setDefaultCloseOperation(3);
        tool.open("Untitled.xset");
        tool.setVisible(true);
    }

    private XMLControlElement getCurrentControl() {
        if (this.treePanel == null) {
            return null;
        }
        XMLControl control = this.treePanel.getControl();
        if (control instanceof XMLControlElement) {
            return (XMLControlElement)control;
        }
        return null;
    }

    private void displayXML(XMLControlElement control) {
        if (this.treePanel != null) {
            this.contentPane.remove(this.treePanel);
        }
        this.treePanel = new XMLTreePanel(control, false);
        this.contentPane.add((Component)this.treePanel, "Center");
        this.validate();
        this.refreshGUI();
    }

    private void setPassword(String password) {
        XMLControlElement control = this.getCurrentControl();
        if (control == null) {
            return;
        }
        String pass = control.getPassword();
        if (!this.encryptedCheckBox.isEnabled()) {
            boolean verified = password.equals(pass);
            if (verified) {
                this.displayXML(this.decrypt(control));
                this.encryptedCheckBox.setEnabled(true);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (control.getObjectClass() == (class$org$opensourcephysics$controls$Cryptic == null ? (class$org$opensourcephysics$controls$Cryptic = EncryptionTool.class$("org.opensourcephysics.controls.Cryptic")) : class$org$opensourcephysics$controls$Cryptic)) {
            XMLControlElement temp = this.decrypt(control);
            temp.setPassword(password);
            temp = this.encrypt(temp);
            control.setValue("cryptic", temp.getString("cryptic"));
            this.treePanel.refresh();
        } else {
            if (password.equals("") && !this.encryptedCheckBox.isSelected()) {
                password = null;
            }
            control.setPassword(password);
            this.treePanel.refresh();
        }
        this.refreshGUI();
    }

    private XMLControlElement encrypt(XMLControlElement control) {
        if (control.getObjectClass() == (class$org$opensourcephysics$controls$Cryptic == null ? (class$org$opensourcephysics$controls$Cryptic = EncryptionTool.class$("org.opensourcephysics.controls.Cryptic")) : class$org$opensourcephysics$controls$Cryptic)) {
            return control;
        }
        String xml = control.toXML();
        Cryptic cryptic = new Cryptic(xml);
        XMLControlElement encrypted = new XMLControlElement(cryptic);
        encrypted.setPassword(control.getPassword());
        return encrypted;
    }

    private XMLControlElement decrypt(XMLControlElement control) {
        if (control.getObjectClass() != (class$org$opensourcephysics$controls$Cryptic == null ? (class$org$opensourcephysics$controls$Cryptic = EncryptionTool.class$("org.opensourcephysics.controls.Cryptic")) : class$org$opensourcephysics$controls$Cryptic)) {
            return control;
        }
        Cryptic cryptic = (Cryptic)control.loadObject(null);
        String xml = cryptic.decrypt();
        XMLControlElement decrypted = new XMLControlElement(xml);
        return decrypted;
    }

    private String open() {
        int result = OSPFrame.getChooser().showOpenDialog(this);
        if (result == 0) {
            OSPFrame.chooserDir = OSPFrame.getChooser().getCurrentDirectory().toString();
            String fileName = OSPFrame.getChooser().getSelectedFile().getAbsolutePath();
            fileName = XML.getRelativePath(fileName);
            return this.open(fileName);
        }
        return null;
    }

    private String save(String fileName) {
        XMLControlElement control;
        if (fileName == null || fileName.equals("")) {
            return null;
        }
        if (this.passwordField.getBackground() == Color.yellow) {
            this.passwordField.setBackground(Color.white);
            this.setPassword(this.passwordField.getText());
        }
        if ((control = this.getCurrentControl()) == null) {
            return null;
        }
        if (control.getObjectClass() == (class$org$opensourcephysics$controls$Cryptic == null ? (class$org$opensourcephysics$controls$Cryptic = EncryptionTool.class$("org.opensourcephysics.controls.Cryptic")) : class$org$opensourcephysics$controls$Cryptic)) {
            control = this.decrypt(control);
        }
        if (control.write(fileName) == null) {
            return null;
        }
        this.fileName = fileName;
        this.refreshGUI();
        return fileName;
    }

    private String saveAs() {
        int result = OSPFrame.getChooser().showSaveDialog(this);
        if (result == 0) {
            int selected;
            OSPFrame.chooserDir = OSPFrame.getChooser().getCurrentDirectory().toString();
            File file = OSPFrame.getChooser().getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, ToolsRes.getString("EncryptionTool.Dialog.ReplaceFile.Message") + file.getName() + "?", ToolsRes.getString("EncryptionTool.Dialog.ReplaceFile.Title"), 1)) != 0) {
                return null;
            }
            String fileName = file.getAbsolutePath();
            if (fileName == null || fileName.trim().equals("")) {
                return null;
            }
            return this.save(XML.getRelativePath(fileName));
        }
        return null;
    }

    private void createGUI() {
        this.contentPane.setPreferredSize(dim);
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(1);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.contentPane.add((Component)toolbar, "North");
        String imageFile = "/org/opensourcephysics/resources/tools/images/open.gif";
        this.openIcon = ResourceLoader.getIcon(imageFile);
        this.openButton = new JButton(this.openIcon);
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncryptionTool.this.open();
            }
        });
        toolbar.add(this.openButton);
        imageFile = "/org/opensourcephysics/resources/tools/images/save.gif";
        this.saveIcon = ResourceLoader.getIcon(imageFile);
        this.saveButton = new JButton(this.saveIcon);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncryptionTool.this.save(EncryptionTool.this.fileName);
            }
        });
        toolbar.add(this.saveButton);
        toolbar.addSeparator();
        this.passwordLabel = new JLabel();
        this.passwordLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.passwordField = new JTextField(20);
        this.passwordField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EncryptionTool.this.passwordField.setBackground(Color.white);
                    EncryptionTool.this.setPassword(EncryptionTool.this.passwordField.getText());
                } else if (e.getKeyChar() != '\uffff') {
                    EncryptionTool.this.passwordField.setBackground(Color.yellow);
                }
            }
        });
        this.passwordField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (EncryptionTool.this.passwordField.getBackground() == Color.yellow) {
                    EncryptionTool.this.passwordField.setBackground(Color.white);
                    EncryptionTool.this.setPassword(EncryptionTool.this.passwordField.getText());
                }
            }
        });
        toolbar.add(this.passwordLabel);
        toolbar.add(this.passwordField);
        this.encryptedCheckBox = new JCheckBox("");
        this.encryptedCheckBox.setEnabled(false);
        this.encryptedCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EncryptionTool.this.encryptedCheckBox.isSelected()) {
                    EncryptionTool.this.setPassword(EncryptionTool.this.passwordField.getText());
                } else {
                    XMLControlElement control = EncryptionTool.this.getCurrentControl();
                    if (control.getObjectClass() == (class$org$opensourcephysics$controls$Cryptic == null ? (class$org$opensourcephysics$controls$Cryptic = EncryptionTool.class$("org.opensourcephysics.controls.Cryptic")) : class$org$opensourcephysics$controls$Cryptic)) {
                        control = EncryptionTool.this.decrypt(control);
                        control.setPassword(null);
                        EncryptionTool.this.displayXML(control);
                    }
                    EncryptionTool.this.setPassword("");
                }
            }
        });
        this.encryptedCheckBox.setContentAreaFilled(false);
        toolbar.add(this.encryptedCheckBox);
        this.previewCheckBox = new JCheckBox("");
        this.previewCheckBox.setOpaque(false);
        this.previewCheckBox.setEnabled(false);
        this.previewCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XMLControlElement control = EncryptionTool.this.getCurrentControl();
                if (EncryptionTool.this.previewCheckBox.isSelected()) {
                    EncryptionTool.this.displayXML(EncryptionTool.this.encrypt(control));
                } else {
                    EncryptionTool.this.displayXML(EncryptionTool.this.decrypt(control));
                }
            }
        });
        toolbar.add(this.previewCheckBox);
        int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuBar menubar = new JMenuBar();
        this.fileMenu = new JMenu();
        menubar.add(this.fileMenu);
        this.openItem = new JMenuItem();
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, keyMask));
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncryptionTool.this.open();
            }
        });
        this.fileMenu.add(this.openItem);
        this.fileMenu.addSeparator();
        this.saveItem = new JMenuItem();
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, keyMask));
        this.saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncryptionTool.this.save(EncryptionTool.this.fileName);
            }
        });
        this.saveItem.setEnabled(false);
        this.fileMenu.add(this.saveItem);
        this.saveAsItem = new JMenuItem();
        this.saveAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncryptionTool.this.saveAs();
            }
        });
        this.saveAsItem.setEnabled(false);
        this.fileMenu.add(this.saveAsItem);
        this.exitItem = new JMenuItem(ToolsRes.getString("MenuItem.Exit"));
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, keyMask));
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitItem);
        this.helpMenu = new JMenu();
        menubar.add(this.helpMenu);
        this.logItem = new JMenuItem();
        this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, keyMask));
        this.logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OSPLog log = OSPLog.getOSPLog();
                if (log.getLocation().x == 0 && log.getLocation().y == 0) {
                    Point p = EncryptionTool.this.getLocation();
                    ((Component)log).setLocation(p.x + 28, p.y + 28);
                }
                OSPLog.showLog();
            }
        });
        this.helpMenu.add(this.logItem);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, keyMask));
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String toolname = ToolsRes.getString("EncryptionTool.About.ToolName");
                String aboutString = toolname + EncryptionTool.VERSION + XML.NEW_LINE + ToolsRes.getString("EncryptionTool.About.OSPName") + XML.NEW_LINE + "www.opensourcephysics.org";
                JOptionPane.showMessageDialog(EncryptionTool.this, aboutString, ToolsRes.getString("EncryptionTool.About.Title"), 1);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.setJMenuBar(menubar);
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(x, y);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

